/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.SpecialAssignmentCalculator;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.ListEmitMethods;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import apex.jorje.services.I18nSupport;
import java.util.Objects;
import org.objectweb.asm.Label;

public class ArrayLoadExpression
extends Expression {
    private final Location loc;
    private final Expression innerExpression;
    private final Expression index;

    public ArrayLoadExpression(AstNode definingNode, Expr.ArrayExpr expr) {
        super(definingNode);
        this.loc = Locations.from(expr);
        this.innerExpression = AstNodes.get().create((AstNode)this, expr.expr);
        this.index = AstNodes.get().create((AstNode)this, expr.index);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.innerExpression.traverse(visitor, scope);
            this.index.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.innerExpression.validate(symbols, scope);
        this.index.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.innerExpression, this.index)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (!CollectionTypeInfoUtil.isList(this.innerExpression.getType())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.list.type", this.innerExpression.getType()));
        } else {
            TypeInfo elementType = TypeInfoUtil.getRealType(symbols, this.getDefiningType(), CollectionTypeInfoUtil.getElementType(this.innerExpression.getType()));
            this.setType(elementType);
        }
        if (!Objects.equals(this.index.getType(), TypeInfos.INTEGER)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.list.index.type", TypeInfos.INTEGER, this.index.getType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        this.innerExpression.emit(emitter);
        this.index.emit(emitter);
        if (SpecialAssignmentCalculator.get().calculate(this)) {
            emitter.emit(Locations.NONE, 92);
        }
        emitter.emit(Locations.NONE, 89);
        Label nonNull = new Label();
        emitter.emitJump(this.loc, 199, nonNull);
        emitter.emit(this.loc, SystemEmitMethods.THROW_LIST_INDEX_NULL);
        emitter.emit(nonNull);
        emitter.emit(this.loc, ListEmitMethods.GET_BYTECODE);
        emitter.push(Locations.NONE, TypeEraser.eraseBytecodeName(this.getType()));
        emitter.emit(Locations.NONE, SystemEmitMethods.CONVERT);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public Expression getInnerExpression() {
        return this.innerExpression;
    }
}

