/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.context;

import apex.common.base.WeakStringInterner;
import apex.jorje.data.Identifiers;
import apex.jorje.data.Location;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.MethodStack;
import apex.jorje.semantic.ast.member.MethodEmit;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.SystemModeEmit;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.SharingType;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.ProxyMethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.MoreLists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;

public class ProxyMethodTable {
    static final String NAME_PREFIX = "__sfdc__proxy_";
    static final ModifierGroup MODIFIERS = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.STATIC, ModifierTypeInfos.PRIVATE, ModifierTypeInfos.BRIDGE).build();
    private final Multimap<TypeInfo, ProxyPair> proxies;
    private final Emitter emitter;
    private boolean proxy;

    ProxyMethodTable(Emitter emitter) {
        this.emitter = emitter;
        this.proxies = ArrayListMultimap.create();
        this.proxy = false;
    }

    static List<Parameter> removeNames(List<Parameter> parameters) {
        return parameters.stream().map(parameter -> Parameter.builder().setDefiningType(parameter.getDefiningType()).setType(parameter.getType()).setModifiers(parameter.getModifierInfo()).build()).collect(MoreLists.toImmutableList(parameters.size()));
    }

    public MethodInfo get(Location loc, TypeInfo definingType, TypeInfo callerType, MethodInfo method) {
        return this.proxy && method.getGenerated().isProxied ? this.create(loc, definingType, callerType, method) : null;
    }

    int parameterSize(MethodInfo method) {
        return method.getParameters().size() + (method.getModifiers().has(ModifierTypeInfos.STATIC) ? 0 : 1);
    }

    MethodInfo create(Location loc, TypeInfo definingType, TypeInfo callerType, MethodInfo method) {
        TypeInfo type = this.emitter.getType();
        ArrayList<Parameter> bindParameters = new ArrayList<Parameter>(method.getParameters().size() + 1);
        ArrayList<TypeInfo> emitParameterTypes = new ArrayList<TypeInfo>(method.getParameters().size() + 1);
        if (!method.getModifiers().has(ModifierTypeInfos.STATIC) && method.getInvocationType() != InvocationType.BOOTSTRAP) {
            TypeInfo rawType = GenericTypeInfoUtil.getRootType(callerType);
            bindParameters.add(Parameter.builder().setDefiningType(definingType).setType(rawType).build());
            emitParameterTypes.add(rawType);
        }
        bindParameters.addAll(method.getParameters());
        List<Parameter> parameters = ProxyMethodTable.removeNames(bindParameters);
        emitParameterTypes.addAll(method.getEmitSignature().getParameterTypes());
        int index = this.proxies.get(type).size();
        MethodInfo proxy = StandardMethodInfo.builder().setDefiningType(type).copyParameters(parameters).setReturnType(method.getReturnType()).setName(Identifiers.newIdentifier(loc, WeakStringInterner.get().intern(NAME_PREFIX + index))).setModifiers(MODIFIERS).setGenerated(Generated.ANONYMOUS).setEmitSignature(SignatureFactory.create(method.getEmitSignature().getName(), method.getEmitSignature().getReturnType(), emitParameterTypes)).build();
        MethodInfo newMethod = method;
        if (!method.getModifiers().has(ModifierTypeInfos.STATIC)) {
            newMethod = new ProxyMethodInfo(callerType, method);
        }
        this.proxies.put(type, new ProxyPair(newMethod, proxy));
        return proxy;
    }

    public void emit() {
        TypeInfo type = this.emitter.getType();
        for (ProxyPair pair : this.proxies.get(type)) {
            Emit method = methodEmitter -> {
                MethodStack.MethodContext context = methodEmitter.getMethodStack().peek();
                for (int i = 0; i < this.parameterSize(pair.proxy); ++i) {
                    context.getLocalVariables().add();
                }
                Holder retValue = new Holder();
                Emit body = bodyEmitter -> {
                    for (int i = 0; i < this.parameterSize(pair.proxy); ++i) {
                        bodyEmitter.emitVar(pair.proxy.getLoc(), 25, i);
                    }
                    bodyEmitter.emit(pair.proxy.getLoc(), pair.method.getAsmMethod());
                    if (pair.proxy.hasReturnValue()) {
                        retValue.value = methodEmitter.getMethodStack().peek().getLocalVariables().add();
                        bodyEmitter.emitVar(pair.proxy.getLoc(), 58, (Integer)retValue.value);
                    }
                };
                SystemModeEmit.emitter().withType(SharingType.INHERIT).withBody(body).withWebServiceInvocation(pair.method.getModifiers().has(ModifierTypeInfos.WEB_SERVICE)).emit(methodEmitter);
                if (pair.proxy.hasReturnValue()) {
                    assert (retValue.value != null);
                    methodEmitter.emitVar(pair.proxy.getLoc(), 25, (Integer)retValue.value);
                    methodEmitter.emit(pair.proxy.getLoc(), 176);
                } else {
                    methodEmitter.emit(pair.proxy.getLoc(), 177);
                }
            };
            new MethodEmit(pair.proxy, method).emit(this.emitter);
        }
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    private static class ProxyPair {
        private final MethodInfo method;
        private final MethodInfo proxy;

        private ProxyPair(MethodInfo method, MethodInfo proxy) {
            this.method = method;
            this.proxy = proxy;
        }
    }
}

