/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.common.base.Result;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.exception.SemanticException;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.VirtualMethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.symbol.visibility.VisibilityUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.Multimap;

public class VirtualMethodsCreator {
    private VirtualMethodsCreator() {
    }

    public static void create(Multimap<TypeInfo, CompilationException> errorsMap, SymbolResolver symbols, TypeInfo type) {
        TypeInfo superType;
        boolean hasVisibleSuperType;
        MethodTable virtualMethods = type.virtualMethods();
        if (virtualMethods.isResolved()) {
            return;
        }
        boolean bl = hasVisibleSuperType = type.parents().isResolved() && type.parents().superType() != null && Visibility.isTypeVisible(symbols.getAccessEvaluator(), type, type.parents().superType(), Visibility.ReferencedFromTestMethod.NO, Visibility.CheckGenericTypeArguments.YES);
        if (hasVisibleSuperType) {
            superType = type.parents().superType();
            if (!superType.virtualMethods().isResolved()) {
                VirtualMethodsCreator.create(errorsMap, symbols, superType);
            }
        } else {
            superType = TypeInfos.OBJECT;
        }
        for (MethodInfo method : superType.virtualMethods().getInstance()) {
            Result<Void> result = virtualMethods.addNoDuplicatesAllowed(VirtualMethodInfo.create(method));
            if (!result.hasError()) continue;
            errorsMap.put(type, new SemanticException(method.getLoc(), result.getError()));
        }
        if (type.parents().isResolved() && type.parents().superType() != null) {
            virtualMethods.remove(SignatureFactory.create("clone", type.parents().superType()));
        }
        boolean isApexSourceBased = type.getCodeUnitDetails().isApexSourceBased();
        for (MethodInfo method : type.methods().getInstance()) {
            Result<Void> result;
            boolean isVisible;
            VirtualMethodsCreator.removeObjectEqualsIfNecessary(virtualMethods, method);
            VirtualMethodsCreator.removeObjectHashCodeIfNecessary(virtualMethods, method);
            MethodInfo parent = virtualMethods.get(method.getSignature());
            boolean bl2 = isVisible = isApexSourceBased && parent != null && Visibility.isMethodVisible(symbols.getAccessEvaluator(), method.getDefiningType(), parent, Visibility.ReferencedFromTestMethod.NO);
            if (isVisible && !VirtualMethodsCreator.isSpecial(parent)) {
                boolean overrideIsRequired;
                boolean isNotMocked;
                boolean bl3 = isNotMocked = !type.getCodeUnitDetails().isMocked();
                if (isNotMocked && parent.getModifiers().none(ModifierTypeInfos.VIRTUAL, ModifierTypeInfos.ABSTRACT)) {
                    errorsMap.put(type, new SemanticException(method.getLoc(), I18nSupport.getLabel("non.virtual.methods.cannot.override", method.getSignature())));
                    continue;
                }
                boolean bl4 = overrideIsRequired = VirtualMethodsCreator.overrideIsRequired(parent) && type.getUnitType() != UnitType.INTERFACE;
                if (isNotMocked && overrideIsRequired) {
                    if (method.getModifiers().not(ModifierTypeInfos.OVERRIDE)) {
                        errorsMap.put(type, new SemanticException(method.getLoc(), I18nSupport.getLabel("methods.must.override", method.getSignature())));
                        continue;
                    }
                    if (VisibilityUtil.isLowerForOverride(parent.getModifiers(), method.getModifiers())) {
                        errorsMap.put(type, new SemanticException(method.getLoc(), I18nSupport.getLabel("cannot.reduce.method.visibility.override", method.getSignature())));
                        continue;
                    }
                }
            } else if (method.getModifiers().has(ModifierTypeInfos.OVERRIDE)) {
                errorsMap.put(type, new SemanticException(method.getLoc(), I18nSupport.getLabel("method.does.not.override", method.getSignature())));
                continue;
            }
            if (parent != null && !ObjectMethods.isEqualsMethod(method)) {
                method.setCanonicalName(parent.getCanonicalName());
            }
            if (!(result = virtualMethods.addDuplicatesAllowed(method)).hasError()) continue;
            errorsMap.put(type, new SemanticException(method.getLoc(), result.getError()));
        }
        if (type.getModifiers().not(ModifierTypeInfos.ABSTRACT) && type.getUnitType() == UnitType.CLASS) {
            for (MethodInfo method : virtualMethods.getInstance()) {
                if (method.getDefiningType() == type || !method.getModifiers().has(ModifierTypeInfos.ABSTRACT)) continue;
                errorsMap.put(type, new SemanticException(method.getLoc(), I18nSupport.getLabel("class.must.implement.abstract.method", type, method)));
            }
        }
        virtualMethods.resolve();
    }

    private static boolean isSpecial(MethodInfo parent) {
        return parent.getInvocationType() == InvocationType.SPECIAL;
    }

    private static void removeObjectEqualsIfNecessary(MethodTable methodTable, MethodInfo method) {
        MethodInfo equalsMethod;
        if (method != null && method.getName().equalsIgnoreCase("equals") && method.getParameterTypes().size() == 1 && (equalsMethod = methodTable.get(ObjectMethods.EQUALS_METHOD.get().getSignature())) != null && VirtualMethodsCreator.isObjectOrApexObject(equalsMethod.getDefiningType())) {
            methodTable.remove(equalsMethod.getSignature());
        }
    }

    private static void removeObjectHashCodeIfNecessary(MethodTable methodTable, MethodInfo method) {
        MethodInfo hashCodeMethod;
        if (method != null && method.getName().equalsIgnoreCase("hashCode") && !method.getReturnType().equals(TypeInfos.INTEGER) && method.getParameterTypes().isEmpty() && (hashCodeMethod = methodTable.get(ObjectMethods.HASH_CODE_METHOD.get().getSignature())) != null && VirtualMethodsCreator.isObjectOrApexObject(hashCodeMethod.getDefiningType())) {
            methodTable.remove(hashCodeMethod.getSignature());
        }
    }

    private static boolean isObjectOrApexObject(TypeInfo type) {
        return TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.APEX_OBJECT) || TypeInfoEquivalence.isEquivalent(type, TypeInfos.OBJECT);
    }

    private static boolean overrideIsRequired(MethodInfo original) {
        return !VirtualMethodsCreator.isObjectOrApexObject(original.getDefiningType()) || !"equals".equalsIgnoreCase(original.getName()) && !"hashCode".equalsIgnoreCase(original.getName());
    }
}

