/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.TriggerUsage;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.AdditionalInfo;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.TriggerUsageCalculator;
import apex.jorje.semantic.ast.compilation.UserTriggerMembers;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.services.I18nSupport;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;

public class UserTrigger
extends Compilation {
    private final TypeInfo triggerType;
    private final Location loc;
    private final Identifier name;
    private final List<Identifier> targetName;
    private final Set<TriggerUsage> usages;
    private final UserTriggerMembers members;
    private final AdditionalInfo additionalInfo;
    private final ModifierNode modifiers;

    public UserTrigger(Errors errors, SourceFile source, CompilationUnit.TriggerDeclUnit trigger) {
        this.loc = trigger.name.getLoc();
        this.name = trigger.name;
        this.triggerType = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setViaSource(source, trigger)).build();
        this.targetName = trigger.target;
        this.usages = TriggerUsageCalculator.get().resolve(errors, this, trigger.usages);
        this.members = UserTriggerMembers.create(this, errors, source, this.triggerType, trigger);
        this.additionalInfo = AdditionalInfo.builder().setDefiningNode(this).setInnerTypes(this.members.getInnerTypes()).setProperties(this.members.getProperties()).build();
        this.modifiers = new ModifierNode(this, this.triggerType.getModifiers());
    }

    public List<Identifier> getTargetName() {
        return this.targetName;
    }

    public TypeRef getSObjectTypeRef() {
        return TypeRefs.newClassTypeRef(this.targetName, ImmutableList.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                this.modifiers.traverse(visitor, scope);
                for (Compilation innerType : this.members.getInnerTypes()) {
                    innerType.traverse(visitor, scope);
                }
                for (Field field : this.members.getFields()) {
                    field.traverse(visitor, scope);
                }
                for (Property property : this.members.getProperties()) {
                    property.traverse(visitor, scope);
                }
                for (Method method : this.members.getMethods()) {
                    method.traverse(visitor, scope);
                }
                this.additionalInfo.traverse(visitor, scope);
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            TypeInfo foundTypeInfo;
            scope.getErrors().addIfError((AstNode)this, this.name.getLoc(), IdentifierValidator.builder(this.triggerType, this.name.getValue(), IdentifierValidator.Type.TRIGGER).asTopLevel(true).validate());
            if (scope.getErrors().isInvalid(this)) {
                // empty if block
            }
            if (!(foundTypeInfo = this.triggerType.getCodeUnitDetails().getTriggerType().resolve(symbols, this.triggerType)).isResolved()) {
                scope.getErrors().markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(foundTypeInfo));
            } else if (!SObjectTypeInfoUtil.isConcreteSObject(foundTypeInfo)) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.trigger.object", foundTypeInfo));
            }
            if (foundTypeInfo instanceof SObjectTypeInfo) {
                SObjectTypeInfo sobjectType = (SObjectTypeInfo)foundTypeInfo;
                if (!sobjectType.getMetadata().isTriggerable()) {
                    scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("trigger.not.supported", sobjectType));
                }
                if (sobjectType.getMetadata().isPlatformEvent() && (this.usages.size() != 1 || Iterables.getOnlyElement(this.usages) != TriggerUsage.AFTER_INSERT)) {
                    scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.trigger.platform.event", foundTypeInfo));
                }
            }
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.validate(symbols, scope);
            }
            for (Field field : this.members.getFields()) {
                field.validate(symbols, scope);
            }
            for (Property property : this.members.getProperties()) {
                property.validate(symbols, scope);
            }
            for (Method method : this.members.getMethods()) {
                method.validate(symbols, scope);
            }
            this.additionalInfo.validate(symbols, scope);
            this.modifiers.validate(symbols, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Emitter emitter) {
        CompilationOutput.Builder output = CompilationOutput.builder(this.triggerType);
        output.setTriggerInfo((SObjectTypeInfo)this.triggerType.getCodeUnitDetails().getTriggerType().get(), this.usages);
        TypeStack.TypeContext clazz = TypeStack.TypeContext.builder().setType(this.triggerType).build();
        emitter.getTypeStack().push(clazz);
        try {
            emitter.getAnnotationVisitor().set((ClassVisitor)clazz.getClassWriter());
            this.modifiers.emit(emitter);
            emitter.getAnnotationVisitor().unset();
            this.additionalInfo.emitAnnotation(emitter);
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.emit(emitter);
                output.addInnerType(innerType);
            }
            for (Field field : this.members.getFields()) {
                field.emit(emitter);
            }
            for (Property property : this.members.getProperties()) {
                property.emit(emitter);
            }
            for (Method method : this.members.getMethods()) {
                method.emit(emitter);
            }
            this.additionalInfo.emit(emitter);
        }
        finally {
            emitter.getTypeStack().pop();
            this.setOutput(output.setBytes(clazz.getClassWriter().toByteArray()).setLines(clazz.getKnownCodeLocations()).build());
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.triggerType;
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public TypeInfo getTargetType() {
        return this.triggerType.getCodeUnitDetails().getTriggerType().get();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("triggerType", this.triggerType).add("members", this.members).toString();
    }
}

