/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.InterfaceDecl;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroupBuilder;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class UserInterfaceMembers {
    private final List<Method> methods;

    private UserInterfaceMembers(Builder builder) {
        this.methods = builder.methodBuilder.build();
    }

    public static UserInterfaceMembers create(UserInterface node, TypeInfo interfaceType, InterfaceDecl body) {
        ModifierGroupBuilder methodModifiers = ModifierGroup.builder().addModifiers(interfaceType.getModifiers().has(ModifierTypeInfos.GLOBAL) ? ModifierTypeInfos.GLOBAL : ModifierTypeInfos.PUBLIC, ModifierTypeInfos.ABSTRACT, ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED);
        Builder builder = new Builder(node, methodModifiers);
        for (BlockMember member : AstNodes.filterNotNull(body.members)) {
            member._switch(builder);
        }
        return new UserInterfaceMembers(builder);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("methods", this.methods).toString();
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    private static class Builder
    extends BlockMember.SwitchBlockWithDefault {
        private final UserInterface node;
        private final ModifierGroupBuilder methodModifiers;
        private final ImmutableList.Builder<Method> methodBuilder;

        private Builder(UserInterface node, ModifierGroupBuilder methodModifiers) {
            this.node = node;
            this.methodModifiers = methodModifiers;
            this.methodBuilder = ImmutableList.builder();
        }

        @Override
        public void _case(BlockMember.MethodMember method) {
            this.methodModifiers.setLoc(method.methodDecl.name.getLoc());
            this.methodBuilder.add((Object)MethodFactory.createUserMethod(this.node, this.methodModifiers.build(), method.methodDecl));
        }

        @Override
        protected void _default(BlockMember x) {
            throw new UnexpectedCodePathException();
        }
    }
}

