/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.common.base.Result;
import apex.common.base.VoidResult;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.I18nSupport;

public abstract class Compilation
implements AstNode {
    public static final Compilation INVALID = new Compilation(){

        @Override
        public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        }

        @Override
        public void validate(SymbolResolver symbols, ValidationScope scope) {
            scope.getErrors().markInvalid(this);
        }

        @Override
        public void emit(Emitter emitter) {
        }

        @Override
        public TypeInfo getDefiningType() {
            return UnresolvedTypeInfoFactory.create(I18nSupport.getLabel("invalid.unit"));
        }

        public String toString() {
            return "Invalid Compilation";
        }
    };
    private CompilationOutput output = null;

    Compilation() {
    }

    static Result<Void> validateHasTopLevelModifiers(Compilation compilation) {
        ModifierGroup modifiers;
        if (TypeInfoUtil.isTopLevel(compilation.getDefiningType()) && !(modifiers = compilation.getDefiningType().getModifiers()).has(ModifierTypeInfos.GLOBAL) && !modifiers.has(ModifierTypeInfos.PUBLIC) && !modifiers.has(AnnotationTypeInfos.IS_TEST)) {
            return VoidResult.error(I18nSupport.getLabel("toplevel.must.be.public.or.global"));
        }
        return VoidResult.of();
    }

    public CompilationOutput getOutput() {
        assert (this.output != null) : "output is not set";
        return this.output;
    }

    void setOutput(CompilationOutput output) {
        this.output = output;
    }
}

