/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Identifier;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.common.iterable.CaseInsensitiveSet;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class ArgumentTypeCalculator {
    private static final ArgumentTypeCalculator INSTANCE = new ArgumentTypeCalculator();

    private ArgumentTypeCalculator() {
    }

    static ArgumentTypeCalculator get() {
        return INSTANCE;
    }

    List<TypeInfo> toArgumentTypes(Errors errors, AstNode node, Optional<List<Identifier>> typeArguments) {
        if (typeArguments.isPresent()) {
            ArrayList<TypeInfo> argumentTypes = new ArrayList<TypeInfo>(typeArguments.get().size());
            CaseInsensitiveSet names = new CaseInsensitiveSet();
            for (Identifier identifier : typeArguments.get()) {
                if (names.contains(identifier.getValue())) {
                    errors.markInvalid(node, identifier.getLoc(), I18nSupport.getLabel("duplicate.type.parameter", identifier.getValue()));
                    continue;
                }
                names.add(identifier.getValue());
                argumentTypes.add(ArgumentTypeInfo.create(identifier.getValue()));
            }
            return argumentTypes;
        }
        return ImmutableList.of();
    }
}

