/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.common.base.MoreStrings;
import apex.common.collect.MoreIterables;
import apex.jorje.data.Location;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.member.PropertyInfo;
import apex.jorje.semantic.ast.modifier.SharingType;
import apex.jorje.semantic.ast.modifier.SharingTypeCalculator;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.iterator.BitSetIterator;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameProvider;
import apex.jorje.services.I18nSupport;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.axis.encoding.Base64;
import org.objectweb.asm.AnnotationVisitor;

class AdditionalInfo
implements AstNode {
    static final String INNER_TYPES = "__sfdcInnerTypes";
    static final String PROPERTIES = "__sfdcProperties";
    static final String PARAMETERIZED_TYPES = "__sfdcParameterizedTypes";
    static final String ADDITIONAL_CODE_LOCATIONS = "_sfdcAdditionalCodeLocations";
    static final String SUPPRESSED_CODE_LOCATIONS = "_sfdcSuppressedCodeLocations";
    static final int MODIFIERS = 26;
    static final String ALL_PACKAGE_ID = "pacAllPackageId";
    static final String WITH_SHARING_TYPE = "withSharingType";
    private final TypeInfo type;
    private final List<Compilation> innerTypes;
    private final List<Property> properties;
    private final Location loc;

    private AdditionalInfo(Builder builder) {
        this.type = builder.node.getDefiningType();
        this.loc = builder.node.getLoc();
        this.properties = builder.properties;
        this.innerTypes = builder.innerTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (GenericTypeInfoUtil.isGenericType(this.type) && !GenericTypeInfoUtil.typeParametersAllowed(symbols.getAccessEvaluator().hasApexParameterizedTypes(), this.type)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("type.parameters.not.supported"));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        String propertiesEncoding = this.encode(emitter, this.createPropertiesString());
        new AdditionalInfoEmit(this, propertiesEncoding, emitter).emit(emitter);
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.type;
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    private String encode(Emitter emitter, String value) {
        try {
            if (Strings.isNullOrEmpty(value)) {
                return null;
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            GZIPOutputStream gzipStream = new GZIPOutputStream(stream);
            ObjectOutputStream objectInputStream = new ObjectOutputStream(gzipStream);
            objectInputStream.writeObject(value);
            objectInputStream.close();
            String base64Str = Base64.encode((byte[])stream.toByteArray());
            if (base64Str.length() >= 65536) {
                emitter.getCodeUnit().getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.metadata.too.large"));
                return null;
            }
            return Base64.encode((byte[])stream.toByteArray());
        }
        catch (IOException x) {
            emitter.getCodeUnit().getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("unexpected.error", x.getMessage()));
            return null;
        }
    }

    private String createPropertiesString() {
        if (this.properties.isEmpty()) {
            return null;
        }
        return this.properties.stream().map(Property::getInfo).sorted(PropertyInfo.NAME_COMPARATOR).map(PropertyInfo::encode).collect(MoreStrings.ON_COMMA);
    }

    void emitAnnotation(Emitter emitter) {
        HashMap<String, String> params = new HashMap<String, String>();
        String allPackageId = this.type.getCodeUnitDetails().getSource().getAllPackageId();
        SharingType sharingType = SharingTypeCalculator.get().resolve(this.type);
        if (allPackageId != null) {
            params.put(ALL_PACKAGE_ID, allPackageId);
        }
        if (sharingType != null && sharingType != SharingType.INHERIT) {
            params.put(WITH_SHARING_TYPE, sharingType.name());
        }
        if (!params.isEmpty()) {
            TypeStack.TypeContext context = emitter.getTypeStack().peek();
            AnnotationVisitor av = context.getClassWriter().visitAnnotation(InternalTypeInfos.SFDC_ADDITIONAL_TYPE.getTypeSignature(), true);
            for (Map.Entry param : params.entrySet()) {
                av.visit((String)param.getKey(), param.getValue());
            }
            av.visitEnd();
        }
    }

    private static class AdditionalInfoEmit
    implements Emit {
        private final String propertiesEncoding;
        private final TypeInfo type;
        private final List<Compilation> innerTypes;
        private final TypeStack.TypeContext context;

        private AdditionalInfoEmit(AdditionalInfo info, String propertiesEncoding, Emitter emitter) {
            this.propertiesEncoding = propertiesEncoding;
            this.context = emitter.getTypeStack().peek();
            this.type = info.type;
            this.innerTypes = info.innerTypes;
        }

        @Override
        public void emit(Emitter emitter) {
            this.write(AdditionalInfo.PROPERTIES, this.propertiesEncoding);
            if (this.type.getUnitType() == UnitType.CLASS) {
                this.emitGenericTypes();
            }
            this.emitInnerTypes();
            this.emitBitSet(AdditionalInfo.ADDITIONAL_CODE_LOCATIONS, this.context.getAdditionalCodeLocations());
            this.emitBitSet(AdditionalInfo.SUPPRESSED_CODE_LOCATIONS, this.context.getSuppressedCodeLocations());
        }

        private void emitGenericTypes() {
            boolean hasGenericType = MoreIterables.ensureAny(this.type.parents().immediateInterfaces(), GenericTypeInfoUtil::isGenericType);
            if (!hasGenericType) {
                return;
            }
            String value = this.type.parents().immediateInterfaces().stream().sorted(Comparator.comparing(TypeNameProvider::getBytecodeName)).map(TypeNameProvider::getBytecodeName).collect(MoreStrings.ON_COMMA);
            this.write(AdditionalInfo.PARAMETERIZED_TYPES, value);
        }

        private void emitInnerTypes() {
            if (this.innerTypes.isEmpty()) {
                return;
            }
            ArrayList<String> innerTypeList = new ArrayList<String>(this.innerTypes.size());
            for (Compilation compilation : this.innerTypes) {
                innerTypeList.add(compilation.getOutput().getType().getCodeUnitDetails().getName());
            }
            Collections.sort(innerTypeList);
            this.write(AdditionalInfo.INNER_TYPES, Joiner.on(",").join(innerTypeList));
        }

        private void emitBitSet(String name, BitSet bitSet) {
            if (bitSet.isEmpty()) {
                return;
            }
            String value = Joiner.on(",").join(new BitSetIterator(bitSet));
            this.write(name, value);
        }

        private void write(String field, String value) {
            if (value == null) {
                return;
            }
            this.context.getClassWriter().visitField(26, field, TypeInfos.STRING.getTypeSignature(), null, (Object)value).visitEnd();
        }
    }

    static class Builder {
        private List<Compilation> innerTypes = ImmutableList.of();
        private List<Property> properties = ImmutableList.of();
        private Compilation node;

        private Builder() {
        }

        AdditionalInfo build() {
            assert (this.node != null) : "defining type was not set for additional info";
            return new AdditionalInfo(this);
        }

        Builder setDefiningNode(Compilation node) {
            this.node = node;
            return this;
        }

        Builder setInnerTypes(List<Compilation> innerTypes) {
            this.innerTypes = innerTypes;
            return this;
        }

        Builder setProperties(List<Property> properties) {
            this.properties = properties;
            return this;
        }
    }
}

