/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast;

import apex.common.collect.MoreCollections;
import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.ForControl;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.NewObject;
import apex.jorje.data.ast.PrefixOp;
import apex.jorje.data.ast.PropertyDecl;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.VariableDecl;
import apex.jorje.data.ast.VariableDecls;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.AnonymousClass;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.InvalidDependentCompilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.expression.ArrayLoadExpression;
import apex.jorje.semantic.ast.expression.ArrayStoreExpression;
import apex.jorje.semantic.ast.expression.AssignmentExpression;
import apex.jorje.semantic.ast.expression.BinaryExpression;
import apex.jorje.semantic.ast.expression.BooleanExpression;
import apex.jorje.semantic.ast.expression.CastExpression;
import apex.jorje.semantic.ast.expression.ClassRefExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IllegalStoreExpression;
import apex.jorje.semantic.ast.expression.InstanceOfExpression;
import apex.jorje.semantic.ast.expression.JavaMethodCallExpression;
import apex.jorje.semantic.ast.expression.JavaVariableExpression;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NestedExpression;
import apex.jorje.semantic.ast.expression.NestedStoreExpression;
import apex.jorje.semantic.ast.expression.NewKeyValueObjectExpression;
import apex.jorje.semantic.ast.expression.NewListInitExpression;
import apex.jorje.semantic.ast.expression.NewListLiteralExpression;
import apex.jorje.semantic.ast.expression.NewMapInitExpression;
import apex.jorje.semantic.ast.expression.NewMapLiteralExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.NewSetInitExpression;
import apex.jorje.semantic.ast.expression.NewSetLiteralExpression;
import apex.jorje.semantic.ast.expression.PackageVersionExpression;
import apex.jorje.semantic.ast.expression.PostfixExpression;
import apex.jorje.semantic.ast.expression.PrefixExpression;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.expression.SoslExpression;
import apex.jorje.semantic.ast.expression.SuperMethodCallExpression;
import apex.jorje.semantic.ast.expression.SuperVariableExpression;
import apex.jorje.semantic.ast.expression.TernaryExpression;
import apex.jorje.semantic.ast.expression.ThisMethodCallExpression;
import apex.jorje.semantic.ast.expression.ThisVariableExpression;
import apex.jorje.semantic.ast.expression.TriggerVariableExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.modifier.Annotation;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.BreakStatement;
import apex.jorje.semantic.ast.statement.ContinueStatement;
import apex.jorje.semantic.ast.statement.DmlDeleteStatement;
import apex.jorje.semantic.ast.statement.DmlInsertStatement;
import apex.jorje.semantic.ast.statement.DmlMergeStatement;
import apex.jorje.semantic.ast.statement.DmlUndeleteStatement;
import apex.jorje.semantic.ast.statement.DmlUpdateStatement;
import apex.jorje.semantic.ast.statement.DmlUpsertStatement;
import apex.jorje.semantic.ast.statement.DoLoopStatement;
import apex.jorje.semantic.ast.statement.ExpressionStatement;
import apex.jorje.semantic.ast.statement.FieldDeclarationStatements;
import apex.jorje.semantic.ast.statement.ForLoopStatement;
import apex.jorje.semantic.ast.statement.IfElseBlockStatement;
import apex.jorje.semantic.ast.statement.ReturnStatement;
import apex.jorje.semantic.ast.statement.RunAsBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.SwitchStatement;
import apex.jorje.semantic.ast.statement.ThrowStatement;
import apex.jorje.semantic.ast.statement.TryCatchFinallyBlockStatement;
import apex.jorje.semantic.ast.statement.VariableDeclarationStatements;
import apex.jorje.semantic.ast.statement.WhileLoopStatement;
import apex.jorje.semantic.ast.statement.foreachstatement.ForEachStatement;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.details.CodeUnitDetailsProvider;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class AstNodes {
    public static final Predicate<VariableDecl> VARIABLE_DECLS_FILTER = variable -> variable != null && variable.name != null;
    private static final AstNodes INSTANCE = new AstNodes();

    private AstNodes() {
    }

    public static AstNodes get() {
        return INSTANCE;
    }

    public static TypeInfo getDefiningType(AstNode definingNode) {
        return definingNode == null ? null : definingNode.getDefiningType();
    }

    public static <T> Collection<T> filterNotNull(Collection<T> collection) {
        return MoreCollections.isNullOrEmpty(collection) ? ImmutableList.of() : Collections2.filter(collection, Objects::nonNull);
    }

    public static <T, R> List<R> filterNullTransform(Collection<T> collection, Function<T, R> function) {
        if (collection.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder list = new ImmutableList.Builder();
        for (T element : collection) {
            if (element == null) continue;
            list.add(function.apply(element));
        }
        return list.build();
    }

    public Statement create(final AstNode definingNode, Stmnt stmnt) {
        return stmnt == null ? Statement.INVALID : stmnt.match(new Stmnt.MatchBlock<Statement>(){

            @Override
            public Statement _case(Stmnt.BlockStmnt x) {
                return BlockStatement.builder().setDefiningNode(definingNode).setStmnt(x).build();
            }

            @Override
            public Statement _case(Stmnt.ExpressionStmnt x) {
                return new ExpressionStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.ReturnStmnt x) {
                return new ReturnStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.ThrowStmnt x) {
                return new ThrowStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.BreakStmnt x) {
                return new BreakStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.ContinueStmnt x) {
                return new ContinueStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DmlInsertStmnt x) {
                return new DmlInsertStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DmlUpdateStmnt x) {
                return new DmlUpdateStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DmlUpsertStmnt x) {
                return new DmlUpsertStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DmlDeleteStmnt x) {
                return new DmlDeleteStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DmlUndeleteStmnt x) {
                return new DmlUndeleteStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DmlMergeStmnt x) {
                return new DmlMergeStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.WhileLoop x) {
                return new WhileLoopStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DoLoop x) {
                return new DoLoopStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.IfElseBlock x) {
                return new IfElseBlockStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.RunAsBlock x) {
                return new RunAsBlockStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.TryCatchFinallyBlock x) {
                return new TryCatchFinallyBlockStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.VariableDeclStmnt x) {
                return new VariableDeclarationStatements(definingNode, x);
            }

            @Override
            public Statement _case(final Stmnt.ForLoop loop) {
                return loop.forControl == null ? Statement.INVALID : loop.forControl.match(new ForControl.MatchBlock<Statement>(){

                    @Override
                    public Statement _case(ForControl.EnhancedForControl x) {
                        return new ForEachStatement(definingNode, loop, x);
                    }

                    @Override
                    public Statement _case(ForControl.CStyleForControl x) {
                        return new ForLoopStatement(definingNode, loop, x);
                    }
                });
            }

            @Override
            public Statement _case(Stmnt.SwitchStatement x) {
                return new SwitchStatement(definingNode, x);
            }
        });
    }

    public Expression create(final AstNode definingNode, Expr expr) {
        return expr == null ? Expression.INVALID : expr.match(new Expr.MatchBlock<Expression>(){

            @Override
            public Expression _case(Expr.AssignmentExpr x) {
                return new AssignmentExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.TernaryExpr x) {
                return new TernaryExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.BinaryExpr x) {
                return new BinaryExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.CastExpr x) {
                return new CastExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.InstanceOf x) {
                return new InstanceOfExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.BooleanExpr x) {
                return new BooleanExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.TriggerVariableExpr x) {
                return new TriggerVariableExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.PackageVersionExpr x) {
                return new PackageVersionExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.PrefixExpr x) {
                return new PrefixExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.PostfixExpr x) {
                return new PostfixExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.ArrayExpr x) {
                return new ArrayLoadExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.VariableExpr x) {
                return VariableExpression.createLoad(definingNode, x);
            }

            @Override
            public Expression _case(Expr.MethodCallExpr x) {
                return new MethodCallExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.JavaMethodCallExpr x) {
                return new JavaMethodCallExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.JavaVariableExpr x) {
                return new JavaVariableExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.SuperMethodCallExpr x) {
                return new SuperMethodCallExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.SuperVariableExpr x) {
                return new SuperVariableExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.ThisMethodCallExpr x) {
                return new ThisMethodCallExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.ThisVariableExpr x) {
                return new ThisVariableExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.ClassRefExpr x) {
                return new ClassRefExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.LiteralExpr x) {
                return new LiteralExpression(definingNode, x);
            }

            @Override
            public Expression _case(final Expr.NewExpr expr) {
                return expr.creator == null ? Expression.INVALID : expr.creator.match(new NewObject.MatchBlock<Expression>(){

                    @Override
                    public Expression _case(NewObject.NewListInit x) {
                        return new NewListInitExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(NewObject.NewListLiteral x) {
                        return new NewListLiteralExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(NewObject.NewSetInit x) {
                        return new NewSetInitExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(NewObject.NewSetLiteral x) {
                        return new NewSetLiteralExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(NewObject.NewMapInit x) {
                        return new NewMapInitExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(NewObject.NewMapLiteral x) {
                        return new NewMapLiteralExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(NewObject.NewKeyValue x) {
                        return new NewKeyValueObjectExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(NewObject.NewStandard x) {
                        return new NewObjectExpression(definingNode, expr, x);
                    }
                });
            }

            @Override
            public Expression _case(Expr.NestedExpr x) {
                return new NestedExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.SoqlExpr x) {
                return new SoqlExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.SoslExpr x) {
                return new SoslExpression(definingNode, x);
            }
        });
    }

    public List<Expression> createExpressions(AstNode definingNode, List<Expr> exprs) {
        ImmutableList.Builder expressionList = new ImmutableList.Builder();
        for (Expr expr : exprs) {
            expressionList.add(this.create(definingNode, expr));
        }
        return expressionList.build();
    }

    public List<Statement> createStatements(AstNode definingNode, List<Stmnt> stmnts) {
        ImmutableList.Builder statementList = new ImmutableList.Builder();
        for (Stmnt stmnt : stmnts) {
            statementList.add(this.create(definingNode, stmnt));
        }
        return statementList.build();
    }

    public Compilation create(final Errors errors, final SourceFile source, final AstNode definingType, CompilationUnit unit) {
        return unit == null ? Compilation.INVALID : unit.match(new CompilationUnit.MatchBlock<Compilation>(){

            @Override
            public Compilation _case(CompilationUnit.TriggerDeclUnit x) {
                return new UserTrigger(errors, source, x);
            }

            @Override
            public Compilation _case(CompilationUnit.AnonymousBlockUnit x) {
                return new AnonymousClass(errors, source, x);
            }

            @Override
            public Compilation _case(CompilationUnit.EnumDeclUnit x) {
                return new UserEnum(source, definingType, x);
            }

            @Override
            public Compilation _case(CompilationUnit.ClassDeclUnit x) {
                return new UserClass(errors, source, definingType, x);
            }

            @Override
            public Compilation _case(CompilationUnit.InterfaceDeclUnit x) {
                return new UserInterface(errors, source, definingType, x);
            }

            @Override
            public Compilation _case(CompilationUnit.InvalidDeclUnit x) {
                if (source.getKnownName().isEmpty()) {
                    return Compilation.INVALID;
                }
                String fullName = TypeNameUtil.toNamespace(source.getNamespace(), source.getKnownName());
                return new InvalidDependentCompilation((TypeInfo)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName(fullName)).setCodeUnitDetails(new CodeUnitDetailsProvider.InvalidSourceCodeUnitDetails(source))).buildResolved());
            }
        });
    }

    public Property create(Errors errors, AstNode definingNode, PropertyDecl propertyDecl) {
        return new Property(errors, definingNode, propertyDecl);
    }

    public FieldDeclarationStatements create(AstNode definingNode, VariableDecls variableDecls) {
        return new FieldDeclarationStatements(definingNode, new Stmnt.VariableDeclStmnt(variableDecls));
    }

    public FieldDeclarationStatements create(AstNode definingNode, BlockMember.PropertyMember property) {
        PropertyDecl propertyDecl = property.propertyDecl;
        return this.create(definingNode, VariableDecls._VariableDecls(propertyDecl.modifiers, propertyDecl.type, ImmutableList.of(VariableDecl._VariableDecl(propertyDecl.name, Optional.empty()))));
    }

    public Expression createStore(final AstNode definingNode, Expr expr) {
        return expr == null ? Expression.INVALID : expr.match(new Expr.MatchBlockWithDefault<Expression>(){

            @Override
            public Expression _case(Expr.PrefixExpr x) {
                return x.op == PrefixOp.POSITIVE ? AstNodes.this.createStore(definingNode, x.expr) : new IllegalStoreExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.ArrayExpr x) {
                return new ArrayStoreExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.VariableExpr x) {
                return VariableExpression.createStore(definingNode, x);
            }

            @Override
            public Expression _case(Expr.NestedExpr x) {
                return new NestedStoreExpression(definingNode, x);
            }

            @Override
            protected Expression _default(Expr x) {
                return new IllegalStoreExpression(definingNode, x);
            }
        });
    }

    public Annotation create(Modifier.Annotation x) {
        return new Annotation(x);
    }
}

