/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.parser.impl;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.data.ast.VersionRef;
import apex.jorje.data.errors.SyntaxError;
import apex.jorje.data.errors.UserError;
import apex.jorje.parser.impl.CustomRecognitionException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreLists;
import java.util.List;
import java.util.Optional;

public class SpecialVariableMatcher {
    private static final SpecialVariableMatcher INSTANCE = new SpecialVariableMatcher();

    private SpecialVariableMatcher() {
    }

    public static SpecialVariableMatcher get() {
        return INSTANCE;
    }

    public Expr match(Optional<Expr> dottedExpr, Location loc, List<Identifier> identifiers) throws CustomRecognitionException {
        if (dottedExpr.isPresent()) {
            return Expr._VariableExpr(dottedExpr, identifiers);
        }
        if (MoreLists.isNullOrEmpty(identifiers)) {
            return Expr._VariableExpr(Optional.empty(), identifiers);
        }
        String first = identifiers.get(0).getValue();
        Location firstLoc = identifiers.get(0).getLoc();
        String last = Iterables.getLast(identifiers).getValue();
        if ("class".equalsIgnoreCase(last)) {
            return Expr._ClassRefExpr(loc, TypeRefs.newClassTypeRef(MoreLists.removeLast(identifiers), ImmutableList.of()));
        }
        if ("super".equalsIgnoreCase(first)) {
            if (identifiers.size() == 1) {
                return Expr._SuperVariableExpr(loc);
            }
            return Expr._VariableExpr(Optional.of(Expr._SuperVariableExpr(firstLoc)), identifiers.subList(1, identifiers.size()));
        }
        if ("this".equalsIgnoreCase(first)) {
            if (identifiers.size() == 1) {
                return Expr._ThisVariableExpr(loc);
            }
            return Expr._VariableExpr(Optional.of(Expr._ThisVariableExpr(firstLoc)), identifiers.subList(1, identifiers.size()));
        }
        switch (identifiers.size()) {
            case 2: {
                return this.twoParts(loc, identifiers);
            }
            case 3: {
                return this.threeParts(loc, identifiers);
            }
            case 4: {
                return this.fourParts(loc, identifiers);
            }
        }
        return Expr._VariableExpr(Optional.empty(), identifiers);
    }

    private Expr twoParts(Location loc, List<Identifier> identifiers) {
        String first = identifiers.get(0).getValue();
        if ("trigger".equalsIgnoreCase(first)) {
            return Expr._TriggerVariableExpr(loc, identifiers.get(1));
        }
        return Expr._VariableExpr(Optional.empty(), identifiers);
    }

    private Expr threeParts(Location loc, List<Identifier> identifiers) throws CustomRecognitionException {
        String first = identifiers.get(0).getValue();
        String second = identifiers.get(1).getValue();
        String third = identifiers.get(2).getValue();
        Location thirdLoc = identifiers.get(2).getLoc();
        if ("package".equalsIgnoreCase(first) && "version".equalsIgnoreCase(second)) {
            if ("request".equalsIgnoreCase(third)) {
                return Expr._PackageVersionExpr(loc, VersionRef._RequestVersion(thirdLoc));
            }
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._UnexpectedToken(thirdLoc, "'" + third + "'")));
        }
        if ("system".equalsIgnoreCase(first) && "trigger".equalsIgnoreCase(second)) {
            return Expr._TriggerVariableExpr(loc, identifiers.get(2));
        }
        return Expr._VariableExpr(Optional.empty(), identifiers);
    }

    private Expr fourParts(Location loc, List<Identifier> identifiers) throws CustomRecognitionException {
        String first = identifiers.get(0).getValue();
        String second = identifiers.get(1).getValue();
        String third = identifiers.get(2).getValue();
        Location thirdLoc = identifiers.get(2).getLoc();
        String fourth = identifiers.get(3).getValue();
        Location fourthLoc = identifiers.get(3).getLoc();
        if ("package".equalsIgnoreCase(first) && "version".equalsIgnoreCase(second)) {
            return Expr._PackageVersionExpr(loc, VersionRef._StructuredVersion(this.parseInteger(thirdLoc, third), this.parseInteger(fourthLoc, fourth)));
        }
        return Expr._VariableExpr(Optional.empty(), identifiers);
    }

    private Integer parseInteger(Location loc, String value) throws CustomRecognitionException {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException x) {
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._IllegalIntegerLiteral(loc)));
        }
    }
}

