/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.workspace;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.document.StandardDocument;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class StandardApexDocumentService
implements ApexDocumentService {
    private static final Logger logger = LoggerFactory.getLogger(StandardApexDocumentService.class);
    private final Map<URI, String> sources = new ConcurrentHashMap<URI, String>();

    @Override
    public void store(URI uri, String source) {
        assert (source != null);
        if (Objects.equals(uri.getScheme(), "file")) {
            this.sources.put(uri, source);
        }
    }

    @Override
    public Optional<Document> retrieve(URI uri) {
        String source = this.sources.get(uri);
        if (source != null) {
            return Optional.of(new StandardDocument(uri, source));
        }
        if (Objects.equals(uri.getScheme(), "file")) {
            try {
                return Optional.of(new StandardDocument(uri, new String(Files.readAllBytes(Paths.get(uri)))));
            }
            catch (IOException ioe) {
                logger.info("Failed to retrieve contents of {}", (Object)uri, (Object)ioe);
            }
        }
        return Optional.empty();
    }

    @Override
    public void remove(URI uri) {
        String removed = this.sources.remove(uri);
        if (removed == null) {
            logger.info("Tried to remove an entry {} that has no value", (Object)uri);
        }
    }
}

