/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.condition.StandardCondition;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.BreakStatement;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.ContinueStatement;
import apex.jorje.semantic.ast.statement.DmlDeleteStatement;
import apex.jorje.semantic.ast.statement.DmlInsertStatement;
import apex.jorje.semantic.ast.statement.DmlMergeStatement;
import apex.jorje.semantic.ast.statement.DmlUndeleteStatement;
import apex.jorje.semantic.ast.statement.DmlUpdateStatement;
import apex.jorje.semantic.ast.statement.DmlUpsertStatement;
import apex.jorje.semantic.ast.statement.DoLoopStatement;
import apex.jorje.semantic.ast.statement.ExpressionStatement;
import apex.jorje.semantic.ast.statement.FieldDeclarationStatements;
import apex.jorje.semantic.ast.statement.ForLoopStatement;
import apex.jorje.semantic.ast.statement.IfBlockStatement;
import apex.jorje.semantic.ast.statement.IfElseBlockStatement;
import apex.jorje.semantic.ast.statement.ReturnStatement;
import apex.jorje.semantic.ast.statement.RunAsBlockStatement;
import apex.jorje.semantic.ast.statement.ThrowStatement;
import apex.jorje.semantic.ast.statement.TryCatchFinallyBlockStatement;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.statement.VariableDeclarationStatements;
import apex.jorje.semantic.ast.statement.WhileLoopStatement;
import apex.jorje.semantic.ast.statement.foreachstatement.ForEachStatement;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.symbol.type.UnitType;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.TreeSet;

public class LineBreakpointVisitor
extends AstVisitor<AdditionalPassScope> {
    private final Map<String, TreeSet<Integer>> lineNumberMapping = Maps.newLinkedHashMap();

    private void addValidLineNumberMappingEntry(AstNode node) {
        Location loc = node.getLoc();
        if (Locations.isReal(loc)) {
            String apexName = node.getDefiningType().getBytecodeName();
            if (!this.lineNumberMapping.containsKey(apexName)) {
                this.lineNumberMapping.put(apexName, Sets.newTreeSet());
            }
            this.lineNumberMapping.get(apexName).add(loc.getLine());
        }
    }

    public Map<String, TreeSet<Integer>> getLineNumberMapping() {
        return this.lineNumberMapping;
    }

    private boolean isCurrentlyInTriggerScope(AstNode node) {
        return node.getDefiningType().getUnitType() == UnitType.TRIGGER;
    }

    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public void visitEnd(UserClass node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(UserEnum node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(UserInterface node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(UserTrigger node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(Property node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(Field node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(Method node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(BlockStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(DoLoopStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(ForEachStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(IfBlockStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(IfElseBlockStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(WhileLoopStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(CatchBlockStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(TryCatchFinallyBlockStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public void visitEnd(ForLoopStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
    }

    @Override
    public boolean visit(FieldDeclarationStatements node, AdditionalPassScope scope) {
        return this.isCurrentlyInTriggerScope(node);
    }

    @Override
    public void visitEnd(FieldDeclarationStatements node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        if (this.isCurrentlyInTriggerScope(node)) {
            this.addValidLineNumberMappingEntry(node);
        }
    }

    @Override
    public void visitEnd(BreakStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(StandardCondition node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(ContinueStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(DmlDeleteStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(DmlInsertStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(DmlMergeStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(DmlUndeleteStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(DmlUpdateStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(DmlUpsertStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(ExpressionStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(ReturnStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(RunAsBlockStatement node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(VariableDeclaration node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(VariableDeclarationStatements node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.addValidLineNumberMappingEntry(node);
    }

    @Override
    public void visitEnd(ThrowStatement node, AdditionalPassScope scope) {
        this.addValidLineNumberMappingEntry(node);
    }
}

