/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.services;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.definition.DefinitionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.document.DocumentLifecycleHandler;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.utils.CodeUnits;
import apex.jorje.lsp.api.visitors.VisitorFactory;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.visitors.StandardDocumentSymbolVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.SourceFile;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StandardTextDocumentService
implements TextDocumentService {
    private static final Logger logger = LoggerFactory.getLogger(StandardTextDocumentService.class);
    private final ApexDocumentService sourceService;
    private final ApexCompilerService compilerService;
    private final DocumentLifecycleHandler documentHandler;
    private final DefinitionStrategy definitionStrategy;
    private final VisitorFactory visitorFactory;
    private final CompletionStrategy completionAggregator;

    @Inject
    public StandardTextDocumentService(ApexDocumentService sourceService, ApexCompilerService compilerService, DocumentLifecycleHandler documentHandler, CompletionStrategy completionAggregator, DefinitionStrategy definitionStrategy, VisitorFactory visitorFactory) {
        this.sourceService = sourceService;
        this.compilerService = compilerService;
        this.documentHandler = documentHandler;
        this.completionAggregator = completionAggregator;
        this.definitionStrategy = definitionStrategy;
        this.visitorFactory = visitorFactory;
    }

    public CompletableFuture<CompletionList> completion(TextDocumentPositionParams params) {
        logger.info("Completion requested for {} at {}", (Object)params.getTextDocument().getUri(), (Object)params.getPosition());
        return CompletableFutures.computeAsync(cancelChecker -> new CompletionList(false, this.completionAggregator.provideCompletions(params)));
    }

    @Nullable
    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem completionItem) {
        return null;
    }

    @Nullable
    public CompletableFuture<Hover> hover(TextDocumentPositionParams params) {
        return null;
    }

    @Nullable
    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams textDocumentPositionParams) {
        return null;
    }

    public CompletableFuture<List<? extends Location>> definition(TextDocumentPositionParams params) {
        logger.info("Definition requested for {} at {}", (Object)params.getTextDocument().getUri(), (Object)params.getPosition());
        return CompletableFutures.computeAsync(cancelChecker -> this.definitionStrategy.provideDefinition(params));
    }

    @Nullable
    public CompletableFuture<List<? extends Location>> references(ReferenceParams referenceParams) {
        return null;
    }

    @Nullable
    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams textDocumentPositionParams) {
        return null;
    }

    public CompletableFuture<List<? extends SymbolInformation>> documentSymbol(DocumentSymbolParams params) {
        URI uri = URI.create(params.getTextDocument().getUri());
        Optional<Document> optDoc = this.sourceService.retrieve(uri);
        ArrayList symbols = new ArrayList();
        if (optDoc.isPresent()) {
            Document doc = optDoc.get();
            StandardDocumentSymbolVisitor visitor = this.generateDocumentSymbols(uri, doc);
            return CompletableFuture.supplyAsync(visitor::getSymbolInformation);
        }
        return CompletableFuture.completedFuture(symbols);
    }

    @Nullable
    public CompletableFuture<List<? extends Command>> codeAction(CodeActionParams codeActionParams) {
        return null;
    }

    @Nullable
    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams codeLensParams) {
        return null;
    }

    @Nullable
    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens codeLens) {
        return null;
    }

    @Nullable
    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams documentFormattingParams) {
        return null;
    }

    @Nullable
    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams documentRangeFormattingParams) {
        return null;
    }

    @Nullable
    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams documentOnTypeFormattingParams) {
        return null;
    }

    @Nullable
    public CompletableFuture<WorkspaceEdit> rename(RenameParams renameParams) {
        return null;
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        logger.debug("Document {} opened", (Object)params.getTextDocument().getUri());
        this.documentHandler.handleDidOpen(params);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        logger.debug("Document {} changed", (Object)params.getTextDocument().getUri());
        this.documentHandler.handleDidChange(params);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        logger.debug("Document {} closed", (Object)params.getTextDocument().getUri());
        this.documentHandler.handleDidClose(params);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        logger.debug("Document {} saved", (Object)params.getTextDocument().getUri());
        this.documentHandler.handleDidSave(params);
    }

    @VisibleForTesting
    public StandardDocumentSymbolVisitor generateDocumentSymbols(URI uri, Document doc) {
        StandardDocumentSymbolVisitor visitor = this.visitorFactory.createDocumentSymbolVisitor(uri);
        CodeUnit codeUnit = CodeUnits.getMatchingElement(this.compilerService.addSourceFiles(SourceFile.builder().setBody(doc.getSource()).setKnownName(doc.getUri().toString()).build()).compileByPassValidation(), doc.getUri().toString());
        codeUnit.additionalValidate(visitor);
        return visitor;
    }
}

