/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.symbol;

import apex.common.base.Initializer;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexMethod;
import apex.jorje.lsp.impl.index.node.ApexMethodParameter;
import apex.jorje.lsp.impl.index.node.ApexType;
import apex.jorje.lsp.impl.index.symbol.Lookups;
import apex.jorje.lsp.impl.index.symbol.Modifiers;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.MethodTableFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.jdt.internal.core.nd.IReader;

final class VirtualMethodTableInitializer
implements Initializer<MethodTable, TypeInfo> {
    private final Provider<ApexIndex> apexIndexProvider;
    private final ApexType apexType;
    private final SymbolResolver symbolResolver;

    VirtualMethodTableInitializer(SymbolResolver symbolResolver, Provider<ApexIndex> apexIndexProvider, ApexType apexType) {
        this.symbolResolver = symbolResolver;
        this.apexIndexProvider = apexIndexProvider;
        this.apexType = apexType;
    }

    private MethodInfo buildMethodInfo(ApexMethod method, TypeInfo type) {
        return StandardMethodInfo.builder().setDefiningType(type).setName(method.getMethodName().getString()).setReturnType(Lookups.lookupByApexName(this.symbolResolver, type, method.getReturnType().getApexName().getString(), method.getReturnType().getBytecodeName().getString())).setConstructor(method.isConstructor()).setParameters(this.toNamedParameters(method, type)).setModifiers(Modifiers.toModifierGroup(method.getModifiers().getString())).build();
    }

    @Override
    public MethodTable get(TypeInfo type) {
        try (IReader ignored = ((ApexIndex)this.apexIndexProvider.get()).getNd().acquireReadLock();){
            List<ApexMethod> methods = this.apexType.getMethods();
            MethodTable methodTable = MethodTableFactory.create((MethodInfo[])methods.stream().map(m -> this.buildMethodInfo((ApexMethod)((Object)m), type)).toArray(MethodInfo[]::new));
            return methodTable;
        }
    }

    private ImmutableList<Parameter> toNamedParameters(ApexMethod method, TypeInfo type) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ApexMethodParameter methodParameter : method.getParameters()) {
            builder.add(Parameter.builder().setDefiningType(type).setName(methodParameter.getName().getString()).setType(Lookups.lookupByApexName(this.symbolResolver, type, methodParameter.getArgumentTypeId().getApexName().getString(), methodParameter.getArgumentTypeId().getBytecodeName().getString())).build());
        }
        return builder.build();
    }
}

