/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.node;

import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexField;
import apex.jorje.lsp.impl.index.node.ApexMethod;
import apex.jorje.lsp.impl.index.node.ApexMethodParameter;
import apex.jorje.lsp.impl.index.node.ApexType;
import java.util.List;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.db.IString;
import org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.eclipse.jdt.internal.core.nd.field.FieldOneToOne;
import org.eclipse.jdt.internal.core.nd.field.FieldSearchKey;
import org.eclipse.jdt.internal.core.nd.field.StructDef;

public class ApexTypeId
extends NdNode {
    public static final StructDef<ApexTypeId> type = StructDef.create(ApexTypeId.class, (StructDef)NdNode.type);
    public static final FieldSearchKey<ApexIndex> APEX_NAME = FieldSearchKey.create(type, ApexIndex.TYPES_BY_APEX_NAME);
    public static final FieldSearchKey<ApexIndex> BYTECODE_NAME = FieldSearchKey.create(type, ApexIndex.TYPES_BY_BYTECODE_NAME);
    public static final FieldSearchKey<ApexIndex> APEX_NAMESPACE = FieldSearchKey.create(type, ApexIndex.NAMESPACES);
    static final FieldOneToOne<ApexType> TYPE = FieldOneToOne.createOwner(type, ApexType.class, ApexType.TYPE_ID);
    static final FieldOneToMany<ApexMethodParameter> USED_AS_METHOD_PARAMETER = FieldOneToMany.create(type, ApexMethodParameter.ARGUMENT_TYPE_ID);
    static final FieldOneToMany<ApexMethod> USED_AS_RETURN_TYPE = FieldOneToMany.create(type, ApexMethod.RETURN_TYPE);
    static final FieldOneToMany<ApexField> USED_AS_FIELD_TYPE = FieldOneToMany.create(type, ApexField.TYPE);

    public ApexTypeId(Nd nd, long address) {
        super(nd, address);
    }

    public ApexTypeId(Nd nd, String apexName, String bytecodeName) {
        super(nd);
        APEX_NAME.put(nd, this.address, apexName);
        BYTECODE_NAME.put(nd, this.address, bytecodeName);
    }

    public IString getApexName() {
        return APEX_NAME.get(this.getNd(), this.address);
    }

    public IString getBytecodeName() {
        return BYTECODE_NAME.get(this.getNd(), this.address);
    }

    public IString getApexNamespace() {
        return APEX_NAMESPACE.get(this.getNd(), this.address);
    }

    public void setApexNamespace(String apexNamespace) {
        APEX_NAMESPACE.put(this.getNd(), this.address, apexNamespace);
    }

    public ApexType getType() {
        return (ApexType)TYPE.get(this.getNd(), this.address);
    }

    public List<ApexMethod> getUsedAsMethodReturnType() {
        return USED_AS_RETURN_TYPE.asList(this.getNd(), this.address);
    }

    public List<ApexMethodParameter> getUsedAsMethodParameter() {
        return USED_AS_METHOD_PARAMETER.asList(this.getNd(), this.address);
    }

    static {
        type.useStandardRefCounting().done();
    }
}

