/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.completions.ValidationBasedCompletionActivationStrategy;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MembersCompletionStrategy
implements CompletionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(MembersCompletionStrategy.class);
    private final ApexDocumentService documentService;
    private final CompletionActivationFactory factory;

    @Inject
    public MembersCompletionStrategy(ApexDocumentService documentService, CompletionActivationFactory factory) {
        this.documentService = documentService;
        this.factory = factory;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        String uri = params.getTextDocument().getUri();
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(uri));
        ArrayList<CompletionItem> items = Lists.newArrayList();
        optDoc.ifPresent(doc -> {
            ValidationBasedCompletionActivationStrategy strategy = this.factory.createValidationBasedStrategy((Document)doc, params.getPosition());
            try {
                strategy.analyze();
                if (strategy.getExpression().isPresent()) {
                    this.addCompletion(items, strategy.getExpression().get());
                } else {
                    Position position = params.getPosition();
                    int lineOffset = doc.getLineOffset(position.getLine());
                    int offset = lineOffset + position.getCharacter();
                    ValidationBasedCompletionActivationStrategy trickyClassStrategy = this.factory.createValidationBasedStrategy(doc.insert(offset, "_;"), params.getPosition());
                    trickyClassStrategy.analyze();
                    trickyClassStrategy.getExpression().ifPresent(expr -> this.addCompletion(items, (VariableExpression)expr));
                }
            }
            catch (BadLocationException ble) {
                logger.error("Encountered a bad location while providing completion", (Throwable)ble);
            }
        });
        return items;
    }

    private void addCompletion(List<CompletionItem> items, VariableExpression expr) {
        if (expr.getReferenceContext() instanceof ReferenceExpression) {
            ReferenceExpression refExpr = (ReferenceExpression)expr.getReferenceContext();
            items.addAll(CompletionItemTransformer.dedup(CompletionItemTransformer.transform(refExpr.getType(), refExpr.getContext())));
        }
    }
}

