/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.data.Locations;
import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.utils.CodeUnits;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.completions.PrefixCompletionActivationStrategy;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalVariableNamesCompletionStrategy
implements CompletionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(LocalVariableNamesCompletionStrategy.class);
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final CompletionActivationFactory factory;

    @Inject
    public LocalVariableNamesCompletionStrategy(ApexCompilerService compilerService, ApexDocumentService documentService, CompletionActivationFactory factory) {
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.factory = factory;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        ArrayList<CompletionItem> items = Lists.newArrayList();
        optDoc.ifPresent(doc -> {
            PrefixCompletionActivationStrategy strategy = this.factory.createPrefixBasedStrategy((Document)doc, params.getPosition());
            try {
                if (strategy.shouldSuggestTopLevel()) {
                    int lineOffset = doc.getLineOffset(params.getPosition().getLine());
                    int offset = lineOffset + params.getPosition().getCharacter();
                    MethodVisitor methodVisitor = new MethodVisitor(offset);
                    CodeUnit codeUnit = CodeUnits.getMatchingElement(this.compilerService.addSourceFiles(SourceFile.builder().setBody(doc.getSource()).setKnownName(doc.getUri().toString()).build()).compileByPassValidation(), doc.getUri().toString());
                    codeUnit.additionalValidate(methodVisitor);
                    items.addAll(methodVisitor.applicableLocals());
                }
            }
            catch (BadLocationException ble) {
                logger.error("Encountered a bad location while providing completion", (Throwable)ble);
            }
        });
        return items;
    }

    static final class MethodVisitor
    extends AstVisitor<AdditionalPassScope> {
        final int activationOffset;
        @Nullable
        Collection<LocalInfo> activeScope;

        MethodVisitor(int activationOffset) {
            this.activationOffset = activationOffset;
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public void visitEnd(BlockStatement node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            if (this.activationOffset >= startIndex && endIndex >= this.activationOffset && Locations.isReal(node.getLoc()) && this.activeScope != null) {
                this.activeScope.addAll(node.getLocals().all());
            }
        }

        @Override
        public boolean visit(Method node, AdditionalPassScope scope) {
            int startIndex = node.getBodyLocation().getStartIndex();
            int endIndex = node.getBodyLocation().getEndIndex();
            if (this.activationOffset >= startIndex && this.activationOffset <= endIndex && Locations.isReal(node.getLoc())) {
                this.activeScope = Lists.newArrayList();
                this.activeScope.addAll(node.getLocals().all());
            }
            return true;
        }

        List<CompletionItem> applicableLocals() {
            ArrayList<CompletionItem> completionItems = Lists.newArrayList();
            if (this.activeScope != null) {
                completionItems.addAll(this.activeScope.stream().map(CompletionItemTransformer::transform).collect(Collectors.toList()));
            }
            return completionItems;
        }
    }
}

