/*
 * Decompiled with CFR 0.152.
 */
package apex.common.base;

import apex.common.base.ToLowerCaseProvider;
import com.google.common.annotations.VisibleForTesting;

public class ToLowerCaseFast
implements ToLowerCaseProvider {
    private static final ToLowerCaseFast INSTANCE = new ToLowerCaseFast();
    private static final char[] LOWER_CASE = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f'};
    private static final int LOWER_CASE_MAP_SIZE = LOWER_CASE.length;
    private final ToLowerCaseProvider systemToLowerCase;

    private ToLowerCaseFast() {
        this(Character::toLowerCase);
    }

    @VisibleForTesting
    ToLowerCaseFast(ToLowerCaseProvider systemToLowerCase) {
        this.systemToLowerCase = systemToLowerCase;
    }

    public static ToLowerCaseFast get() {
        return INSTANCE;
    }

    public boolean canBeFastLowerCased(char character) {
        return character < LOWER_CASE_MAP_SIZE;
    }

    @Override
    public char toLowerCase(char character) {
        return this.canBeFastLowerCased(character) ? LOWER_CASE[character] : this.systemToLowerCase.toLowerCase(character);
    }
}

