/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import apex.jorje.semantic.ast.member.Method;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.rule.design.AbstractNcssCountRule;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.util.NumericConstants;

public class NcssConstructorCountRule
extends AbstractNcssCountRule {
    public NcssConstructorCountRule() {
        super(ASTMethod.class);
        this.setProperty((PropertyDescriptor)MINIMUM_DESCRIPTOR, 20.0);
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Complexity"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 50);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (((Method)node.getNode()).getMethodInfo().isConstructor()) {
            return super.visit(node, data);
        }
        return NumericConstants.ZERO;
    }

    @Override
    public Object[] getViolationParameters(DataPoint point) {
        return new String[]{String.valueOf((int)point.getScore())};
    }
}

