/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import net.sourceforge.pmd.lang.apex.ast.ASTIfBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class AvoidDeeplyNestedIfStmtsRule
extends AbstractApexRule {
    private int depth;
    private int depthLimit;
    private static final IntegerProperty PROBLEM_DEPTH_DESCRIPTOR = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"problemDepth").desc("The if statement depth reporting threshold")).range((Object)1, (Object)25)).defaultValue((Object)3)).uiOrder(1.0f)).build();

    public AvoidDeeplyNestedIfStmtsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)PROBLEM_DEPTH_DESCRIPTOR);
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Complexity"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 200);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        this.depth = 0;
        this.depthLimit = (Integer)this.getProperty((PropertyDescriptor)PROBLEM_DEPTH_DESCRIPTOR);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTIfBlockStatement node, Object data) {
        ++this.depth;
        super.visit(node, data);
        if (this.depth == this.depthLimit) {
            this.addViolation(data, node);
        }
        --this.depth;
        return data;
    }
}

