/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.codestyle;

import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import java.util.List;
import java.util.Locale;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserInterface;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.StringMultiProperty;

public class VariableNamingConventionsRule
extends AbstractApexRule {
    private boolean checkMembers;
    private boolean checkLocals;
    private boolean checkParameters;
    private List<String> staticPrefixes;
    private List<String> staticSuffixes;
    private List<String> memberPrefixes;
    private List<String> memberSuffixes;
    private List<String> localPrefixes;
    private List<String> localSuffixes;
    private List<String> parameterPrefixes;
    private List<String> parameterSuffixes;
    private static final BooleanProperty CHECK_MEMBERS_DESCRIPTOR = new BooleanProperty("checkMembers", "Check member variables", true, 1.0f);
    private static final BooleanProperty CHECK_LOCALS_DESCRIPTOR = new BooleanProperty("checkLocals", "Check local variables", true, 2.0f);
    private static final BooleanProperty CHECK_PARAMETERS_DESCRIPTOR = new BooleanProperty("checkParameters", "Check constructor and method parameter variables", true, 3.0f);
    private static final StringMultiProperty STATIC_PREFIXES_DESCRIPTOR = new StringMultiProperty("staticPrefix", "Static variable prefixes", new String[]{""}, 4.0f, ',');
    private static final StringMultiProperty STATIC_SUFFIXES_DESCRIPTOR = new StringMultiProperty("staticSuffix", "Static variable suffixes", new String[]{""}, 5.0f, ',');
    private static final StringMultiProperty MEMBER_PREFIXES_DESCRIPTOR = new StringMultiProperty("memberPrefix", "Member variable prefixes", new String[]{""}, 6.0f, ',');
    private static final StringMultiProperty MEMBER_SUFFIXES_DESCRIPTOR = new StringMultiProperty("memberSuffix", "Member variable suffixes", new String[]{""}, 7.0f, ',');
    private static final StringMultiProperty LOCAL_PREFIXES_DESCRIPTOR = new StringMultiProperty("localPrefix", "Local variable prefixes", new String[]{""}, 8.0f, ',');
    private static final StringMultiProperty LOCAL_SUFFIXES_DESCRIPTOR = new StringMultiProperty("localSuffix", "Local variable suffixes", new String[]{""}, 9.0f, ',');
    private static final StringMultiProperty PARAMETER_PREFIXES_DESCRIPTOR = new StringMultiProperty("parameterPrefix", "Method parameter variable prefixes", new String[]{""}, 10.0f, ',');
    private static final StringMultiProperty PARAMETER_SUFFIXES_DESCRIPTOR = new StringMultiProperty("parameterSuffix", "Method parameter variable suffixes", new String[]{""}, 11.0f, ',');

    public VariableNamingConventionsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_MEMBERS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_LOCALS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_PARAMETERS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)STATIC_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)STATIC_SUFFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)MEMBER_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)MEMBER_SUFFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)LOCAL_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)LOCAL_SUFFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)PARAMETER_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)PARAMETER_SUFFIXES_DESCRIPTOR);
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Style"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 5);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        this.init();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTUserInterface node, Object data) {
        this.init();
        return super.visit(node, data);
    }

    protected void init() {
        this.checkMembers = (Boolean)this.getProperty((PropertyDescriptor)CHECK_MEMBERS_DESCRIPTOR);
        this.checkLocals = (Boolean)this.getProperty((PropertyDescriptor)CHECK_LOCALS_DESCRIPTOR);
        this.checkParameters = (Boolean)this.getProperty((PropertyDescriptor)CHECK_PARAMETERS_DESCRIPTOR);
        this.staticPrefixes = (List)this.getProperty((PropertyDescriptor)STATIC_PREFIXES_DESCRIPTOR);
        this.staticSuffixes = (List)this.getProperty((PropertyDescriptor)STATIC_SUFFIXES_DESCRIPTOR);
        this.memberPrefixes = (List)this.getProperty((PropertyDescriptor)MEMBER_PREFIXES_DESCRIPTOR);
        this.memberSuffixes = (List)this.getProperty((PropertyDescriptor)MEMBER_SUFFIXES_DESCRIPTOR);
        this.localPrefixes = (List)this.getProperty((PropertyDescriptor)LOCAL_PREFIXES_DESCRIPTOR);
        this.localSuffixes = (List)this.getProperty((PropertyDescriptor)LOCAL_SUFFIXES_DESCRIPTOR);
        this.parameterPrefixes = (List)this.getProperty((PropertyDescriptor)PARAMETER_PREFIXES_DESCRIPTOR);
        this.parameterSuffixes = (List)this.getProperty((PropertyDescriptor)PARAMETER_SUFFIXES_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTField node, Object data) {
        if (!this.checkMembers) {
            return data;
        }
        boolean isStatic = ((Field)node.getNode()).getFieldInfo().getModifiers().has((ModifierOrAnnotationTypeInfo)ModifierTypeInfos.STATIC);
        boolean isFinal = ((Field)node.getNode()).getFieldInfo().getModifiers().has((ModifierOrAnnotationTypeInfo)ModifierTypeInfos.FINAL);
        return this.checkName(isStatic ? this.staticPrefixes : this.memberPrefixes, isStatic ? this.staticSuffixes : this.memberSuffixes, node, isStatic, isFinal, data);
    }

    @Override
    public Object visit(ASTVariableDeclaration node, Object data) {
        if (!this.checkLocals) {
            return data;
        }
        boolean isFinal = ((VariableDeclaration)node.getNode()).getLocalInfo().getModifiers().has((ModifierOrAnnotationTypeInfo)ModifierTypeInfos.FINAL);
        return this.checkName(this.localPrefixes, this.localSuffixes, node, false, isFinal, data);
    }

    @Override
    public Object visit(ASTParameter node, Object data) {
        if (!this.checkParameters) {
            return data;
        }
        boolean isFinal = ((Parameter)node.getNode()).getModifierInfo().has((ModifierOrAnnotationTypeInfo)ModifierTypeInfos.FINAL);
        return this.checkName(this.parameterPrefixes, this.parameterSuffixes, node, false, isFinal, data);
    }

    private Object checkName(List<String> prefixes, List<String> suffixes, ApexNode<?> node, boolean isStatic, boolean isFinal, Object data) {
        String varName = node.getImage();
        if (varName == null || "serialVersionUID".equals(varName)) {
            return data;
        }
        if (isStatic && isFinal) {
            if (!varName.equals(varName.toUpperCase(Locale.ROOT))) {
                this.addViolationWithMessage(data, node, "Variables that are final and static should be all capitals, ''{0}'' is not all capitals.", new Object[]{varName});
            }
            return data;
        }
        if (!isFinal) {
            String normalizedVarName = this.normalizeVariableName(varName, prefixes, suffixes);
            if (normalizedVarName.indexOf(95) >= 0) {
                this.addViolationWithMessage(data, node, "Only variables that are final should contain underscores (except for underscores in standard prefix/suffix), ''{0}'' is not final.", new Object[]{varName});
            }
            if (Character.isUpperCase(varName.charAt(0))) {
                this.addViolationWithMessage(data, node, "Variables should start with a lowercase character, ''{0}'' starts with uppercase character.", new Object[]{varName});
            }
        }
        return data;
    }

    private String normalizeVariableName(String varName, List<String> prefixes, List<String> suffixes) {
        return this.stripSuffix(this.stripPrefix(varName, prefixes), suffixes);
    }

    private String stripSuffix(String varName, List<String> suffixes) {
        if (suffixes != null) {
            for (String suffix : suffixes) {
                if (!varName.endsWith(suffix)) continue;
                varName = varName.substring(0, varName.length() - suffix.length());
                break;
            }
        }
        return varName;
    }

    private String stripPrefix(String varName, List<String> prefixes) {
        if (prefixes != null) {
            for (String prefix : prefixes) {
                if (!varName.startsWith(prefix)) continue;
                return varName.substring(prefix.length());
            }
        }
        return varName;
    }

    public boolean hasPrefixesOrSuffixes() {
        for (PropertyDescriptor desc : this.getPropertyDescriptors()) {
            List values;
            if (!(desc instanceof StringMultiProperty) || (values = (List)this.getProperty((PropertyDescriptor)((StringMultiProperty)desc))).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String dysfunctionReason() {
        return this.hasPrefixesOrSuffixes() ? null : "No prefixes or suffixes specified";
    }
}

