/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.cpp;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.SimpleCharStream;

public class CppCharStream
extends SimpleCharStream {
    private static final Pattern CONTINUATION = Pattern.compile("\\\\\\n|\\\\\\r\\n");
    private static final char BACKSLASH = '\\';
    private static final char NEWLINE = '\n';
    private static final char CARRIAGE_RETURN = '\r';

    public CppCharStream(Reader dstream) {
        super(dstream);
    }

    public char readChar() throws IOException {
        char c = super.readChar();
        if (c == '\\') {
            char c1 = super.readChar();
            if (c1 == '\n') {
                c = super.readChar();
            } else if (c1 == '\r') {
                char c2 = super.readChar();
                if (c2 == '\n') {
                    c = super.readChar();
                } else {
                    this.backup(2);
                }
            } else {
                this.backup(1);
            }
        }
        return c;
    }

    public char[] GetSuffix(int len) {
        String image = this.GetImage();
        return image.substring(image.length() - len, image.length()).toCharArray();
    }

    public String GetImage() {
        String image = super.GetImage();
        return CONTINUATION.matcher(image).replaceAll("");
    }
}

