/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.cpd.token.JavaCCTokenFilter;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
import net.sourceforge.pmd.util.IOUtil;
import org.apache.commons.io.IOUtils;

public class CPPTokenizer
implements Tokenizer {
    private boolean skipBlocks = true;
    private String skipBlocksStart;
    private String skipBlocksEnd;

    public void setProperties(Properties properties) {
        this.skipBlocks = Boolean.parseBoolean(properties.getProperty("net.sourceforge.pmd.cpd.Tokenizer.skipBlocks", Boolean.TRUE.toString()));
        if (this.skipBlocks) {
            String skipBlocksPattern = properties.getProperty("net.sourceforge.pmd.cpd.Tokenizer.skipBlocksPattern", "#if 0|#endif");
            String[] split = skipBlocksPattern.split("\\|", 2);
            this.skipBlocksStart = split[0];
            this.skipBlocksEnd = split.length == 1 ? split[0] : split[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        StringBuilder buffer = sourceCode.getCodeBuffer();
        Reader reader = null;
        try {
            LanguageVersionHandler languageVersionHandler = LanguageRegistry.getLanguage((String)"C++").getDefaultVersion().getLanguageVersionHandler();
            reader = new StringReader(this.maybeSkipBlocks(buffer.toString()));
            reader = IOUtil.skipBOM((Reader)reader);
            JavaCCTokenFilter tokenFilter = new JavaCCTokenFilter(languageVersionHandler.getParser(languageVersionHandler.getDefaultParserOptions()).getTokenManager(sourceCode.getFileName(), reader));
            GenericToken currentToken = tokenFilter.getNextToken();
            while (currentToken != null) {
                tokenEntries.add(new TokenEntry(currentToken.getImage(), sourceCode.getFileName(), currentToken.getBeginLine()));
                currentToken = tokenFilter.getNextToken();
            }
            tokenEntries.add(TokenEntry.getEOF());
            System.err.println("Added " + sourceCode.getFileName());
        }
        catch (TokenMgrError err) {
            err.printStackTrace();
            System.err.println("Skipping " + sourceCode.getFileName() + " due to parse error");
            tokenEntries.add(TokenEntry.getEOF());
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Skipping " + sourceCode.getFileName() + " due to parse error");
            tokenEntries.add(TokenEntry.getEOF());
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    private String maybeSkipBlocks(String test) throws IOException {
        String line;
        if (!this.skipBlocks) {
            return test;
        }
        BufferedReader reader = new BufferedReader(new StringReader(test));
        StringBuilder filtered = new StringBuilder(test.length());
        boolean skip = false;
        while ((line = reader.readLine()) != null) {
            if (this.skipBlocksStart.equalsIgnoreCase(line.trim())) {
                skip = true;
            } else if (skip && this.skipBlocksEnd.equalsIgnoreCase(line.trim())) {
                skip = false;
            }
            if (!skip) {
                filtered.append(line);
            }
            filtered.append(PMD.EOL);
        }
        return filtered.toString();
    }
}

