/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.design;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.plsql.ast.ASTInput;
import net.sourceforge.pmd.lang.plsql.ast.ASTPackageSpecification;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeSpecification;
import net.sourceforge.pmd.lang.plsql.ast.ASTVariableOrConstantDeclaration;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.rule.AbstractPLSQLRule;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.util.NumericConstants;

public class TooManyFieldsRule
extends AbstractPLSQLRule {
    private static final int DEFAULT_MAXFIELDS = 15;
    private Map<String, Integer> stats;
    private Map<String, PLSQLNode> nodes;
    private static final IntegerProperty MAX_FIELDS_DESCRIPTOR = new IntegerProperty("maxfields", "Max allowable fields", Integer.valueOf(1), Integer.valueOf(300), Integer.valueOf(15), 1.0f);

    public TooManyFieldsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)MAX_FIELDS_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTInput node, Object data) {
        this.stats = new HashMap<String, Integer>(5);
        this.nodes = new HashMap<String, PLSQLNode>(5);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTPackageSpecification node, Object data) {
        int maxFields = (Integer)this.getProperty((PropertyDescriptor)MAX_FIELDS_DESCRIPTOR);
        List l = node.findDescendantsOfType(ASTVariableOrConstantDeclaration.class);
        for (ASTVariableOrConstantDeclaration fd : l) {
            this.bumpCounterFor(fd);
        }
        for (String k : this.stats.keySet()) {
            int val = this.stats.get(k);
            Node n = this.nodes.get(k);
            if (val <= maxFields) continue;
            this.addViolation(data, n);
        }
        return data;
    }

    @Override
    public Object visit(ASTTypeSpecification node, Object data) {
        int maxFields = (Integer)this.getProperty((PropertyDescriptor)MAX_FIELDS_DESCRIPTOR);
        List l = node.findDescendantsOfType(ASTVariableOrConstantDeclaration.class);
        for (ASTVariableOrConstantDeclaration fd : l) {
            this.bumpCounterFor(fd);
        }
        for (String k : this.stats.keySet()) {
            int val = this.stats.get(k);
            Node n = this.nodes.get(k);
            if (val <= maxFields) continue;
            this.addViolation(data, n);
        }
        return data;
    }

    private void bumpCounterFor(PLSQLNode clazz) {
        String key = clazz.getImage();
        if (!this.stats.containsKey(key)) {
            this.stats.put(key, NumericConstants.ZERO);
            this.nodes.put(key, clazz);
        }
        Integer i = this.stats.get(key) + 1;
        this.stats.put(key, i);
    }
}

