/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.StringReader;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.cpd.token.JavaCCTokenFilter;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.plsql.PLSQLTokenManager;
import net.sourceforge.pmd.lang.plsql.ast.Token;

public class PLSQLTokenizer
implements Tokenizer {
    private static final Logger LOGGER = Logger.getLogger(PLSQLTokenizer.class.getName());
    @Deprecated
    public static final String IGNORE_COMMENTS = "ignore_comments";
    public static final String IGNORE_IDENTIFIERS = "ignore_identifiers";
    public static final String IGNORE_LITERALS = "ignore_literals";
    private boolean ignoreIdentifiers;
    private boolean ignoreLiterals;

    public void setProperties(Properties properties) {
        this.ignoreIdentifiers = Boolean.parseBoolean(properties.getProperty(IGNORE_IDENTIFIERS, "false"));
        this.ignoreLiterals = Boolean.parseBoolean(properties.getProperty(IGNORE_LITERALS, "false"));
    }

    @Deprecated
    public void setIgnoreComments(boolean ignore) {
    }

    public void setIgnoreLiterals(boolean ignore) {
        this.ignoreLiterals = ignore;
    }

    public void setIgnoreIdentifiers(boolean ignore) {
        this.ignoreIdentifiers = ignore;
    }

    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        long encounteredTokens = 0L;
        long addedTokens = 0L;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("PLSQLTokenizer: ignoreIdentifiers==" + this.ignoreIdentifiers);
            LOGGER.fine("PLSQLTokenizer: ignoreLiterals==" + this.ignoreLiterals);
        }
        String fileName = sourceCode.getFileName();
        StringBuilder sb = sourceCode.getCodeBuffer();
        JavaCCTokenFilter tokenFilter = new JavaCCTokenFilter((TokenManager)new PLSQLTokenManager(new StringReader(sb.toString())));
        Token currentToken = (Token)tokenFilter.getNextToken();
        while (currentToken != null) {
            String image = currentToken.image;
            ++encounteredTokens;
            if (this.ignoreIdentifiers && currentToken.kind == 420) {
                image = String.valueOf(currentToken.kind);
            }
            if (this.ignoreLiterals && (currentToken.kind == 421 || currentToken.kind == 422 || currentToken.kind == 423 || currentToken.kind == 425 || currentToken.kind == 426 || currentToken.kind == 428)) {
                image = String.valueOf(currentToken.kind);
            }
            tokenEntries.add(new TokenEntry(image, fileName, currentToken.beginLine));
            ++addedTokens;
            currentToken = (Token)tokenFilter.getNextToken();
        }
        tokenEntries.add(TokenEntry.getEOF());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(sourceCode.getFileName() + ": encountered " + encounteredTokens + " tokens; added " + addedTokens + " tokens");
        }
    }
}

