"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'create a parameter group'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new lib_1.ParameterGroup(stack, 'Params', {
            family: 'hello',
            description: 'desc',
            parameters: {
                key: 'value'
            }
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::RDS::DBParameterGroup', {
            Description: 'desc',
            Family: 'hello',
            Parameters: {
                key: 'value'
            }
        }));
        test.done();
    },
    'create a cluster parameter group'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new lib_1.ClusterParameterGroup(stack, 'Params', {
            family: 'hello',
            description: 'desc',
            parameters: {
                key: 'value'
            }
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::RDS::DBClusterParameterGroup', {
            Description: 'desc',
            Family: 'hello',
            Parameters: {
                key: 'value'
            }
        }));
        test.done();
    },
    'Add an additional parameter to an existing parameter group'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const clusterParameterGroup = new lib_1.ClusterParameterGroup(stack, 'Params', {
            family: 'hello',
            description: 'desc',
            parameters: {
                key1: 'value1'
            }
        });
        clusterParameterGroup.addParameter('key2', 'value2');
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::RDS::DBClusterParameterGroup', {
            Description: 'desc',
            Family: 'hello',
            Parameters: {
                key1: 'value1',
                key2: 'value2'
            }
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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