"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Compare two version strings. Fails if the comparison has to tiebreak with non-numbers.
 * @returns 0 if both are same, 1 if 'a' is later version than 'b' and -1 if 'b' is later version than 'a'
 */
function compare(a, b) {
    const aParts = a.split('.');
    const bParts = b.split('.');
    for (let i = 0; i < Math.max(aParts.length, bParts.length); i++) {
        if (i === aParts.length) {
            return -1;
        }
        if (i === bParts.length) {
            return 1;
        }
        if (!aParts[i] || !bParts[i] || isNaN(aParts[i]) || isNaN(bParts[i])) {
            throw new Error(`Can only compare version strings with numbers. Received [${a}] and [${b}].`);
        }
        const partCompare = parseInt(aParts[i], 10) - parseInt(bParts[i], 10);
        if (partCompare < 0) {
            return -1;
        }
        if (partCompare > 0) {
            return 1;
        }
    }
    return 0;
}
exports.compare = compare;
//# sourceMappingURL=data:application/json;base64,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