import * as codedeploy from '@aws-cdk/aws-codedeploy';
import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
import { Code, CodeConfig } from './code';
/**
 * Construction properties for the Ec2Deployer object
 */
export interface Ec2DeployerProps {
    /**
       * The source code to be deployed.
       *
       */
    readonly code: Code;
    /**
       * The deployment group to deploy the artifact to.
       *
       */
    readonly deploymentGroup: codedeploy.IServerDeploymentGroup;
    /**
       * Whether the enclosing stack should wait for the deployment to complete.
       *
       * @default - true
       */
    readonly waitToComplete?: boolean;
    /**
       * Amount of time the stack will wait for the deployment operation to complete, for a maximum of 2 hours. Has no effect if waitToComplete = false.
       *
       * @default - 5 minutes
       */
    readonly deploymentTimeout?: cdk.Duration;
    /**
     * The IAM roles associated with the target instances to be deployed to. This is used to ensure the target instances have the appropriate permissions to download the deployment artifact from S3.
     * This prop is only required when the instance roles cannot be dynamically pulled from the supplied deploymentGroup's autoScalingGroups property,
     * for example when deploymentGroup is of type IServerDeploymentGroup or if the deploymentGroup is not associated with an ASG.
     *
     * @default - gets the instance roles from serverDeploymentGroup.autoScalingGroups[].role
     */
    readonly instanceRoles?: iam.IRole[];
}
/**
 * Represents a Deployer resource for deploying an artifact to EC2 using CodeDeploy.
 *
 */
export declare class Ec2Deployer extends cdk.Construct {
    /**
     * Maximum allowed value for deploymentTimeout prop.
     *
     */
    static readonly MAX_DEPLOYMENT_TIMEOUT: cdk.Duration;
    /**
     * The deployment group being deployed to.
     */
    readonly deploymentGroup: codedeploy.IServerDeploymentGroup;
    /**
       * The source code to be deployed.
       *
       */
    readonly code: CodeConfig;
    /**
     * Whether the enclosing stack will wait for the deployment to complete.
     *
     */
    readonly waitToComplete: boolean;
    /**
     * Amount of time the stack will wait for the deployment operation to complete.
     *
     */
    readonly deploymentTimeout?: cdk.Duration;
    /**
     * The IAM roles associated with the target instances to be deployed to. This is used to ensure the target instances have the appropriate permissions to download the deployment artifact from S3.
     * This prop is only required when the instance roles cannot be dynamically pulled from the supplied deploymentGroup's autoScalingGroups property,
     * for example when deploymentGroup is of type IServerDeploymentGroup or if the deploymentGroup is not associated with an ASG.
     *
     */
    readonly instanceRoles?: iam.IRole[];
    constructor(scope: cdk.Construct, id: string, props: Ec2DeployerProps);
}
