import pytest
import numpy as np 
from ..sFIR import smooth_fir 

def test_wgr_regress():
    val1 = np.random.randint(1, 10)
    val2 = np.random.randint(11, 200)
    y = np.random.random((val2))
    X = np.random.random((val2, val1))
    out = smooth_fir.wgr_regress(y, X)
    assert type(out) == type(np.asarray([]))
    assert out.size == val1
    y = np.zeros((val2))
    out = smooth_fir.wgr_regress(y, X)
    assert np.allclose(np.zeros((val1)), out)
    X = np.asarray([[0.24355643043258524, 0.7455782849363849, 0.23335172385642733, 0.020660847834777285], [0.3072110437035208, 0.18602592674503415, 0.9244063171012394, 0.4804649391334549], [0.8016594604103529, 0.9591356084764378, 0.21194228781653557, 0.9827060442384642], [0.07815744716811968, 0.3166325884280309, 0.11251053277597933, 0.6210284344051261], [0.2646152373376658, 0.5240016539430198, 0.31930431720842334, 0.0251519420757097], [0.021911974219001706, 0.01690869083226454, 0.3297262058981726, 0.6618903359199471], [0.08355709035078951, 0.07514938226594636, 0.0031208479890078022, 0.03888221191825747], [0.9970940046680711, 0.5878412240919779, 0.6558184846102507, 0.7206928654146247], [0.727649859981568, 0.4065500141583437, 0.775884796806493, 0.7015181953666869], [0.10971518494894683, 0.9959080243481756, 0.5422490052771556, 0.8266212359977652], [0.26459232860949, 0.8356742095986958, 0.1095077682766954, 0.14378156713215096], [0.259763773901589, 0.3746508316758117, 0.9001388308688932, 0.9050451624557473], [0.9856637279719391, 0.6479702871193095, 0.09198170835828423, 0.8476385625410208], [0.3815258418918812, 0.6703358792038151, 0.4383431460974705, 0.4641501816990993], [0.8473061691948293, 0.5224300782979008, 0.4121441061796459, 0.7523270716310405]])
    y = np.asarray([0.028931607771739087, 0.06696412129540685, 0.22387070667513875, 0.1646337105002752, 0.8412800842253353, 0.9425084870509369, 0.17822863038093084, 0.8479179507498892, 0.5029580038596141, 0.6444064372391561, 0.4070548187562978, 0.505922721410633, 0.15972752609496743, 0.6658366133135427, 0.8404498444201265])
    out_exp = np.asarray([0.0411757,  0.24767687, 0.42055364, 0.19608055])
    out = smooth_fir.wgr_regress(y, X)
    assert(np.allclose(out, out_exp))

def test_wgr_glsco():
    val1 = np.random.randint(1, 10)
    val2 = np.random.randint(11, 200)
    Y  = np.random.random((val2))
    X  = np.random.random((val2, val1))
    sMRI = []
    AR_lag = 1
    max_iter = 20
    out = smooth_fir.wgr_glsco(X, Y, sMRI = sMRI, AR_lag=AR_lag, max_iter=max_iter)
    assert type(out) == type(())
    out1, out2 = out 
    assert type(out1) == type(np.asarray([]))
    assert type(out2) == type(np.asarray([]))
    assert out1.size == 1
    assert out2.size == val1
    X = np.asarray([[0.43544989084462715, 0.43777641933208156, 0.643080155843435, 0.813958593825052], [0.38928213850325455, 0.7593771015592158, 0.9254380082419151, 0.9447717588006423], [0.7259162100876503, 0.9598502412184825, 0.2899975081150954, 0.061478720535798836], [0.59879813056311, 0.48257959397766126, 0.5172554453824507, 0.16492819946945403], [0.11836248792536241, 0.5160265578209018, 0.8461462946573081, 0.912137637714782], [0.8737499577883742, 0.03795309267342717, 0.606763078803996, 0.5976806041129074], [0.4718986859311063, 0.2344092091943103, 0.473912352830851, 0.23718309987498087], [0.11576771623753401, 0.9128385253518523, 0.28409971172402615, 0.11940757702240845], [0.16412366113275922, 0.38190328702582255, 0.8469984086100405, 0.6973147802496206], [0.49506282363232845, 0.5190719545916632, 0.14244310294990092, 0.6104011894845355]])
    Y = np.asarray([0.23860649900343323, 0.5973580998661552, 0.3928186546630218, 0.05778943990961405, 0.7063978648709636, 0.07370285332712434, 0.009135396063910783, 0.09269627999757779, 0.5547467325191129, 0.9656335840727327])
    out = smooth_fir.wgr_glsco(X, Y, sMRI = sMRI, AR_lag=AR_lag, max_iter=max_iter)
    out1, out2 = out
    out1_exp = np.asarray([0.02611677]) 
    out2_exp = np.asarray([ 0.0367933 ,  0.51386258, -0.97340772,  1.26010343])
    assert np.allclose(np.asarray(out1), out1_exp)
    assert np.allclose(np.asarray(out2), out2_exp)

def test_Fit_sFIR2():
    val = np.random.randint(11, 200)
    output = np.random.random((val))
    length = 24 
    TR = 2.0
    inp = np.random.random((val, 1)) 
    T = 12 
    flag_sfir = 1
    AR_lag = 1   
    out = smooth_fir.Fit_sFIR2(output, length, TR, inp, T, flag_sfir, AR_lag)
    assert type(out) == type(())
    out1, out2 = out 
    assert type(out1) == type(np.asarray([]))
    assert out1.size == 13
    assert type(out2) == type(np.asarray([]))
    assert out2.size == 1
    output = np.zeros((val))
    out = smooth_fir.Fit_sFIR2(output, length, TR, inp, T, flag_sfir, AR_lag)
    out1, out2 = out 
    assert np.allclose(np.zeros((13)), out1)
    assert np.allclose(np.zeros((1)), out2)
    inp = np.asarray([[0.11208123437880424], [0.47337000532832263], [0.5496760145257539], [0.1984332652066324], [0.29117413061557396], [0.707023774370774], [0.7601515226800849], [0.7330200743158585], [0.5033685350197652], [0.6139854490565899], [0.050357274201077495], [0.15618758068425953], [0.17767321816121273], [0.8491434293211506], [0.9017948328311318], [0.3170850576159929], [0.2645298774321433], [0.3485067071439355], [0.13392947284086754], [0.5564549094193428], [0.7549219830345042], [0.41491153064393316], [0.052470190827242136], [0.7863378666190465], [0.6221018221283174], [0.5318620796466], [0.9184682835509385], [0.09511349772823907], [0.2641100933731456], [0.5577093763583515]])
    output = np.asarray([0.03613177914943355, 0.19932562473088167, 0.3728048908567443, 0.07152471033316932, 0.13231120596801615, 0.8336233605946677, 0.19626102779888965, 0.11014151567005881, 0.2165833771773754, 0.09860670113620307, 0.13462733526174642, 0.4026949077980243, 0.7309591700260996, 0.5494233508094024, 0.36049825129091106, 0.07427512868812536, 0.9117468354810448, 0.1486779741324824, 0.23574106866255196, 0.20385094450271402, 0.17652149436966758, 0.8576716535577852, 0.7281154108083755, 0.5313725666429985, 0.6759241704468735, 0.19017576791553958, 0.6072763968829056, 0.35461323171658643, 0.07176955460623347, 0.3522955937509432])
    out2_exp = 0.062454251905728904
    out1_exp = np.asarray([-0.006013666009659839, -0.021447182383702836, -0.023945735843657407, -0.018371231986189136, -0.02233574736823547, -0.020078382177641022, 0.010920928033064338, 0.051249693019481325, 0.06888676660465594, 0.06398005690442186, 0.048868321199953546, 0.07298304109849973, 0.3096652201182815])
    out = smooth_fir.Fit_sFIR2(output, length, TR, inp, T, flag_sfir, AR_lag)
    out1, out2 = out 
    assert np.allclose(out1_exp ,out1)
    assert np.allclose(out2_exp ,out2) 

def test_wgr_FIR_estimation_HRF():
    u = np.random.random((7))
    dat = np.random.random((152))
    para = {'estimation': 'sFIR', 'passband': [0.01, 0.08], 'passband_deconvolve': [0.0, 1.7976931348623157e+308], 'TR': 2.0, 'T': 1, 'T0': 3, 'TD_DD': 2, 'AR_lag': 1, 'thr': np.asarray([ 1., np.inf]), 'temporal_mask': [], 'order': 3, 'len': 24, 'min_onset_search': 4, 'max_onset_search': 8, 'localK': 1, 'wiener': False, 'dt': 0.6666666666666666, 'lag': np.asarray([ 6,  7,  8,  9, 10, 11, 12])}
    N = 152
    output = smooth_fir.wgr_FIR_estimation_HRF(u, dat, para, N)
    assert type(output) == type(())
    u = np.asarray([0.8265743871886244, 0.4571816356384941, 0.9167817425355507, 0.6497771799779721, 0.6873170490384577, 0.45801903592817417, 0.7458612352409498])
    dat = np.asarray([0.07965334399271984, 0.5784720482033168, 0.7241693158799498, 0.8594543092961181, 0.3333887323361263, 0.8663470970895705, 0.1692672051067885, 0.8132782708370856, 0.3545430163067911, 0.1389518058293373, 0.04008377738610536, 0.5251678917354534, 0.03331965019371441, 0.5560024201801771, 0.6492800171038505])
    output = smooth_fir.wgr_FIR_estimation_HRF(u, dat, para, N)
    out1, out2 = output 
    assert type(out1) == type(np.asarray([]))
    assert type(out2) == type(np.asarray([]))
    assert np.allclose(out1, np.zeros((13)))
    out2_exp = np.array([0.82657439, 0.45718164, 0.91678174, 0.64977718, 0.68731705, 0.45801904, 0.74586124])
    assert np.allclose(out2_exp ,out2) 