"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Vehicle = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const handler_1 = require("./handler");
const provider_1 = require("./provider");
/**
 * The vehicle of a specific type from which IoT FleetWise collect signals.
 */
class Vehicle extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.vehicleModel = {};
        this.vehicleId = '';
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:vehicle/${props.vehicleId}`;
        this.vehicleModel = props.vehicleModel;
        this.vehicleId = props.vehicleId;
        const handler = new handler_1.Handler(this, 'Handler', {
            handler: 'vehiclehandler.on_event',
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider_1.Provider.getOrCreate(this, handler).provider.serviceToken,
            properties: {
                vehicle_id: props.vehicleId,
                create_iot_thing: props.createIotThing,
                decoder_manifest_arn: `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:decoder-manifest/${props.vehicleModel.name}`,
                model_manifest_arn: `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:model-manifest/${props.vehicleModel.name}`,
            },
        });
        resource.node.addDependency(this.vehicleModel);
        if (props.createIotThing) {
            this.endpointAddress = resource.getAtt('endpointAddress').toString();
            this.certificateId = resource.getAtt('certificateId').toString();
            this.certificateArn = resource.getAtt('certificateArn').toString();
            this.certificatePem = resource.getAtt('certificatePem').toString();
            this.privateKey = resource.getAtt('privateKey').toString();
            const policy = new aws_cdk_lib_1.aws_iot.CfnPolicy(this, 'Policy', {
                policyName: `${props.vehicleId}-policy`,
                policyDocument: `{
          "Version": "2012-10-17",
          "Statement": [{
                  "Effect": "Allow",
                  "Action": [
                      "iot:Connect",
                      "iot:Subscribe",
                      "iot:Publish",
                      "iot:Receive"
                  ],
                  "Resource": [
                      "arn:aws:iot:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:client/${props.vehicleId}*",
                      "arn:aws:iot:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:topic/*",
                      "arn:aws:iot:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:topicfilter/*"
                  ]
          }]
        }`,
            });
            policy.node.addDependency(resource);
            const policy_attachement = new aws_cdk_lib_1.aws_iot.CfnPolicyPrincipalAttachment(this, 'Attachment', {
                policyName: policy.policyName,
                principal: this.certificateArn,
            });
            policy_attachement.node.addDependency(policy);
            const thing_attachment = new aws_cdk_lib_1.aws_iot.CfnThingPrincipalAttachment(this, 'ThingAttachment', {
                thingName: props.vehicleId,
                principal: this.certificateArn,
            });
            thing_attachment.node.addDependency(policy_attachement);
        }
    }
}
exports.Vehicle = Vehicle;
_a = JSII_RTTI_SYMBOL_1;
Vehicle[_a] = { fqn: "cdk-aws-iotfleetwise.Vehicle", version: "0.2.11" };
//# sourceMappingURL=data:application/json;base64,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