"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignalCatalog = exports.SignalCatalogSensor = exports.SignalCatalogBranch = exports.SignalCatalogNode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const handler_1 = require("./handler");
const provider_1 = require("./provider");
class SignalCatalogNode {
    constructor() {
        this.node = {};
    }
    toObject() {
        return (this.node);
    }
}
exports.SignalCatalogNode = SignalCatalogNode;
_a = JSII_RTTI_SYMBOL_1;
SignalCatalogNode[_a] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogNode", version: "0.2.11" };
class SignalCatalogBranch extends SignalCatalogNode {
    constructor(name, fullyQualifiedName, description) {
        super();
        this.node = {
            type: 'Branch',
            branch: {
                name: name,
                fullyQualifiedName: fullyQualifiedName,
                ...description && { description },
            },
        };
    }
}
exports.SignalCatalogBranch = SignalCatalogBranch;
_b = JSII_RTTI_SYMBOL_1;
SignalCatalogBranch[_b] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogBranch", version: "0.2.11" };
class SignalCatalogSensor extends SignalCatalogNode {
    constructor(name, fullyQualifiedName, dataType, unit, min, max, description) {
        super();
        this.node = {
            type: 'Sensor',
            sensor: {
                name,
                fullyQualifiedName,
                dataType,
                ...unit && { unit },
                ...min && { min },
                ...max && { max },
                ...description && { description },
            },
        };
    }
}
exports.SignalCatalogSensor = SignalCatalogSensor;
_c = JSII_RTTI_SYMBOL_1;
SignalCatalogSensor[_c] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogSensor", version: "0.2.11" };
/**
 * The Signal Catalog represents the list of all signals that you want to collect from all
 * the vehicles.
 *
 *
 * The AWS IoT Fleetwise preview can only support a single Signal Catalog per account.
 *
 */
class SignalCatalog extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.name || 'default';
        this.description = props.description;
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:signal-catalog/${this.name}`;
        const handler = new handler_1.Handler(this, 'Handler', {
            handler: 'servicehandler.on_event',
        });
        const isCompleteHandler = new handler_1.Handler(this, 'IsCompleteHandler', {
            handler: 'servicehandler.is_complete',
        });
        handler.role.addToPrincipalPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            actions: [
                'iam:PassRole',
            ],
            resources: [props.role.roleArn],
        }));
        const provider = provider_1.Provider.getOrCreate(this, handler, isCompleteHandler);
        const serviceResource = new cdk.CustomResource(this, 'ServiceResource', {
            serviceToken: provider.provider.serviceToken,
            properties: {
                role_arn: props.role.roleArn,
                database_name: props.database.databaseName,
                table_name: props.table.tableName,
            },
        });
        const serviceCatalogHandler = new handler_1.Handler(this, 'ServiceCatalogHandler', {
            handler: 'signalcataloghandler.on_event',
        });
        const resourceCatalog = new cdk.CustomResource(this, 'CatalogResource', {
            serviceToken: provider_1.Provider.getOrCreate(this, serviceCatalogHandler).provider.serviceToken,
            properties: {
                name: this.name,
                description: this.description,
                nodes: JSON.stringify(props.nodes.map(node => node.toObject())),
            },
        });
        resourceCatalog.node.addDependency(serviceResource);
    }
}
exports.SignalCatalog = SignalCatalog;
_d = JSII_RTTI_SYMBOL_1;
SignalCatalog[_d] = { fqn: "cdk-aws-iotfleetwise.SignalCatalog", version: "0.2.11" };
//# sourceMappingURL=data:application/json;base64,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