# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pycture']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.1.2,<8.0.0', 'defusedxml>=0.7.1,<0.8.0', 'requests>=2.25.1,<3.0.0']

extras_require = \
{':python_version < "3.8"': ['importlib-metadata>=1.0,<2.0']}

entry_points = \
{'console_scripts': ['pycture = pycture.cli:main']}

setup_kwargs = {
    'name': 'pycture',
    'version': '0.1.0',
    'description': 'A Python CLI for obtaining emojis as files and favicons.',
    'long_description': '# pycture\n\n[![security: bandit](https://img.shields.io/badge/security-bandit-yellow.svg)](https://github.com/PyCQA/bandit)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\nA Python CLI for obtaining emojis as files and favicons.\n\n## Quickstart\n\n```text\nUsage: pycture [OPTIONS] EMOJI\n\n  Get EMOJI as a file or favicon via its CLDR short name.\n\n  Use Unicode 9.0 and Emoji 3.0 as a reference.\n\nOptions:\n  -o, --output-dir DIRECTORY      The path to the output directory.\n                                  [default: (current directory)]\n\n  -p, --pretty                    Pretty-print the SVG code.\n  -s, --source [Twemoji|OpenMoji]\n                                  The source of the emoji to obtain.\n                                  [default: Twemoji]\n\n  --version                       Show the version and exit.\n  --help                          Show this message and exit.\n```\n\n## Tech Stack\n\n- [Click](https://click.palletsprojects.com/) (for the interface)\n- [Requests](https://github.com/psf/requests) (for HTTP requests)\n- [defusedxml](https://github.com/tiran/defusedxml) (for parsing XML/SVG data)\n\n### Packaging and Development\n\n- [Poetry](https://python-poetry.org/)\n- [Mypy](http://mypy-lang.org/)\n- [isort](https://pycqa.github.io/isort/)\n- [Black](https://github.com/psf/black)\n- [Flake8](https://flake8.pycqa.org/)\n  - [flake8-bugbear](https://github.com/PyCQA/flake8-bugbear)\n  - [flake8-comprehensions](https://github.com/adamchainz/flake8-comprehensions)\n  - [pep8-naming](https://github.com/PyCQA/pep8-naming)\n  - [flake8-builtins](https://github.com/gforcada/flake8-builtins)\n- [Bandit](https://bandit.readthedocs.io/)\n\nThis CLI was created with [Cookiecutter](https://github.com/audreyr/cookiecutter) and the [`joaopalmeiro/cookiecutter-templates/python-cli`](https://github.com/joaopalmeiro/cookiecutter-templates) project template.\n\n## Development\n\n1. `poetry install`\n2. `poetry shell`\n\n## Notes\n\n- [click-contrib](https://github.com/click-contrib) (a collection of third-party extensions).\n  - [click-man](https://github.com/click-contrib/click-man) package (man pages).\n  - [click-help-colors](https://github.com/click-contrib/click-help-colors) package.\n  - [click-didyoumean](https://github.com/click-contrib/click-didyoumean) package.\n  - [click_params](https://github.com/click-contrib/click_params) package (extra types).\n- [OpenMoji](https://openmoji.org/).\n- [emoji](https://github.com/carpedm20/emoji) package.\n- [demoji](https://github.com/bsolomon1124/demoji) package.\n- [Twemoji](https://github.com/twitter/twemoji).\n- [Inflection](https://inflection.readthedocs.io/en/latest/) package.\n- Unicode:\n  - [Full Emoji List](https://unicode.org/emoji/charts/full-emoji-list.html).\n  - [Full Emoji Modifier Sequences](http://www.unicode.org/emoji/charts/full-emoji-modifiers.html).\n  - [Emoji Counts](http://www.unicode.org/emoji/charts/emoji-counts.html).\n  - [Emoji List, v13.0](https://unicode.org/emoji/charts-13.0/emoji-list.html).\n  - [unicodedata](https://docs.python.org/3.6/library/unicodedata.html) (Python 3.6 -> Unicode 9.0).\n  - [Emoji Version 3.0](https://emojipedia.org/emoji-3.0/) (this emoji version coincided with the release of Unicode 9.0).\n- [cookiecutter-poetry](https://github.com/johanvergeer/cookiecutter-poetry) (only the `pyproject.toml` file and no `poetry.lock` file).\n- `cli.py` or `console.py`.\n- [Asyncio integration](https://github.com/pallets/click/issues/85) issue (Click).\n- [asyncclick](https://github.com/python-trio/asyncclick) package (fork of Click).\n- [XML vulnerabilities](https://docs.python.org/3/library/xml.html#xml-vulnerabilities).\n- Bandit:\n  - [B405 complains about any xml.etree.ElementTree import, not just parse-related ones](https://github.com/PyCQA/bandit/issues/709) (open) issue.\n  - [from xml.etree.ElementTree import Element Flagged](https://github.com/PyCQA/bandit/issues/602) (open) issue.\n  - [Error message refers to "defusedxml.defuse_stdlib()" but calling that does not silence bandit](https://github.com/PyCQA/bandit/issues/708) (open) issue.\n  - [defusedxml](https://github.com/tiran/defusedxml) provides alternatives for parsing-related functions.\n- [Shell completion](https://click.palletsprojects.com/en/7.x/bashcomplete/) (for commands, options, and choice values):\n  - Generate the [activation script](https://click.palletsprojects.com/en/7.x/bashcomplete/#activation-script): `_PYCTURE_COMPLETE=source_zsh pycture > pycture-complete.sh`.\n  - In `.bashrc` or `.zshrc`, source the script: `. /path/to/pycture-complete.sh`.\n  - Alternative: `eval "$(_PYCTURE_COMPLETE=source_zsh pycture)"`.\n- [aiohttp](https://github.com/aio-libs/aiohttp) package (vs. [Requests](https://github.com/psf/requests)):\n  - "(...) you can picture the session object as a user starting and closing a browser: it wouldn\'t make sense to do that every time you want to load a new tab." ([source](https://docs.aiohttp.org/en/stable/http_request_lifecycle.html))\n\n```python\n# aiohttp\nasync with aiohttp.ClientSession() as session:\n    async with session.get("http://python.org") as response:\n        print(await response.text())\n\n# vs.\n\n# Requests\nresponse = requests.get("http://python.org")\nprint(response.text)\n\n# or\n\nwith requests.Session() as session:\n    response = session.get("http://python.org")\n    print(response.text)\n```\n',
    'author': 'João Palmeiro',
    'author_email': 'joaommpalmeiro@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/joaopalmeiro/pycture',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
