# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyredactkit']

package_data = \
{'': ['*']}

install_requires = \
['nltk>=3.7,<4.0', 'numpy<1.22.0']

entry_points = \
{'console_scripts': ['prk = pyredactkit.runner:main',
                     'pyredactkit = pyredactkit.runner:main']}

setup_kwargs = {
    'name': 'pyredactkit',
    'version': '0.4.0',
    'description': 'Python cli tool to redact sensitive data',
    'long_description': '# PyRedactKit 🔐📝\n\n<p align="center">\n  <img src="./images/pyredacthead.gif" alt="Python Redactor Kit!" width="300" height="300"/>\n<br />\n<i>CLI tool to redact and unredact sensitive information like ip addresses, emails and domains.</i>\n<br/>\n<code>pip install --upgrade pyredactkit && prk</code>\n</p>\n\n<p align="center">\n   <img alt="PyPI - Downloads" src="https://pepy.tech/badge/pyredactkit/month">\n   <!-- <img alt="PyPI - Downloads" src="https://pepy.tech/badge/pyredactkit"> -->\n   <a href="https://twitter.com/brootware"><img src="https://img.shields.io/twitter/follow/brootware?style=social" alt="Twitter Follow"></a>\n   <img alt="PyPI - Python Version" src="https://img.shields.io/pypi/pyversions/pyredactkit"> <img alt="PyPI" src="https://img.shields.io/pypi/v/pyredactkit">\n   <a href="https://sonarcloud.io/summary/new_code?id=brootware_PyRedactKit"><img src="https://sonarcloud.io/api/project_badges/measure?project=brootware_PyRedactKit&metric=alert_status" alt="reliability rating"></a>\n   <img alt="GitHub Workflow Status" src="https://img.shields.io/github/workflow/status/brootware/pyredactkit/CI?label=CI&branch=dev">\n</p>\n\n## Features\n\nRedacts and Unredacts the following from your text files. 📄 ✍️\n\n- sg nric 🆔\n- credit cards 🏧\n- domain names 🌐\n- emails ✉️\n- ipv4 📟\n- ipv6 📟\n- base64 🅱️\n\n## Pre-requisites\n\n- [Python3](https://www.python.org/downloads/) installed\n- [pip](https://packaging.python.org/en/latest/guides/installing-using-pip-and-virtual-environments/) installed\n\n## How to use\n\nDemo:\n![demo](./images/pyredactdemo.gif)\n\nQuick install\n\n```bash\npython -m pip install --upgrade pyredactkit\n```\n\n**For more elaborate usage, please [refer to the docs](https://github.com/brootware/PyRedactKit/wiki/Usage).**\n\nRedact from terminal\n\n```bash\nprk \'this is my ip:127.0.0.1. my email is broot@outlook.com. secret link is github.com\'\n```\n\nRedact a single file.\n\n```bash\nprk test.txt \n```\n\nUn-redact the file with redacted data\n\n```bash\nprk redacted_test.txt -u .hashshadow_test.txt.json \n```\n\nRedact using custom regex pattern\n\n```bash\nprk file -c custom.json\n```\n\n### Use from github source\n\nClone the repo\n\n```bash\ngit clone https://github.com/brootware/PyRedactKit.git && cd PyRedactKit\n```\n\nInstall required dependencies via poetry and download nltk.\n\n```bash\npython -m pip install --user poetry\npoetry install \npython -c "import nltk\nimport ssl\n\ntry:\n    _create_unverified_https_context = ssl._create_unverified_context\nexcept AttributeError:\n    pass\nelse:\n    ssl._create_default_https_context =_create_unverified_https_context\n\nnltk.download(\'popular\')"\n```\n\n<!-- python -c "import nltk\nimport ssl\n\ntry:\n    _create_unverified_https_context = ssl._create_unverified_context\nexcept AttributeError:\n    pass\nelse:\n    ssl._create_default_https_context =_create_unverified_https_context\n\nnltk.download()" -->\n\nRun as below to redact a single file\n\n```bash\n$ poetry run pyredactkit -f logdata/test.txt                                    \n\n__________         __________           .___              __     ____  __.__  __   \n\\______   \\___.__. \\______   \\ ____   __| _/____    _____/  |_  |    |/ _|__|/  |_ \n |     ___<   |  |  |       _// __ \\ / __ |\\__  \\ _/ ___\\   __\\ |      < |  \\   __\\\n |    |    \\___  |  |    |   \\  ___// /_/ | / __ \\\\  \\___|  |   |    |  \\|  ||  |  \n |____|    / ____|  |____|_  /\\___  >____ |(____  /\\___  >__|   |____|__ \\__||__|  \n           \\/              \\/     \\/     \\/     \\/     \\/               \\/                                                                                                                 \n                    +-+-+-+-+-+-+-+ +-+-+ +-+-+-+-+-+-+-+-+-+\n                    |P|o|w|e|r|e|d| |b|y| |B|r|o|o|t|w|a|r|e|\n                    +-+-+-+-+-+-+-+ +-+-+ +-+-+-+-+-+-+-+-+-+\n            \n    https://github.com/brootware\n    https://brootware.github.io     \n    https://twitter.com/brootware                                                                        \n    \n[+] Processing starts now. This may take some time depending on the file size. Monitor the redacted file size to monitor progress\n[+] No custom regex pattern supplied, will be redacting all the core sensitive data supported\n[+] .hashshadow_test.txt.json file generated. Keep this safe if you need to undo the redaction.\n[+] Redacted 10068 targets...\n[+] Redacted results saved to ./redacted_test.txt\n[+] Estimated total words : 30316\n[+] Estimated total minutes saved : 405\n[+] Estimated total man hours saved : 6\n```\n\nSample Result:\n\n```txt\nJohn, please get that article on b8bd54d3-34ee-4f31-8b2b-0d729929e8aa to me by 5:00PM on Jan 9th 2012. 4:00 would be ideal, actually. If you have any questions, You can reach me at(519)-236-2723 or get in touch with my associate at 7b3c7641-4b09-4e00-8e02-0e68e47b0ded.\nAll rights reserved. Printed in the United States of America. No part of this book may be used or reproduced in any manner whatsoever without written permission except in the case of brief quotations embodied in critical articles and reviews. For information address HarperCollins Publishers, 10 East 53rd Street, New York, NY 10022. His name is David. I met him and John last week. Gowtham Teja Kanneganti is a good student. I was born on Oct 4, 1995. My Indian mobile number is +91-7761975545. After coming to USA I got a new number +1-405-413-5255. I live on 1003 E Brooks St, Norman, Ok, 73071. I met  a child, who is playing with josh.\nthis is my IP: 49f62b69-98c1-4f7b-87d1-8f7f6723f44e\nMy router is : e83747e7-521f-4f44-982f-0de1b2be4d19\n1d6716c8-1f1b-4e90-a62e-a0be14417e78\n0a5671c0-5de9-4198-a731-aff33e22a653\nce336df7-e58e-4297-9644-c8199f5e38cf\n020fc1b6-6035-474b-8f6d-7c0890e94e6b\nc0f238ef-cc94-48e7-9c98-e8883d9dd947\n63d76480-e7d4-4ebf-9101-04b9e70ddd8d\nc33d0c2a-8d87-48c7-b846-20f938a8f902\nMy email is c1f04434-c7e9-4d9a-a0a9-7a0651a046cd\na36aab91-9c25-4221-a7a4-a0ff01c8d752\nthis is my IP: 0c15d46a-67e7-4906-9dd4-ee520ab91b47\nMy router is: ca00a810-4ff8-4880-8983-9b6dbbeb06f8\n12830911-20a9-45f8-ae04-9a4f807ee3b8\n6b042458-83a2-4ce9-b029-c62e83180719\ne1e8c2f3-5a9f-49ff-bc3e-cefe0f842274\n611ccb57-ea69-41b6-946d-1284a1a345d0\n492b72d2-cf23-477f-a02e-78bb04ad13ab\nBase64 data\ndd4e5123-c87a-4ff0-ba40-f7f601270484\nd660b76c-c2ce-4401-90a6-35277a2def23\nbbde787d-f515-4fcb-a583-e4d3d8185ca3\n10c5d831-2728-45d0-8810-c0e6bb40a4c9\na5bac8dd-bd89-4bc8-94a9-b510beb88d6a\nSingapore NRIC\nc9a85803-e706-4322-99a0-e1c76705c4e8\n05759c8a-a2e7-46d8-8739-bb6c97fb8117\n0b29e289-a3af-4cbc-92d6-d044601a2458\nbe05fce6-7464-43cb-9164-914f8e63ff5c\nb857a0c2-b108-44d5-b3ea-f0bc05e36dee\n5eccbebc-f2a9-4420-a436-66f08a6f63c5\nCard_Number,Card_Family,Credit_Limit,Cust_ID\nb35843a8-6483-44ec-884c-868dd3296d34,Premium,530000,CC67088\nd392cc27-d20b-4876-ae64-4196c5b05dd3,Gold,18000,CC12076\nacb4d6d7-1c7c-42d1-a02c-6b229e2a9e4a,Premium,596000,CC97173\nb92d943a-73d8-4318-955d-2e364836f641,Gold,27000,CC55858\ne0b66cbd-6174-4491-b938-408a47d38fb9,Platinum,142000,CC90518\n6b73619c-bcbf-4509-a064-1fb110f5dd45,Gold,50000,CC49168\n24f31233-cba6-4f6a-a2d6-0ce49952b2cb,Premium,781000,CC66746\n```\n\n## Optional Help Menu as below\n\n```bash\nusage: pyredactkit [-h] [-f FILE [FILE ...]] [-u UNREDACT] [-d DIROUT] [-c CUSTOMFILE] [-r] [-e EXTENSION] [text ...]\n\nSupply a sentence or paragraph to redact sensitive data from it. Or read in a file or set of files with -f to redact\n\npositional arguments:\n  text                  Redact sensitive data of a sentence from command prompt. (default: None)\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -f FILE [FILE ...], --file FILE [FILE ...]\n                        Path of a file or a directory of files. (default: None)\n  -u UNREDACT, --unredact UNREDACT\n                        Option to unredact masked data. Usage: pyredactkit -f [redacted_file] -u [.hashshadow.json] (default: None)\n  -d DIROUT, --dirout DIROUT\n                        Output directory of the file. Usage: pyredactkit -f [file/filestoredact] -d [redacted_dir] (default: None)\n  -c CUSTOMFILE, --customfile CUSTOMFILE\n                        User defined custom regex pattern for redaction. Usage: pyredactkit -f [file/filestoredact] -c [customfile.json] (default: None)\n  -r, --recursive       Search through subfolders (default: True)\n  -e EXTENSION, --extension EXTENSION\n                        File extension to filter by. (default: )\n```\n\n## Sample files\n\n- [All types of data](./logdata/test.txt)\n- [Different log file types](./logdata/)\n- [test_sample2.txt - 10002 lines of IP addresses](https://sanitizationbq.s3.ap-southeast-1.amazonaws.com/test_sample2.txt)\n\n## Contributing 💡\n\nPlease read the [contributing guide](https://github.com/brootware/PyRedactKit/wiki/Contributing). You can propose a feature request opening an issue or a pull request.\n\n<a href="https://github.com/brootware/PyRedactKit/graphs/contributors">\n  <img src="https://contrib.rocks/image?repo=brootware/PyRedactKit" />\n</a>\n\nMade with [contrib.rocks](https://contrib.rocks).\n',
    'author': 'brootware',
    'author_email': 'brootware@outlook.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/brootware/PyRedactKit',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
