/*
 * SPDX-FileCopyrightText: 2006-2021 Istituto Italiano di Tecnologia (IIT)
 * SPDX-License-Identifier: BSD-3-Clause
 */

// Autogenerated by Thrift Compiler (0.14.1-yarped)
//
// This is an automatically generated file.
// It could get re-generated if the ALLOW_IDL_GENERATION flag is on.

#include <yarprobotinterfaceRpc.h>

#include <yarp/os/idl/WireTypes.h>

// get_phase helper class declaration
class yarprobotinterfaceRpc_get_phase_helper :
        public yarp::os::Portable
{
public:
    yarprobotinterfaceRpc_get_phase_helper() = default;
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    class Command :
            public yarp::os::idl::WirePortable
    {
    public:
        Command() = default;
        ~Command() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool writeTag(const yarp::os::idl::WireWriter& writer) const;
        bool writeArgs(const yarp::os::idl::WireWriter& writer) const;

        bool read(yarp::os::idl::WireReader& reader) override;
        bool readTag(yarp::os::idl::WireReader& reader);
        bool readArgs(yarp::os::idl::WireReader& reader);
    };

    class Reply :
            public yarp::os::idl::WirePortable
    {
    public:
        Reply() = default;
        ~Reply() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool read(yarp::os::idl::WireReader& reader) override;

        std::string return_helper{};
    };

    using funcptr_t = std::string (*)();
    void call(yarprobotinterfaceRpc* ptr);

    Command cmd;
    Reply reply;

    static constexpr const char* s_tag{"get_phase"};
    static constexpr size_t s_tag_len{2};
    static constexpr size_t s_cmd_len{2};
    static constexpr size_t s_reply_len{1};
    static constexpr const char* s_prototype{"std::string yarprobotinterfaceRpc::get_phase()"};
    static constexpr const char* s_help{
        "Returns current phase."
    };
};

// get_level helper class declaration
class yarprobotinterfaceRpc_get_level_helper :
        public yarp::os::Portable
{
public:
    yarprobotinterfaceRpc_get_level_helper() = default;
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    class Command :
            public yarp::os::idl::WirePortable
    {
    public:
        Command() = default;
        ~Command() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool writeTag(const yarp::os::idl::WireWriter& writer) const;
        bool writeArgs(const yarp::os::idl::WireWriter& writer) const;

        bool read(yarp::os::idl::WireReader& reader) override;
        bool readTag(yarp::os::idl::WireReader& reader);
        bool readArgs(yarp::os::idl::WireReader& reader);
    };

    class Reply :
            public yarp::os::idl::WirePortable
    {
    public:
        Reply() = default;
        ~Reply() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool read(yarp::os::idl::WireReader& reader) override;

        std::int32_t return_helper{0};
    };

    using funcptr_t = std::int32_t (*)();
    void call(yarprobotinterfaceRpc* ptr);

    Command cmd;
    Reply reply;

    static constexpr const char* s_tag{"get_level"};
    static constexpr size_t s_tag_len{2};
    static constexpr size_t s_cmd_len{2};
    static constexpr size_t s_reply_len{1};
    static constexpr const char* s_prototype{"std::int32_t yarprobotinterfaceRpc::get_level()"};
    static constexpr const char* s_help{
        "Returns current level."
    };
};

// get_robot helper class declaration
class yarprobotinterfaceRpc_get_robot_helper :
        public yarp::os::Portable
{
public:
    yarprobotinterfaceRpc_get_robot_helper() = default;
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    class Command :
            public yarp::os::idl::WirePortable
    {
    public:
        Command() = default;
        ~Command() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool writeTag(const yarp::os::idl::WireWriter& writer) const;
        bool writeArgs(const yarp::os::idl::WireWriter& writer) const;

        bool read(yarp::os::idl::WireReader& reader) override;
        bool readTag(yarp::os::idl::WireReader& reader);
        bool readArgs(yarp::os::idl::WireReader& reader);
    };

    class Reply :
            public yarp::os::idl::WirePortable
    {
    public:
        Reply() = default;
        ~Reply() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool read(yarp::os::idl::WireReader& reader) override;

        std::string return_helper{};
    };

    using funcptr_t = std::string (*)();
    void call(yarprobotinterfaceRpc* ptr);

    Command cmd;
    Reply reply;

    static constexpr const char* s_tag{"get_robot"};
    static constexpr size_t s_tag_len{2};
    static constexpr size_t s_cmd_len{2};
    static constexpr size_t s_reply_len{1};
    static constexpr const char* s_prototype{"std::string yarprobotinterfaceRpc::get_robot()"};
    static constexpr const char* s_help{
        "Returns robot name."
    };
};

// is_ready helper class declaration
class yarprobotinterfaceRpc_is_ready_helper :
        public yarp::os::Portable
{
public:
    yarprobotinterfaceRpc_is_ready_helper() = default;
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    class Command :
            public yarp::os::idl::WirePortable
    {
    public:
        Command() = default;
        ~Command() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool writeTag(const yarp::os::idl::WireWriter& writer) const;
        bool writeArgs(const yarp::os::idl::WireWriter& writer) const;

        bool read(yarp::os::idl::WireReader& reader) override;
        bool readTag(yarp::os::idl::WireReader& reader);
        bool readArgs(yarp::os::idl::WireReader& reader);
    };

    class Reply :
            public yarp::os::idl::WirePortable
    {
    public:
        Reply() = default;
        ~Reply() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool read(yarp::os::idl::WireReader& reader) override;

        bool return_helper{false};
    };

    using funcptr_t = bool (*)();
    void call(yarprobotinterfaceRpc* ptr);

    Command cmd;
    Reply reply;

    static constexpr const char* s_tag{"is_ready"};
    static constexpr size_t s_tag_len{2};
    static constexpr size_t s_cmd_len{2};
    static constexpr size_t s_reply_len{1};
    static constexpr const char* s_prototype{"bool yarprobotinterfaceRpc::is_ready()"};
    static constexpr const char* s_help{
        "Returns true if yarprobotinterface is ready (all startup actions\n"
        "performed and no interrupt called)."
    };
};

// quit helper class declaration
class yarprobotinterfaceRpc_quit_helper :
        public yarp::os::Portable
{
public:
    yarprobotinterfaceRpc_quit_helper() = default;
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    class Command :
            public yarp::os::idl::WirePortable
    {
    public:
        Command() = default;
        ~Command() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool writeTag(const yarp::os::idl::WireWriter& writer) const;
        bool writeArgs(const yarp::os::idl::WireWriter& writer) const;

        bool read(yarp::os::idl::WireReader& reader) override;
        bool readTag(yarp::os::idl::WireReader& reader);
        bool readArgs(yarp::os::idl::WireReader& reader);
    };

    class Reply :
            public yarp::os::idl::WirePortable
    {
    public:
        Reply() = default;
        ~Reply() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool read(yarp::os::idl::WireReader& reader) override;

        std::string return_helper{};
    };

    using funcptr_t = std::string (*)();
    void call(yarprobotinterfaceRpc* ptr);

    Command cmd;
    Reply reply;

    static constexpr const char* s_tag{"quit"};
    static constexpr size_t s_tag_len{1};
    static constexpr size_t s_cmd_len{1};
    static constexpr size_t s_reply_len{1};
    static constexpr const char* s_prototype{"std::string yarprobotinterfaceRpc::quit()"};
    static constexpr const char* s_help{
        "Closes yarprobotinterface."
    };
};

// bye helper class declaration
class yarprobotinterfaceRpc_bye_helper :
        public yarp::os::Portable
{
public:
    yarprobotinterfaceRpc_bye_helper() = default;
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    class Command :
            public yarp::os::idl::WirePortable
    {
    public:
        Command() = default;
        ~Command() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool writeTag(const yarp::os::idl::WireWriter& writer) const;
        bool writeArgs(const yarp::os::idl::WireWriter& writer) const;

        bool read(yarp::os::idl::WireReader& reader) override;
        bool readTag(yarp::os::idl::WireReader& reader);
        bool readArgs(yarp::os::idl::WireReader& reader);
    };

    class Reply :
            public yarp::os::idl::WirePortable
    {
    public:
        Reply() = default;
        ~Reply() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool read(yarp::os::idl::WireReader& reader) override;

        std::string return_helper{};
    };

    using funcptr_t = std::string (*)();
    void call(yarprobotinterfaceRpc* ptr);

    Command cmd;
    Reply reply;

    static constexpr const char* s_tag{"bye"};
    static constexpr size_t s_tag_len{1};
    static constexpr size_t s_cmd_len{1};
    static constexpr size_t s_reply_len{1};
    static constexpr const char* s_prototype{"std::string yarprobotinterfaceRpc::bye()"};
    static constexpr const char* s_help{
        "Closes yarprobotinterface."
    };
};

// exit helper class declaration
class yarprobotinterfaceRpc_exit_helper :
        public yarp::os::Portable
{
public:
    yarprobotinterfaceRpc_exit_helper() = default;
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    class Command :
            public yarp::os::idl::WirePortable
    {
    public:
        Command() = default;
        ~Command() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool writeTag(const yarp::os::idl::WireWriter& writer) const;
        bool writeArgs(const yarp::os::idl::WireWriter& writer) const;

        bool read(yarp::os::idl::WireReader& reader) override;
        bool readTag(yarp::os::idl::WireReader& reader);
        bool readArgs(yarp::os::idl::WireReader& reader);
    };

    class Reply :
            public yarp::os::idl::WirePortable
    {
    public:
        Reply() = default;
        ~Reply() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool read(yarp::os::idl::WireReader& reader) override;

        std::string return_helper{};
    };

    using funcptr_t = std::string (*)();
    void call(yarprobotinterfaceRpc* ptr);

    Command cmd;
    Reply reply;

    static constexpr const char* s_tag{"exit"};
    static constexpr size_t s_tag_len{1};
    static constexpr size_t s_cmd_len{1};
    static constexpr size_t s_reply_len{1};
    static constexpr const char* s_prototype{"std::string yarprobotinterfaceRpc::exit()"};
    static constexpr const char* s_help{
        "Closes yarprobotinterface."
    };
};

// get_phase helper class implementation
bool yarprobotinterfaceRpc_get_phase_helper::write(yarp::os::ConnectionWriter& connection) const
{
    return cmd.write(connection);
}

bool yarprobotinterfaceRpc_get_phase_helper::read(yarp::os::ConnectionReader& connection)
{
    return reply.read(connection);
}

bool yarprobotinterfaceRpc_get_phase_helper::Command::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(s_cmd_len)) {
        return false;
    }
    return write(writer);
}

bool yarprobotinterfaceRpc_get_phase_helper::Command::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader()) {
        reader.fail();
        return false;
    }
    return read(reader);
}

bool yarprobotinterfaceRpc_get_phase_helper::Command::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writeTag(writer)) {
        return false;
    }
    if (!writeArgs(writer)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_phase_helper::Command::writeTag(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeTag(s_tag, 1, s_tag_len)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_phase_helper::Command::writeArgs(const yarp::os::idl::WireWriter& writer [[maybe_unused]]) const
{
    return true;
}

bool yarprobotinterfaceRpc_get_phase_helper::Command::read(yarp::os::idl::WireReader& reader)
{
    if (!readTag(reader)) {
        return false;
    }
    if (!readArgs(reader)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_phase_helper::Command::readTag(yarp::os::idl::WireReader& reader)
{
    std::string tag = reader.readTag();
    if (reader.isError()) {
        return false;
    }
    if (tag != s_tag) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_phase_helper::Command::readArgs(yarp::os::idl::WireReader& reader)
{
    if (!reader.noMore()) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_phase_helper::Reply::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    return write(writer);
}

bool yarprobotinterfaceRpc_get_phase_helper::Reply::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    return read(reader);
}

bool yarprobotinterfaceRpc_get_phase_helper::Reply::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.isNull()) {
        if (!writer.writeListHeader(s_reply_len)) {
            return false;
        }
        if (!writer.writeString(return_helper)) {
            return false;
        }
    }
    return true;
}

bool yarprobotinterfaceRpc_get_phase_helper::Reply::read(yarp::os::idl::WireReader& reader)
{
    if (!reader.readListReturn()) {
        return false;
    }
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readString(return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

void yarprobotinterfaceRpc_get_phase_helper::call(yarprobotinterfaceRpc* ptr)
{
    reply.return_helper = ptr->get_phase();
}

// get_level helper class implementation
bool yarprobotinterfaceRpc_get_level_helper::write(yarp::os::ConnectionWriter& connection) const
{
    return cmd.write(connection);
}

bool yarprobotinterfaceRpc_get_level_helper::read(yarp::os::ConnectionReader& connection)
{
    return reply.read(connection);
}

bool yarprobotinterfaceRpc_get_level_helper::Command::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(s_cmd_len)) {
        return false;
    }
    return write(writer);
}

bool yarprobotinterfaceRpc_get_level_helper::Command::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader()) {
        reader.fail();
        return false;
    }
    return read(reader);
}

bool yarprobotinterfaceRpc_get_level_helper::Command::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writeTag(writer)) {
        return false;
    }
    if (!writeArgs(writer)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_level_helper::Command::writeTag(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeTag(s_tag, 1, s_tag_len)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_level_helper::Command::writeArgs(const yarp::os::idl::WireWriter& writer [[maybe_unused]]) const
{
    return true;
}

bool yarprobotinterfaceRpc_get_level_helper::Command::read(yarp::os::idl::WireReader& reader)
{
    if (!readTag(reader)) {
        return false;
    }
    if (!readArgs(reader)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_level_helper::Command::readTag(yarp::os::idl::WireReader& reader)
{
    std::string tag = reader.readTag();
    if (reader.isError()) {
        return false;
    }
    if (tag != s_tag) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_level_helper::Command::readArgs(yarp::os::idl::WireReader& reader)
{
    if (!reader.noMore()) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_level_helper::Reply::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    return write(writer);
}

bool yarprobotinterfaceRpc_get_level_helper::Reply::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    return read(reader);
}

bool yarprobotinterfaceRpc_get_level_helper::Reply::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.isNull()) {
        if (!writer.writeListHeader(s_reply_len)) {
            return false;
        }
        if (!writer.writeI32(return_helper)) {
            return false;
        }
    }
    return true;
}

bool yarprobotinterfaceRpc_get_level_helper::Reply::read(yarp::os::idl::WireReader& reader)
{
    if (!reader.readListReturn()) {
        return false;
    }
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readI32(return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

void yarprobotinterfaceRpc_get_level_helper::call(yarprobotinterfaceRpc* ptr)
{
    reply.return_helper = ptr->get_level();
}

// get_robot helper class implementation
bool yarprobotinterfaceRpc_get_robot_helper::write(yarp::os::ConnectionWriter& connection) const
{
    return cmd.write(connection);
}

bool yarprobotinterfaceRpc_get_robot_helper::read(yarp::os::ConnectionReader& connection)
{
    return reply.read(connection);
}

bool yarprobotinterfaceRpc_get_robot_helper::Command::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(s_cmd_len)) {
        return false;
    }
    return write(writer);
}

bool yarprobotinterfaceRpc_get_robot_helper::Command::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader()) {
        reader.fail();
        return false;
    }
    return read(reader);
}

bool yarprobotinterfaceRpc_get_robot_helper::Command::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writeTag(writer)) {
        return false;
    }
    if (!writeArgs(writer)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_robot_helper::Command::writeTag(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeTag(s_tag, 1, s_tag_len)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_robot_helper::Command::writeArgs(const yarp::os::idl::WireWriter& writer [[maybe_unused]]) const
{
    return true;
}

bool yarprobotinterfaceRpc_get_robot_helper::Command::read(yarp::os::idl::WireReader& reader)
{
    if (!readTag(reader)) {
        return false;
    }
    if (!readArgs(reader)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_robot_helper::Command::readTag(yarp::os::idl::WireReader& reader)
{
    std::string tag = reader.readTag();
    if (reader.isError()) {
        return false;
    }
    if (tag != s_tag) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_robot_helper::Command::readArgs(yarp::os::idl::WireReader& reader)
{
    if (!reader.noMore()) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_get_robot_helper::Reply::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    return write(writer);
}

bool yarprobotinterfaceRpc_get_robot_helper::Reply::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    return read(reader);
}

bool yarprobotinterfaceRpc_get_robot_helper::Reply::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.isNull()) {
        if (!writer.writeListHeader(s_reply_len)) {
            return false;
        }
        if (!writer.writeString(return_helper)) {
            return false;
        }
    }
    return true;
}

bool yarprobotinterfaceRpc_get_robot_helper::Reply::read(yarp::os::idl::WireReader& reader)
{
    if (!reader.readListReturn()) {
        return false;
    }
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readString(return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

void yarprobotinterfaceRpc_get_robot_helper::call(yarprobotinterfaceRpc* ptr)
{
    reply.return_helper = ptr->get_robot();
}

// is_ready helper class implementation
bool yarprobotinterfaceRpc_is_ready_helper::write(yarp::os::ConnectionWriter& connection) const
{
    return cmd.write(connection);
}

bool yarprobotinterfaceRpc_is_ready_helper::read(yarp::os::ConnectionReader& connection)
{
    return reply.read(connection);
}

bool yarprobotinterfaceRpc_is_ready_helper::Command::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(s_cmd_len)) {
        return false;
    }
    return write(writer);
}

bool yarprobotinterfaceRpc_is_ready_helper::Command::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader()) {
        reader.fail();
        return false;
    }
    return read(reader);
}

bool yarprobotinterfaceRpc_is_ready_helper::Command::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writeTag(writer)) {
        return false;
    }
    if (!writeArgs(writer)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_is_ready_helper::Command::writeTag(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeTag(s_tag, 1, s_tag_len)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_is_ready_helper::Command::writeArgs(const yarp::os::idl::WireWriter& writer [[maybe_unused]]) const
{
    return true;
}

bool yarprobotinterfaceRpc_is_ready_helper::Command::read(yarp::os::idl::WireReader& reader)
{
    if (!readTag(reader)) {
        return false;
    }
    if (!readArgs(reader)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_is_ready_helper::Command::readTag(yarp::os::idl::WireReader& reader)
{
    std::string tag = reader.readTag();
    if (reader.isError()) {
        return false;
    }
    if (tag != s_tag) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_is_ready_helper::Command::readArgs(yarp::os::idl::WireReader& reader)
{
    if (!reader.noMore()) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_is_ready_helper::Reply::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    return write(writer);
}

bool yarprobotinterfaceRpc_is_ready_helper::Reply::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    return read(reader);
}

bool yarprobotinterfaceRpc_is_ready_helper::Reply::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.isNull()) {
        if (!writer.writeListHeader(s_reply_len)) {
            return false;
        }
        if (!writer.writeBool(return_helper)) {
            return false;
        }
    }
    return true;
}

bool yarprobotinterfaceRpc_is_ready_helper::Reply::read(yarp::os::idl::WireReader& reader)
{
    if (!reader.readListReturn()) {
        return false;
    }
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readBool(return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

void yarprobotinterfaceRpc_is_ready_helper::call(yarprobotinterfaceRpc* ptr)
{
    reply.return_helper = ptr->is_ready();
}

// quit helper class implementation
bool yarprobotinterfaceRpc_quit_helper::write(yarp::os::ConnectionWriter& connection) const
{
    return cmd.write(connection);
}

bool yarprobotinterfaceRpc_quit_helper::read(yarp::os::ConnectionReader& connection)
{
    return reply.read(connection);
}

bool yarprobotinterfaceRpc_quit_helper::Command::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(s_cmd_len)) {
        return false;
    }
    return write(writer);
}

bool yarprobotinterfaceRpc_quit_helper::Command::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader()) {
        reader.fail();
        return false;
    }
    return read(reader);
}

bool yarprobotinterfaceRpc_quit_helper::Command::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writeTag(writer)) {
        return false;
    }
    if (!writeArgs(writer)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_quit_helper::Command::writeTag(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeTag(s_tag, 1, s_tag_len)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_quit_helper::Command::writeArgs(const yarp::os::idl::WireWriter& writer [[maybe_unused]]) const
{
    return true;
}

bool yarprobotinterfaceRpc_quit_helper::Command::read(yarp::os::idl::WireReader& reader)
{
    if (!readTag(reader)) {
        return false;
    }
    if (!readArgs(reader)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_quit_helper::Command::readTag(yarp::os::idl::WireReader& reader)
{
    std::string tag = reader.readTag();
    if (reader.isError()) {
        return false;
    }
    if (tag != s_tag) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_quit_helper::Command::readArgs(yarp::os::idl::WireReader& reader)
{
    if (!reader.noMore()) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_quit_helper::Reply::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    return write(writer);
}

bool yarprobotinterfaceRpc_quit_helper::Reply::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    return read(reader);
}

bool yarprobotinterfaceRpc_quit_helper::Reply::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.isNull()) {
        if (!writer.writeListHeader(s_reply_len)) {
            return false;
        }
        if (!writer.writeString(return_helper)) {
            return false;
        }
    }
    return true;
}

bool yarprobotinterfaceRpc_quit_helper::Reply::read(yarp::os::idl::WireReader& reader)
{
    if (!reader.readListReturn()) {
        return false;
    }
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readString(return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

void yarprobotinterfaceRpc_quit_helper::call(yarprobotinterfaceRpc* ptr)
{
    reply.return_helper = ptr->quit();
}

// bye helper class implementation
bool yarprobotinterfaceRpc_bye_helper::write(yarp::os::ConnectionWriter& connection) const
{
    return cmd.write(connection);
}

bool yarprobotinterfaceRpc_bye_helper::read(yarp::os::ConnectionReader& connection)
{
    return reply.read(connection);
}

bool yarprobotinterfaceRpc_bye_helper::Command::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(s_cmd_len)) {
        return false;
    }
    return write(writer);
}

bool yarprobotinterfaceRpc_bye_helper::Command::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader()) {
        reader.fail();
        return false;
    }
    return read(reader);
}

bool yarprobotinterfaceRpc_bye_helper::Command::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writeTag(writer)) {
        return false;
    }
    if (!writeArgs(writer)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_bye_helper::Command::writeTag(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeTag(s_tag, 1, s_tag_len)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_bye_helper::Command::writeArgs(const yarp::os::idl::WireWriter& writer [[maybe_unused]]) const
{
    return true;
}

bool yarprobotinterfaceRpc_bye_helper::Command::read(yarp::os::idl::WireReader& reader)
{
    if (!readTag(reader)) {
        return false;
    }
    if (!readArgs(reader)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_bye_helper::Command::readTag(yarp::os::idl::WireReader& reader)
{
    std::string tag = reader.readTag();
    if (reader.isError()) {
        return false;
    }
    if (tag != s_tag) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_bye_helper::Command::readArgs(yarp::os::idl::WireReader& reader)
{
    if (!reader.noMore()) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_bye_helper::Reply::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    return write(writer);
}

bool yarprobotinterfaceRpc_bye_helper::Reply::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    return read(reader);
}

bool yarprobotinterfaceRpc_bye_helper::Reply::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.isNull()) {
        if (!writer.writeListHeader(s_reply_len)) {
            return false;
        }
        if (!writer.writeString(return_helper)) {
            return false;
        }
    }
    return true;
}

bool yarprobotinterfaceRpc_bye_helper::Reply::read(yarp::os::idl::WireReader& reader)
{
    if (!reader.readListReturn()) {
        return false;
    }
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readString(return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

void yarprobotinterfaceRpc_bye_helper::call(yarprobotinterfaceRpc* ptr)
{
    reply.return_helper = ptr->bye();
}

// exit helper class implementation
bool yarprobotinterfaceRpc_exit_helper::write(yarp::os::ConnectionWriter& connection) const
{
    return cmd.write(connection);
}

bool yarprobotinterfaceRpc_exit_helper::read(yarp::os::ConnectionReader& connection)
{
    return reply.read(connection);
}

bool yarprobotinterfaceRpc_exit_helper::Command::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(s_cmd_len)) {
        return false;
    }
    return write(writer);
}

bool yarprobotinterfaceRpc_exit_helper::Command::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader()) {
        reader.fail();
        return false;
    }
    return read(reader);
}

bool yarprobotinterfaceRpc_exit_helper::Command::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writeTag(writer)) {
        return false;
    }
    if (!writeArgs(writer)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_exit_helper::Command::writeTag(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeTag(s_tag, 1, s_tag_len)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_exit_helper::Command::writeArgs(const yarp::os::idl::WireWriter& writer [[maybe_unused]]) const
{
    return true;
}

bool yarprobotinterfaceRpc_exit_helper::Command::read(yarp::os::idl::WireReader& reader)
{
    if (!readTag(reader)) {
        return false;
    }
    if (!readArgs(reader)) {
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_exit_helper::Command::readTag(yarp::os::idl::WireReader& reader)
{
    std::string tag = reader.readTag();
    if (reader.isError()) {
        return false;
    }
    if (tag != s_tag) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_exit_helper::Command::readArgs(yarp::os::idl::WireReader& reader)
{
    if (!reader.noMore()) {
        reader.fail();
        return false;
    }
    return true;
}

bool yarprobotinterfaceRpc_exit_helper::Reply::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    return write(writer);
}

bool yarprobotinterfaceRpc_exit_helper::Reply::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    return read(reader);
}

bool yarprobotinterfaceRpc_exit_helper::Reply::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.isNull()) {
        if (!writer.writeListHeader(s_reply_len)) {
            return false;
        }
        if (!writer.writeString(return_helper)) {
            return false;
        }
    }
    return true;
}

bool yarprobotinterfaceRpc_exit_helper::Reply::read(yarp::os::idl::WireReader& reader)
{
    if (!reader.readListReturn()) {
        return false;
    }
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readString(return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

void yarprobotinterfaceRpc_exit_helper::call(yarprobotinterfaceRpc* ptr)
{
    reply.return_helper = ptr->exit();
}

// Constructor
yarprobotinterfaceRpc::yarprobotinterfaceRpc()
{
    yarp().setOwner(*this);
}

std::string yarprobotinterfaceRpc::get_phase()
{
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", yarprobotinterfaceRpc_get_phase_helper::s_prototype);
    }
    yarprobotinterfaceRpc_get_phase_helper helper{};
    bool ok = yarp().write(helper, helper);
    return ok ? helper.reply.return_helper : std::string{};
}

std::int32_t yarprobotinterfaceRpc::get_level()
{
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", yarprobotinterfaceRpc_get_level_helper::s_prototype);
    }
    yarprobotinterfaceRpc_get_level_helper helper{};
    bool ok = yarp().write(helper, helper);
    return ok ? helper.reply.return_helper : std::int32_t{};
}

std::string yarprobotinterfaceRpc::get_robot()
{
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", yarprobotinterfaceRpc_get_robot_helper::s_prototype);
    }
    yarprobotinterfaceRpc_get_robot_helper helper{};
    bool ok = yarp().write(helper, helper);
    return ok ? helper.reply.return_helper : std::string{};
}

bool yarprobotinterfaceRpc::is_ready()
{
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", yarprobotinterfaceRpc_is_ready_helper::s_prototype);
    }
    yarprobotinterfaceRpc_is_ready_helper helper{};
    bool ok = yarp().write(helper, helper);
    return ok ? helper.reply.return_helper : bool{};
}

std::string yarprobotinterfaceRpc::quit()
{
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", yarprobotinterfaceRpc_quit_helper::s_prototype);
    }
    yarprobotinterfaceRpc_quit_helper helper{};
    bool ok = yarp().write(helper, helper);
    return ok ? helper.reply.return_helper : std::string{};
}

std::string yarprobotinterfaceRpc::bye()
{
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", yarprobotinterfaceRpc_bye_helper::s_prototype);
    }
    yarprobotinterfaceRpc_bye_helper helper{};
    bool ok = yarp().write(helper, helper);
    return ok ? helper.reply.return_helper : std::string{};
}

std::string yarprobotinterfaceRpc::exit()
{
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", yarprobotinterfaceRpc_exit_helper::s_prototype);
    }
    yarprobotinterfaceRpc_exit_helper helper{};
    bool ok = yarp().write(helper, helper);
    return ok ? helper.reply.return_helper : std::string{};
}

// help method
std::vector<std::string> yarprobotinterfaceRpc::help(const std::string& functionName)
{
    bool showAll = (functionName == "--all");
    std::vector<std::string> helpString;
    if (showAll) {
        helpString.emplace_back("*** Available commands:");
        helpString.emplace_back(yarprobotinterfaceRpc_get_phase_helper::s_tag);
        helpString.emplace_back(yarprobotinterfaceRpc_get_level_helper::s_tag);
        helpString.emplace_back(yarprobotinterfaceRpc_get_robot_helper::s_tag);
        helpString.emplace_back(yarprobotinterfaceRpc_is_ready_helper::s_tag);
        helpString.emplace_back(yarprobotinterfaceRpc_quit_helper::s_tag);
        helpString.emplace_back(yarprobotinterfaceRpc_bye_helper::s_tag);
        helpString.emplace_back(yarprobotinterfaceRpc_exit_helper::s_tag);
        helpString.emplace_back("help");
    } else {
        if (functionName == yarprobotinterfaceRpc_get_phase_helper::s_tag) {
            helpString.emplace_back(yarprobotinterfaceRpc_get_phase_helper::s_prototype);
            helpString.emplace_back(yarprobotinterfaceRpc_get_phase_helper::s_help);
        }
        if (functionName == yarprobotinterfaceRpc_get_level_helper::s_tag) {
            helpString.emplace_back(yarprobotinterfaceRpc_get_level_helper::s_prototype);
            helpString.emplace_back(yarprobotinterfaceRpc_get_level_helper::s_help);
        }
        if (functionName == yarprobotinterfaceRpc_get_robot_helper::s_tag) {
            helpString.emplace_back(yarprobotinterfaceRpc_get_robot_helper::s_prototype);
            helpString.emplace_back(yarprobotinterfaceRpc_get_robot_helper::s_help);
        }
        if (functionName == yarprobotinterfaceRpc_is_ready_helper::s_tag) {
            helpString.emplace_back(yarprobotinterfaceRpc_is_ready_helper::s_prototype);
            helpString.emplace_back(yarprobotinterfaceRpc_is_ready_helper::s_help);
        }
        if (functionName == yarprobotinterfaceRpc_quit_helper::s_tag) {
            helpString.emplace_back(yarprobotinterfaceRpc_quit_helper::s_prototype);
            helpString.emplace_back(yarprobotinterfaceRpc_quit_helper::s_help);
        }
        if (functionName == yarprobotinterfaceRpc_bye_helper::s_tag) {
            helpString.emplace_back(yarprobotinterfaceRpc_bye_helper::s_prototype);
            helpString.emplace_back(yarprobotinterfaceRpc_bye_helper::s_help);
        }
        if (functionName == yarprobotinterfaceRpc_exit_helper::s_tag) {
            helpString.emplace_back(yarprobotinterfaceRpc_exit_helper::s_prototype);
            helpString.emplace_back(yarprobotinterfaceRpc_exit_helper::s_help);
        }
        if (functionName == "help") {
            helpString.emplace_back("std::vector<std::string> help(const std::string& functionName = \"--all\")");
            helpString.emplace_back("Return list of available commands, or help message for a specific function");
            helpString.emplace_back("@param functionName name of command for which to get a detailed description. If none or '--all' is provided, print list of available commands");
            helpString.emplace_back("@return list of strings (one string per line)");
        }
    }
    if (helpString.empty()) {
        helpString.emplace_back("Command not found");
    }
    return helpString;
}

// read from ConnectionReader
bool yarprobotinterfaceRpc::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    reader.expectAccept();
    if (!reader.readListHeader()) {
        reader.fail();
        return false;
    }

    std::string tag = reader.readTag();
    bool direct = (tag == "__direct__");
    if (direct) {
        tag = reader.readTag();
    }
    while (!reader.isError()) {
        if (tag == yarprobotinterfaceRpc_get_phase_helper::s_tag) {
            yarprobotinterfaceRpc_get_phase_helper helper;
            if (!helper.cmd.readArgs(reader)) {
                return false;
            }

            helper.call(this);

            yarp::os::idl::WireWriter writer(reader);
            if (!helper.reply.write(writer)) {
                return false;
            }
            reader.accept();
            return true;
        }
        if (tag == yarprobotinterfaceRpc_get_level_helper::s_tag) {
            yarprobotinterfaceRpc_get_level_helper helper;
            if (!helper.cmd.readArgs(reader)) {
                return false;
            }

            helper.call(this);

            yarp::os::idl::WireWriter writer(reader);
            if (!helper.reply.write(writer)) {
                return false;
            }
            reader.accept();
            return true;
        }
        if (tag == yarprobotinterfaceRpc_get_robot_helper::s_tag) {
            yarprobotinterfaceRpc_get_robot_helper helper;
            if (!helper.cmd.readArgs(reader)) {
                return false;
            }

            helper.call(this);

            yarp::os::idl::WireWriter writer(reader);
            if (!helper.reply.write(writer)) {
                return false;
            }
            reader.accept();
            return true;
        }
        if (tag == yarprobotinterfaceRpc_is_ready_helper::s_tag) {
            yarprobotinterfaceRpc_is_ready_helper helper;
            if (!helper.cmd.readArgs(reader)) {
                return false;
            }

            helper.call(this);

            yarp::os::idl::WireWriter writer(reader);
            if (!helper.reply.write(writer)) {
                return false;
            }
            reader.accept();
            return true;
        }
        if (tag == yarprobotinterfaceRpc_quit_helper::s_tag) {
            yarprobotinterfaceRpc_quit_helper helper;
            if (!helper.cmd.readArgs(reader)) {
                return false;
            }

            helper.call(this);

            yarp::os::idl::WireWriter writer(reader);
            if (!helper.reply.write(writer)) {
                return false;
            }
            reader.accept();
            return true;
        }
        if (tag == yarprobotinterfaceRpc_bye_helper::s_tag) {
            yarprobotinterfaceRpc_bye_helper helper;
            if (!helper.cmd.readArgs(reader)) {
                return false;
            }

            helper.call(this);

            yarp::os::idl::WireWriter writer(reader);
            if (!helper.reply.write(writer)) {
                return false;
            }
            reader.accept();
            return true;
        }
        if (tag == yarprobotinterfaceRpc_exit_helper::s_tag) {
            yarprobotinterfaceRpc_exit_helper helper;
            if (!helper.cmd.readArgs(reader)) {
                return false;
            }

            helper.call(this);

            yarp::os::idl::WireWriter writer(reader);
            if (!helper.reply.write(writer)) {
                return false;
            }
            reader.accept();
            return true;
        }
        if (tag == "help") {
            std::string functionName;
            if (!reader.readString(functionName)) {
                functionName = "--all";
            }
            auto help_strings = help(functionName);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeTag("many", 1, 0)) {
                    return false;
                }
                if (!writer.writeListBegin(BOTTLE_TAG_INT32, static_cast<uint32_t>(help_strings.size()))) {
                    return false;
                }
                for (const auto& help_string : help_strings) {
                    if (!writer.writeString(help_string)) {
                        return false;
                    }
                }
                if (!writer.writeListEnd()) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (reader.noMore()) {
            reader.fail();
            return false;
        }
        std::string next_tag = reader.readTag();
        if (next_tag.empty()) {
            break;
        }
        tag.append("_").append(next_tag);
    }
    return false;
}
