# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request, Response, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.department_units = DepartmentUnitService(self)
        self.users = UserService(self)
        self.user_groups = UserGroupService(self)
        self.user_group_members = UserGroupMemberService(self)
        self.departments = DepartmentService(self)
        self.scopes = ScopeService(self)
        self.custom_attr_events = CustomAttrEventService(self)
        



class DepartmentUnitService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def delete(self, tenant_key=None, timeout=None):
        # type: (str, int) -> DepartmentUnitDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DepartmentUnitDeleteReqCall(self, request_opts=request_opts)

    def patch(self, body, tenant_key=None, timeout=None):
        # type: (DepartmentUnitPatchReqBody, str, int) -> DepartmentUnitPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DepartmentUnitPatchReqCall(self, body, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (DepartmentUnit, str, int) -> DepartmentUnitCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DepartmentUnitCreateReqCall(self, body, request_opts=request_opts)


class UserService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def delete(self, body, tenant_key=None, timeout=None):
        # type: (UserDeleteReqBody, str, int) -> UserDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserDeleteReqCall(self, body, request_opts=request_opts)

    def update(self, body, tenant_key=None, timeout=None):
        # type: (User, str, int) -> UserUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserUpdateReqCall(self, body, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (User, str, int) -> UserCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserCreateReqCall(self, body, request_opts=request_opts)

    def patch(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (User, str, str, int) -> UserPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return UserPatchReqCall(self, body, request_opts=request_opts)

    def update_user_id(self, body, tenant_key=None, timeout=None):
        # type: (UserUpdateUserIdReqBody, str, int) -> UserUpdateUserIdReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserUpdateUserIdReqCall(self, body, request_opts=request_opts)

    def get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> UserGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return UserGetReqCall(self, request_opts=request_opts)

    def list(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> UserListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return UserListReqCall(self, request_opts=request_opts)


class UserGroupService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def update_user_group_id(self, body, tenant_key=None, timeout=None):
        # type: (UserGroupUpdateUserGroupIdReqBody, str, int) -> UserGroupUpdateUserGroupIdReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserGroupUpdateUserGroupIdReqCall(self, body, request_opts=request_opts)

    def delete(self, tenant_key=None, timeout=None):
        # type: (str, int) -> UserGroupDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserGroupDeleteReqCall(self, request_opts=request_opts)

    def patch(self, body, tenant_key=None, timeout=None):
        # type: (UserGroup, str, int) -> UserGroupPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserGroupPatchReqCall(self, body, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (UserGroup, str, int) -> UserGroupCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserGroupCreateReqCall(self, body, request_opts=request_opts)

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> UserGroupListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserGroupListReqCall(self, request_opts=request_opts)

    def get(self, tenant_key=None, timeout=None):
        # type: (str, int) -> UserGroupGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserGroupGetReqCall(self, request_opts=request_opts)


class UserGroupMemberService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def create(self, body, tenant_key=None, timeout=None):
        # type: (UserGroupMemberCreateReqBody, str, int) -> UserGroupMemberCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserGroupMemberCreateReqCall(self, body, request_opts=request_opts)

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> UserGroupMemberListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserGroupMemberListReqCall(self, request_opts=request_opts)

    def delete(self, tenant_key=None, timeout=None):
        # type: (str, int) -> UserGroupMemberDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserGroupMemberDeleteReqCall(self, request_opts=request_opts)


class DepartmentService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> DepartmentGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return DepartmentGetReqCall(self, request_opts=request_opts)

    def list(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> DepartmentListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return DepartmentListReqCall(self, request_opts=request_opts)

    def patch(self, body, tenant_key=None, timeout=None):
        # type: (Department, str, int) -> DepartmentPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DepartmentPatchReqCall(self, body, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (Department, str, int) -> DepartmentCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DepartmentCreateReqCall(self, body, request_opts=request_opts)

    def delete(self, tenant_key=None, timeout=None):
        # type: (str, int) -> DepartmentDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DepartmentDeleteReqCall(self, request_opts=request_opts)

    def update(self, body, tenant_key=None, timeout=None):
        # type: (Department, str, int) -> DepartmentUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DepartmentUpdateReqCall(self, body, request_opts=request_opts)

    def parent(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> DepartmentParentReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return DepartmentParentReqCall(self, request_opts=request_opts)

    def update_department_id(self, body, tenant_key=None, timeout=None):
        # type: (DepartmentUpdateDepartmentIdReqBody, str, int) -> DepartmentUpdateDepartmentIdReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DepartmentUpdateDepartmentIdReqCall(self, body, request_opts=request_opts)

    def unbind_department_chat(self, body, tenant_key=None, timeout=None):
        # type: (DepartmentUnbindDepartmentChatReqBody, str, int) -> DepartmentUnbindDepartmentChatReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DepartmentUnbindDepartmentChatReqCall(self, body, request_opts=request_opts)

    def search(self, body, user_access_token=None, timeout=None):
        # type: (DepartmentSearchReqBody, str, int) -> DepartmentSearchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return DepartmentSearchReqCall(self, body, request_opts=request_opts)


class ScopeService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service


class CustomAttrEventService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service



class DepartmentGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (DepartmentService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_department_id(self, departmentId):
        # type: (str) -> DepartmentGetReqCall
        self.path_params['department_id'] = departmentId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> DepartmentGetReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> DepartmentGetReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def do(self):
        # type: () -> Response[DepartmentGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/:department_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserDeleteReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (UserService, UserDeleteReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id(self, userId):
        # type: (str) -> UserDeleteReqCall
        self.path_params['user_id'] = userId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> UserDeleteReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/users/:user_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (DepartmentService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, userIdType):
        # type: (str) -> DepartmentListReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> DepartmentListReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def set_parent_department_id(self, parentDepartmentId):
        # type: (str) -> DepartmentListReqCall
        self.query_params['parent_department_id'] = parentDepartmentId
        return self

    def set_fetch_child(self, fetchChild):
        # type: (bool) -> DepartmentListReqCall
        self.query_params['fetch_child'] = fetchChild
        return self

    def set_page_token(self, pageToken):
        # type: (str) -> DepartmentListReqCall
        self.query_params['page_token'] = pageToken
        return self

    def set_page_size(self, pageSize):
        # type: (int) -> DepartmentListReqCall
        self.query_params['page_size'] = pageSize
        return self

    def do(self):
        # type: () -> Response[DepartmentListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserGroupUpdateUserGroupIdReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (UserGroupService, UserGroupUpdateUserGroupIdReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_group_id(self, userGroupId):
        # type: (str) -> UserGroupUpdateUserGroupIdReqCall
        self.path_params['user_group_id'] = userGroupId
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('contact/v3/user_groups/:user_group_id/update_user_group_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentUnitDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (DepartmentUnitService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_unit_id(self, unitId):
        # type: (str) -> DepartmentUnitDeleteReqCall
        self.path_params['unit_id'] = unitId
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('contact/v3/department_units/:unit_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DepartmentService, Department, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_department_id(self, departmentId):
        # type: (str) -> DepartmentPatchReqCall
        self.path_params['department_id'] = departmentId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> DepartmentPatchReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> DepartmentPatchReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def do(self):
        # type: () -> Response[DepartmentPatchResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/:department_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=DepartmentPatchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (UserService, User, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id(self, userId):
        # type: (str) -> UserUpdateReqCall
        self.path_params['user_id'] = userId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> UserUpdateReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> UserUpdateReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def do(self):
        # type: () -> Response[UserUpdateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/users/:user_id', 'PUT', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=UserUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (UserService, User, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, userIdType):
        # type: (str) -> UserCreateReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> UserCreateReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def set_client_token(self, clientToken):
        # type: (str) -> UserCreateReqCall
        self.query_params['client_token'] = clientToken
        return self

    def do(self):
        # type: () -> Response[UserCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/users', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=UserCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (UserService, User, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id(self, userId):
        # type: (str) -> UserPatchReqCall
        self.path_params['user_id'] = userId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> UserPatchReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> UserPatchReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def do(self):
        # type: () -> Response[UserPatchResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/users/:user_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=UserPatchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserUpdateUserIdReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (UserService, UserUpdateUserIdReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id(self, userId):
        # type: (str) -> UserUpdateUserIdReqCall
        self.path_params['user_id'] = userId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> UserUpdateUserIdReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/users/:user_id/update_user_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserGroupMemberCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (UserGroupMemberService, UserGroupMemberCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_group_id(self, userGroupId):
        # type: (str) -> UserGroupMemberCreateReqCall
        self.path_params['user_group_id'] = userGroupId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> UserGroupMemberCreateReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/user_groups/:user_group_id/members', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserGroupDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (UserGroupService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_group_id(self, userGroupId):
        # type: (str) -> UserGroupDeleteReqCall
        self.path_params['user_group_id'] = userGroupId
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('contact/v3/user_groups/:user_group_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DepartmentService, Department, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, userIdType):
        # type: (str) -> DepartmentCreateReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> DepartmentCreateReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def set_client_token(self, clientToken):
        # type: (str) -> DepartmentCreateReqCall
        self.query_params['client_token'] = clientToken
        return self

    def do(self):
        # type: () -> Response[DepartmentCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=DepartmentCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserGroupPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (UserGroupService, UserGroup, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_group_id(self, userGroupId):
        # type: (str) -> UserGroupPatchReqCall
        self.path_params['user_group_id'] = userGroupId
        return self

    def do(self):
        # type: () -> Response[UserGroupPatchResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('contact/v3/user_groups/:user_group_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=UserGroupPatchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentUnitPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DepartmentUnitService, DepartmentUnitPatchReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_unit_id(self, unitId):
        # type: (str) -> DepartmentUnitPatchReqCall
        self.path_params['unit_id'] = unitId
        return self

    def do(self):
        # type: () -> Response[DepartmentUnitPatchResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('contact/v3/department_units/:unit_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=DepartmentUnitPatchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserGroupCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (UserGroupService, UserGroup, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[UserGroupCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('contact/v3/user_groups', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=UserGroupCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserGroupListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (UserGroupService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_page_size(self, pageSize):
        # type: (int) -> UserGroupListReqCall
        self.query_params['page_size'] = pageSize
        return self

    def set_page_token(self, pageToken):
        # type: (str) -> UserGroupListReqCall
        self.query_params['page_token'] = pageToken
        return self

    def do(self):
        # type: () -> Response[UserGroupListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/user_groups', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (DepartmentService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_department_id(self, departmentId):
        # type: (str) -> DepartmentDeleteReqCall
        self.path_params['department_id'] = departmentId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> DepartmentDeleteReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> DepartmentDeleteReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/:department_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (UserService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id(self, userId):
        # type: (str) -> UserGetReqCall
        self.path_params['user_id'] = userId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> UserGetReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> UserGetReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def do(self):
        # type: () -> Response[UserGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/users/:user_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserGroupMemberListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (UserGroupMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_group_id(self, userGroupId):
        # type: (str) -> UserGroupMemberListReqCall
        self.path_params['user_group_id'] = userGroupId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> UserGroupMemberListReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> UserGroupMemberListReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def set_page_token(self, pageToken):
        # type: (str) -> UserGroupMemberListReqCall
        self.query_params['page_token'] = pageToken
        return self

    def set_page_size(self, pageSize):
        # type: (int) -> UserGroupMemberListReqCall
        self.query_params['page_size'] = pageSize
        return self

    def do(self):
        # type: () -> Response[UserGroupMemberListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/user_groups/:user_group_id/members', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserGroupMemberDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (UserGroupMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_group_id(self, userGroupId):
        # type: (str) -> UserGroupMemberDeleteReqCall
        self.path_params['user_group_id'] = userGroupId
        return self

    def set_user_id(self, userId):
        # type: (str) -> UserGroupMemberDeleteReqCall
        self.path_params['user_id'] = userId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> UserGroupMemberDeleteReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/user_groups/:user_group_id/members/:user_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DepartmentService, Department, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_department_id(self, departmentId):
        # type: (str) -> DepartmentUpdateReqCall
        self.path_params['department_id'] = departmentId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> DepartmentUpdateReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> DepartmentUpdateReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def do(self):
        # type: () -> Response[DepartmentUpdateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/:department_id', 'PUT', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=DepartmentUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentUnitCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DepartmentUnitService, DepartmentUnit, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[DepartmentUnitCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('contact/v3/department_units', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=DepartmentUnitCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (UserService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, userIdType):
        # type: (str) -> UserListReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> UserListReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def set_department_id(self, departmentId):
        # type: (str) -> UserListReqCall
        self.query_params['department_id'] = departmentId
        return self

    def set_page_token(self, pageToken):
        # type: (str) -> UserListReqCall
        self.query_params['page_token'] = pageToken
        return self

    def set_page_size(self, pageSize):
        # type: (int) -> UserListReqCall
        self.query_params['page_size'] = pageSize
        return self

    def do(self):
        # type: () -> Response[UserListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/users', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserGroupGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (UserGroupService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_group_id(self, userGroupId):
        # type: (str) -> UserGroupGetReqCall
        self.path_params['user_group_id'] = userGroupId
        return self

    def do(self):
        # type: () -> Response[UserGroupGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('contact/v3/user_groups/:user_group_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentParentReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (DepartmentService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, userIdType):
        # type: (str) -> DepartmentParentReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> DepartmentParentReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def set_department_id(self, departmentId):
        # type: (str) -> DepartmentParentReqCall
        self.query_params['department_id'] = departmentId
        return self

    def set_page_token(self, pageToken):
        # type: (str) -> DepartmentParentReqCall
        self.query_params['page_token'] = pageToken
        return self

    def set_page_size(self, pageSize):
        # type: (int) -> DepartmentParentReqCall
        self.query_params['page_size'] = pageSize
        return self

    def do(self):
        # type: () -> Response[DepartmentParentResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/parent', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentUpdateDepartmentIdReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DepartmentService, DepartmentUpdateDepartmentIdReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_department_id(self, departmentId):
        # type: (str) -> DepartmentUpdateDepartmentIdReqCall
        self.path_params['department_id'] = departmentId
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> DepartmentUpdateDepartmentIdReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/:department_id/update_department_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentUnbindDepartmentChatReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DepartmentService, DepartmentUnbindDepartmentChatReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> DepartmentUnbindDepartmentChatReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/unbind_department_chat', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentSearchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DepartmentService, DepartmentSearchReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, userIdType):
        # type: (str) -> DepartmentSearchReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def set_department_id_type(self, departmentIdType):
        # type: (str) -> DepartmentSearchReqCall
        self.query_params['department_id_type'] = departmentIdType
        return self

    def set_page_token(self, pageToken):
        # type: (str) -> DepartmentSearchReqCall
        self.query_params['page_token'] = pageToken
        return self

    def set_page_size(self, pageSize):
        # type: (int) -> DepartmentSearchReqCall
        self.query_params['page_size'] = pageSize
        return self

    def do(self):
        # type: () -> Response[DepartmentSearchResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/search', 'POST', [ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=DepartmentSearchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

