import { CustomResource, Duration, aws_iam as iam, aws_lambda as lambda } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface BashExecFunctionProps {
    /**
     * The path of the shell script to be executed.
     */
    readonly script: string;
    /**
     * The path of your custom dockerfile.
     */
    readonly dockerfile?: string;
    /**
     * Lambda environment variables.
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * The function execution time (in seconds) after which Lambda terminates the function.
     * Because the execution time affects cost, set this value based on the function's expected execution time.
     * @default - Duration.seconds(60)
     * */
    readonly timeout?: Duration;
    /**
     * Custom lambda execution role.
     *
     * @default - auto generated role.
     */
    readonly role?: iam.IRole;
}
export interface RunOps {
    /**
     * whether to run the lambda function again on the provider update
     *
     * @default false;
     */
    readonly runOnUpdate?: boolean;
}
export declare class BashExecFunction extends Construct {
    readonly handler: lambda.DockerImageFunction;
    constructor(scope: Construct, id: string, props: BashExecFunctionProps);
    run(ops?: RunOps): CustomResource;
}
