<!--
BSD 3-Clause License

Copyright (c) 2023-2025, Science and Technology Facilities Council.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the copyright holder nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

Authors: R. W. Ford and A. R. Porter, STFC Daresbury Lab
-->

This directory contains the original tangent linear kernels that
`psyad` aims to translate into their adjoint form. These kernels are
copied from the LFRic repository with no changes and are stored here
purely for convenience. The kernels in this directory were specified
by the Met Office as the ones that they require.

Some of the kernels in this directory require manual modification
before `psyad` is able to process them. These kernels have been copied
into the `../tangent_linear_tweaked` directory and modified by
hand. The changes made to the tweaked versions can be easily seen
using `diff`. For example, `diff tl_moist_dyn_gas_kernel_mod.F90
../tangent_linear_tweaked/tl_moist_dyn_gas_kernel_mod_tweaked.F90`.

The `Makefile` in this directory only attempts to generate adjoint
versions of the tangent-linear kernels if they are known to
work. Therefore to create all of the adjoint kernels, both the
`Makefile` in this directory and the `Makefile` in the
`tangent_linear_tweaked` directory must be run. The `Makefile` in the
parent directory does this.

The generated `psyad` adjoint code may require manual tweaks before it
is correct. If this is the case then the `Makefile` in this directory
will output the generated adjoint kernel into the `adjoint_partial`
directory rather than the `adjoint` directory. At the present time all
adjoint code generated by `psyad` requires some manual tweaks.
