# PSyclone PSyAD Example 2: creating an LFRic adjoint kernel and test harness.

**Authors:** A. R. Porter and R. W. Ford, STFC Daresbury Lab

In order to use PSyclone you must first install it, ideally with pip.
See `../../../README.md` for more details.

This example demonstrates the use of PSyAD to create the adjoint of an
LFRic tangent-linear kernel (contained in
`tl_hydrostatic_kernel_mod.f90`) as well as a test harness for this
adjoint.

PSyAD can be run in the directory containing this file by executing:

```sh
make
```

This will construct the adjoint of the kernel (written to
`adj_hydrostatic_kernel_mod.x90`) and a test harness in the form of LFRic
Algorithm-layer code (`adjt_hydrostatic_alg_mod.x90`). The Makefile then proceeds to
use PSyclone to process the test harness Algorithm code to generate algorithm
(`adjt_hydrostatic_alg_mod.F90`) and PSy layer (`psy.f90`) code.

There is no `compile` target for this example because the generated code
requires the full LFRic infrastructure. However, it is straightforward
to modify the LFRic "skeleton" mini-app to call the generated algorithm
code (see below).

Alternatively, PSyAD may be run from the command line as:

```sh
psyad tl_hydrostatic_kernel_mod.F90 -a r_u exner theta moist_dyn_gas moist_dyn_tot moist_dyn_fac grad_term theta_v_e theta_v_at_quad exner_e exner_at_quad
```

In this case, the adjoint of the tangent-linear kernel is written to
`stdout`.

## Using the generated test harness in the LFRic core skeleton application

These instructions assume that you have a local, compiled version of LFRic core
in `<lfric-root>` and that the directory containing this file is `<work-dir>`.

1. Create the adjoint kernel and test harness code:
```sh
cd <work-dir>
make
```

2. Change to the LFRic skeleton miniapp directory and copy over the
   test-harness code and the TL and adjoint kernels:
```sh
cd <lfric-root>/miniapps/skeleton
cp <work-dir>/adjt_hydrostatic_alg_mod.x90 source/algorithm/.
cp <work-dir>/tl_hydrostatic_kernel_mod.F90 source/kernel/.
cp <work-dir>/adj_hydrostatic_kernel_mod.F90 source/kernel/.
```

3. Modify the miniapp driver routine to import and call the test-harness
   algorithm (WARNING, this `sed` command should be treated as an
   example - if the skeleton mini-app is modified on LFRic trunk then it will
   need to be updated):
```sh
sed -e 's/  subroutine run()/  subroutine run()\n    use adjt_hydrostatic_alg_mod, only: adjt_hydrostatic_alg/' -e 's/call skeleton_alg(field_1)/call adjt_hydrostatic_alg(mesh, chi, panel_id)/' source/driver/skeleton_driver_mod.f90 > new_driver.f90
mv source/driver/skeleton_driver_mod.f90{,.bak}
mv new_driver.f90 source/driver/skeleton_driver_mod.f90
```

4. Build the modified application:
```sh
make clean
make
``

Note that at this stage you may get errors relating to the LFRic unit-test
framework. These can be ignored.

5. Run the application:
```sh
cd example
../bin/skeleton ./configuration.nml
...
20220909120222.220+0100:INFO : Skeleton: created FEM constants
20220909120222.220+0100:INFO : skeleton: Miniapp initialised
 Test of adjoint of 'tl_hydrostatic_kernel_type' PASSED:    3074233422750.6738        3074233422750.7188        92.000000000000000     
20220909120222.451+0100:S1:INFO : skeleton: Writing diagnostic output
20220909120222.524+0100:S1:INFO : Finalising skeleton ...
...
```

## Testing Other LFRic Kernels

The Makefile is written such that it may be used for other
tangent-linear kernels that follow LFRic naming conventions. For
instance, some of those that are of immediate interest in the LFRic
adjoint project may be tested as follows (assuming that the specified
kernel has been put in the current working directory):

```sh
ACTIVE_VAR_LIST="rhs_eos exner rho theta moist_dyn_gas rhs_eos rho_e rho_cell exner_cell exner_e theta_vd_e theta_vd_cell" TL_KERNEL_NAME=tl_rhs_sample_eos_kernel make
```

```sh
ACTIVE_VAR_LIST="xi u res_dot_product curl_u" TL_KERNEL_NAME=strong_curl_kernel make
```

```sh
ACTIVE_VAR_LIST="lhs x lhs_e x_e" TL_KERNEL_NAME=matrix_vector_kernel make
```

```sh
ACTIVE_VAR_LIST="lhs x lhs_e x_e" TL_KERNEL_NAME=dg_matrix_vector_kernel make
```

Those kernels that are passed arguments containing geometric information
require special handling to ensure that the values of those arguments are not
overwritten by pseudo-random data in the test harness:

```sh
ACTIVE_VAR_LIST="r_u vorticity wind res_dot_product vorticity_term cross_product1 cross_product2 j_vorticity u_at_quad mul2 vorticity_at_quad" GEOMETRY_VAR_LIST="-coord-arg 6 -panel-id-arg 7" TL_KERNEL_NAME=tl_vorticity_advection_kernel make
```

## Licence

-----------------------------------------------------------------------------

BSD 3-Clause License

Copyright (c) 2021-2025, Science and Technology Facilities Council.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the copyright holder nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

------------------------------------------------------------------------------
