# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeGetRIMEInfoResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cluster_info_version': 'str',
        'customer_name': 'str',
        'expiration_time': 'datetime',
        'grace_period_end_time': 'datetime',
        'ri_plan': 'RimeRIPlan',
        'build_version': 'str'
    }

    attribute_map = {
        'cluster_info_version': 'clusterInfoVersion',
        'customer_name': 'customerName',
        'expiration_time': 'expirationTime',
        'grace_period_end_time': 'gracePeriodEndTime',
        'ri_plan': 'riPlan',
        'build_version': 'buildVersion'
    }

    def __init__(self, cluster_info_version=None, customer_name=None, expiration_time=None, grace_period_end_time=None, ri_plan=None, build_version=None):  # noqa: E501
        """RimeGetRIMEInfoResponse - a model defined in Swagger"""  # noqa: E501
        self._cluster_info_version = None
        self._customer_name = None
        self._expiration_time = None
        self._grace_period_end_time = None
        self._ri_plan = None
        self._build_version = None
        self.discriminator = None
        if cluster_info_version is not None:
            self.cluster_info_version = cluster_info_version
        if customer_name is not None:
            self.customer_name = customer_name
        if expiration_time is not None:
            self.expiration_time = expiration_time
        if grace_period_end_time is not None:
            self.grace_period_end_time = grace_period_end_time
        if ri_plan is not None:
            self.ri_plan = ri_plan
        if build_version is not None:
            self.build_version = build_version

    @property
    def cluster_info_version(self):
        """Gets the cluster_info_version of this RimeGetRIMEInfoResponse.  # noqa: E501

        Version of the RIME cluster control plane.  # noqa: E501

        :return: The cluster_info_version of this RimeGetRIMEInfoResponse.  # noqa: E501
        :rtype: str
        """
        return self._cluster_info_version

    @cluster_info_version.setter
    def cluster_info_version(self, cluster_info_version):
        """Sets the cluster_info_version of this RimeGetRIMEInfoResponse.

        Version of the RIME cluster control plane.  # noqa: E501

        :param cluster_info_version: The cluster_info_version of this RimeGetRIMEInfoResponse.  # noqa: E501
        :type: str
        """

        self._cluster_info_version = cluster_info_version

    @property
    def customer_name(self):
        """Gets the customer_name of this RimeGetRIMEInfoResponse.  # noqa: E501

        Name of the customer who owns the license.  # noqa: E501

        :return: The customer_name of this RimeGetRIMEInfoResponse.  # noqa: E501
        :rtype: str
        """
        return self._customer_name

    @customer_name.setter
    def customer_name(self, customer_name):
        """Sets the customer_name of this RimeGetRIMEInfoResponse.

        Name of the customer who owns the license.  # noqa: E501

        :param customer_name: The customer_name of this RimeGetRIMEInfoResponse.  # noqa: E501
        :type: str
        """

        self._customer_name = customer_name

    @property
    def expiration_time(self):
        """Gets the expiration_time of this RimeGetRIMEInfoResponse.  # noqa: E501

        Expiration time of the license.  # noqa: E501

        :return: The expiration_time of this RimeGetRIMEInfoResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._expiration_time

    @expiration_time.setter
    def expiration_time(self, expiration_time):
        """Sets the expiration_time of this RimeGetRIMEInfoResponse.

        Expiration time of the license.  # noqa: E501

        :param expiration_time: The expiration_time of this RimeGetRIMEInfoResponse.  # noqa: E501
        :type: datetime
        """

        self._expiration_time = expiration_time

    @property
    def grace_period_end_time(self):
        """Gets the grace_period_end_time of this RimeGetRIMEInfoResponse.  # noqa: E501

        After a license is expired, there is a grace period to allow a user to continue to use and update the license.  # noqa: E501

        :return: The grace_period_end_time of this RimeGetRIMEInfoResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._grace_period_end_time

    @grace_period_end_time.setter
    def grace_period_end_time(self, grace_period_end_time):
        """Sets the grace_period_end_time of this RimeGetRIMEInfoResponse.

        After a license is expired, there is a grace period to allow a user to continue to use and update the license.  # noqa: E501

        :param grace_period_end_time: The grace_period_end_time of this RimeGetRIMEInfoResponse.  # noqa: E501
        :type: datetime
        """

        self._grace_period_end_time = grace_period_end_time

    @property
    def ri_plan(self):
        """Gets the ri_plan of this RimeGetRIMEInfoResponse.  # noqa: E501


        :return: The ri_plan of this RimeGetRIMEInfoResponse.  # noqa: E501
        :rtype: RimeRIPlan
        """
        return self._ri_plan

    @ri_plan.setter
    def ri_plan(self, ri_plan):
        """Sets the ri_plan of this RimeGetRIMEInfoResponse.


        :param ri_plan: The ri_plan of this RimeGetRIMEInfoResponse.  # noqa: E501
        :type: RimeRIPlan
        """

        self._ri_plan = ri_plan

    @property
    def build_version(self):
        """Gets the build_version of this RimeGetRIMEInfoResponse.  # noqa: E501

        Annotated version of the RIME cluster control plane, including the timestamp corresponding to the build.  # noqa: E501

        :return: The build_version of this RimeGetRIMEInfoResponse.  # noqa: E501
        :rtype: str
        """
        return self._build_version

    @build_version.setter
    def build_version(self, build_version):
        """Sets the build_version of this RimeGetRIMEInfoResponse.

        Annotated version of the RIME cluster control plane, including the timestamp corresponding to the build.  # noqa: E501

        :param build_version: The build_version of this RimeGetRIMEInfoResponse.  # noqa: E501
        :type: str
        """

        self._build_version = build_version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeGetRIMEInfoResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeGetRIMEInfoResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
