# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class RegistryServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def registry_service_delete_dataset(self, dataset_id, **kwargs):  # noqa: E501
        """Delete a dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_delete_dataset(dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeDeleteDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_delete_dataset_with_http_info(dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_delete_dataset_with_http_info(dataset_id, **kwargs)  # noqa: E501
            return data

    def registry_service_delete_dataset_with_http_info(self, dataset_id, **kwargs):  # noqa: E501
        """Delete a dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_delete_dataset_with_http_info(dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeDeleteDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_delete_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `registry_service_delete_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/dataset/{datasetId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteDatasetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_delete_model(self, model_id_uuid, **kwargs):  # noqa: E501
        """Delete a model.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_delete_model(model_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: String value of the object ID. (required)
        :return: RimeDeleteModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_delete_model_with_http_info(model_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_delete_model_with_http_info(model_id_uuid, **kwargs)  # noqa: E501
            return data

    def registry_service_delete_model_with_http_info(self, model_id_uuid, **kwargs):  # noqa: E501
        """Delete a model.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_delete_model_with_http_info(model_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: String value of the object ID. (required)
        :return: RimeDeleteModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_delete_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id_uuid' is set
        if ('model_id_uuid' not in params or
                params['model_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_id_uuid` when calling `registry_service_delete_model`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id_uuid' in params:
            path_params['modelId.uuid'] = params['model_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/model/{modelId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_delete_prediction_set(self, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """Delete a prediction set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_delete_prediction_set(model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: String value of the object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeDeletePredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_delete_prediction_set_with_http_info(model_id_uuid, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_delete_prediction_set_with_http_info(model_id_uuid, dataset_id, **kwargs)  # noqa: E501
            return data

    def registry_service_delete_prediction_set_with_http_info(self, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """Delete a prediction set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_delete_prediction_set_with_http_info(model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: String value of the object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeDeletePredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id_uuid', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_delete_prediction_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id_uuid' is set
        if ('model_id_uuid' not in params or
                params['model_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_id_uuid` when calling `registry_service_delete_prediction_set`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `registry_service_delete_prediction_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id_uuid' in params:
            path_params['modelId.uuid'] = params['model_id_uuid']  # noqa: E501
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/prediction/{modelId.uuid}/{datasetId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeletePredictionSetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_get_dataset(self, **kwargs):  # noqa: E501
        """Get dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_get_dataset(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_id: Uniquely specifies a Dataset.
        :param str dataset_name:
        :return: RimeGetDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_get_dataset_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_get_dataset_with_http_info(**kwargs)  # noqa: E501
            return data

    def registry_service_get_dataset_with_http_info(self, **kwargs):  # noqa: E501
        """Get dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_get_dataset_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_id: Uniquely specifies a Dataset.
        :param str dataset_name:
        :return: RimeGetDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'dataset_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_get_dataset" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dataset_id' in params:
            query_params.append(('datasetId', params['dataset_id']))  # noqa: E501
        if 'dataset_name' in params:
            query_params.append(('datasetName', params['dataset_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/dataset', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetDatasetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_get_model(self, **kwargs):  # noqa: E501
        """Get model.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_get_model(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: String value of the object ID.
        :param str model_name:
        :return: RimeGetModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_get_model_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_get_model_with_http_info(**kwargs)  # noqa: E501
            return data

    def registry_service_get_model_with_http_info(self, **kwargs):  # noqa: E501
        """Get model.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_get_model_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: String value of the object ID.
        :param str model_name:
        :return: RimeGetModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id_uuid', 'model_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_get_model" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'model_id_uuid' in params:
            query_params.append(('modelId.uuid', params['model_id_uuid']))  # noqa: E501
        if 'model_name' in params:
            query_params.append(('modelName', params['model_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/model', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_get_prediction_set(self, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """Get prediction set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_get_prediction_set(model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: String value of the object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeGetPredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_get_prediction_set_with_http_info(model_id_uuid, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_get_prediction_set_with_http_info(model_id_uuid, dataset_id, **kwargs)  # noqa: E501
            return data

    def registry_service_get_prediction_set_with_http_info(self, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """Get prediction set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_get_prediction_set_with_http_info(model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: String value of the object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeGetPredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id_uuid', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_get_prediction_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id_uuid' is set
        if ('model_id_uuid' not in params or
                params['model_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_id_uuid` when calling `registry_service_get_prediction_set`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `registry_service_get_prediction_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id_uuid' in params:
            path_params['modelId.uuid'] = params['model_id_uuid']  # noqa: E501
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/prediction/{modelId.uuid}/{datasetId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetPredictionSetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_list_datasets(self, project_id_uuid, **kwargs):  # noqa: E501
        """List all datasets with a field mask.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_list_datasets(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: String value of the object ID. (required)
        :param str first_page_req_firewall_id: Uniquely specifies a Firewall.
        :param datetime first_page_req_scheduled_ct_intervals_start_time:
        :param datetime first_page_req_scheduled_ct_intervals_end_time:
        :param str page_token: Specifies a page of the list returned by a ListDatasets query. The ListDatasets query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Dataset objects to return in a single page.
        :return: RimeListDatasetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_list_datasets_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_list_datasets_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
            return data

    def registry_service_list_datasets_with_http_info(self, project_id_uuid, **kwargs):  # noqa: E501
        """List all datasets with a field mask.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_list_datasets_with_http_info(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: String value of the object ID. (required)
        :param str first_page_req_firewall_id: Uniquely specifies a Firewall.
        :param datetime first_page_req_scheduled_ct_intervals_start_time:
        :param datetime first_page_req_scheduled_ct_intervals_end_time:
        :param str page_token: Specifies a page of the list returned by a ListDatasets query. The ListDatasets query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Dataset objects to return in a single page.
        :return: RimeListDatasetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id_uuid', 'first_page_req_firewall_id', 'first_page_req_scheduled_ct_intervals_start_time', 'first_page_req_scheduled_ct_intervals_end_time', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_list_datasets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `registry_service_list_datasets`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []
        if 'first_page_req_firewall_id' in params:
            query_params.append(('firstPageReq.firewallId', params['first_page_req_firewall_id']))  # noqa: E501
        if 'first_page_req_scheduled_ct_intervals_start_time' in params:
            query_params.append(('firstPageReq.scheduledCtIntervals.startTime', params['first_page_req_scheduled_ct_intervals_start_time']))  # noqa: E501
        if 'first_page_req_scheduled_ct_intervals_end_time' in params:
            query_params.append(('firstPageReq.scheduledCtIntervals.endTime', params['first_page_req_scheduled_ct_intervals_end_time']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/{projectId.uuid}/dataset', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListDatasetsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_list_models(self, project_id_uuid, **kwargs):  # noqa: E501
        """List all models with a field mask.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_list_models(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: String value of the object ID. (required)
        :param str page_token: Specifies a page of the list returned by a ListModels query. The ListModels query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Model objects to return in a single page.
        :return: RimeListModelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_list_models_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_list_models_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
            return data

    def registry_service_list_models_with_http_info(self, project_id_uuid, **kwargs):  # noqa: E501
        """List all models with a field mask.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_list_models_with_http_info(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: String value of the object ID. (required)
        :param str page_token: Specifies a page of the list returned by a ListModels query. The ListModels query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Model objects to return in a single page.
        :return: RimeListModelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id_uuid', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_list_models" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `registry_service_list_models`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/{projectId.uuid}/model', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListModelsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_list_prediction_set(self, project_id_uuid, **kwargs):  # noqa: E501
        """List all prediction sets with a field mask.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_list_prediction_set(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: String value of the object ID. (required)
        :param str first_page_req_model_id: Uniquely specifies a Model.
        :param str first_page_req_dataset_id: Uniquely specifies a Dataset.
        :param str page_token: Specifies a page of the list returned by a ListPredictions query. The ListPredictions query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Prediction objects to return in a single page.
        :return: RimeListPredictionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_list_prediction_set_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_list_prediction_set_with_http_info(project_id_uuid, **kwargs)  # noqa: E501
            return data

    def registry_service_list_prediction_set_with_http_info(self, project_id_uuid, **kwargs):  # noqa: E501
        """List all prediction sets with a field mask.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_list_prediction_set_with_http_info(project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id_uuid: String value of the object ID. (required)
        :param str first_page_req_model_id: Uniquely specifies a Model.
        :param str first_page_req_dataset_id: Uniquely specifies a Dataset.
        :param str page_token: Specifies a page of the list returned by a ListPredictions query. The ListPredictions query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Prediction objects to return in a single page.
        :return: RimeListPredictionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id_uuid', 'first_page_req_model_id', 'first_page_req_dataset_id', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_list_prediction_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `registry_service_list_prediction_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []
        if 'first_page_req_model_id' in params:
            query_params.append(('firstPageReq.modelId', params['first_page_req_model_id']))  # noqa: E501
        if 'first_page_req_dataset_id' in params:
            query_params.append(('firstPageReq.datasetId', params['first_page_req_dataset_id']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/{projectId.uuid}/prediction', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListPredictionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_register_dataset(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """Register a new dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_register_dataset(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatasetProjectIdUuidBody body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :return: RimeRegisterDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_register_dataset_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_register_dataset_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
            return data

    def registry_service_register_dataset_with_http_info(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """Register a new dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_register_dataset_with_http_info(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatasetProjectIdUuidBody body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :return: RimeRegisterDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_register_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `registry_service_register_dataset`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `registry_service_register_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/dataset/{projectId.uuid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRegisterDatasetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_register_dataset2(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """Register a new dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_register_dataset2(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectIdUuidDatasetBody body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :return: RimeRegisterDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_register_dataset2_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_register_dataset2_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
            return data

    def registry_service_register_dataset2_with_http_info(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """Register a new dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_register_dataset2_with_http_info(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectIdUuidDatasetBody body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :return: RimeRegisterDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_register_dataset2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `registry_service_register_dataset2`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `registry_service_register_dataset2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/{projectId.uuid}/dataset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRegisterDatasetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_register_model(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """Register a new model.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_register_model(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelProjectIdUuidBody body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :return: RimeRegisterModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_register_model_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_register_model_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
            return data

    def registry_service_register_model_with_http_info(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """Register a new model.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_register_model_with_http_info(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelProjectIdUuidBody body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :return: RimeRegisterModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_register_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `registry_service_register_model`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `registry_service_register_model`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/model/{projectId.uuid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRegisterModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_register_model2(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """Register a new model.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_register_model2(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectIdUuidModelBody body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :return: RimeRegisterModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_register_model2_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_register_model2_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
            return data

    def registry_service_register_model2_with_http_info(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """Register a new model.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_register_model2_with_http_info(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectIdUuidModelBody body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :return: RimeRegisterModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_register_model2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `registry_service_register_model2`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `registry_service_register_model2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/{projectId.uuid}/model', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRegisterModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_register_prediction_set(self, body, project_id_uuid, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """Register a new prediction set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_register_prediction_set(body, project_id_uuid, model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelIdUuidDatasetIdBody body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :param str model_id_uuid: String value of the object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeRegisterPredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_register_prediction_set_with_http_info(body, project_id_uuid, model_id_uuid, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_register_prediction_set_with_http_info(body, project_id_uuid, model_id_uuid, dataset_id, **kwargs)  # noqa: E501
            return data

    def registry_service_register_prediction_set_with_http_info(self, body, project_id_uuid, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """Register a new prediction set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_register_prediction_set_with_http_info(body, project_id_uuid, model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelIdUuidDatasetIdBody body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :param str model_id_uuid: String value of the object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeRegisterPredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid', 'model_id_uuid', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_register_prediction_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `registry_service_register_prediction_set`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `registry_service_register_prediction_set`")  # noqa: E501
        # verify the required parameter 'model_id_uuid' is set
        if ('model_id_uuid' not in params or
                params['model_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_id_uuid` when calling `registry_service_register_prediction_set`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `registry_service_register_prediction_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501
        if 'model_id_uuid' in params:
            path_params['modelId.uuid'] = params['model_id_uuid']  # noqa: E501
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/prediction/{projectId.uuid}/{modelId.uuid}/{datasetId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRegisterPredictionSetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def registry_service_register_prediction_set2(self, body, project_id_uuid, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """Register a new prediction set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_register_prediction_set2(body, project_id_uuid, model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelIdUuidDatasetIdBody1 body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :param str model_id_uuid: String value of the object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeRegisterPredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.registry_service_register_prediction_set2_with_http_info(body, project_id_uuid, model_id_uuid, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.registry_service_register_prediction_set2_with_http_info(body, project_id_uuid, model_id_uuid, dataset_id, **kwargs)  # noqa: E501
            return data

    def registry_service_register_prediction_set2_with_http_info(self, body, project_id_uuid, model_id_uuid, dataset_id, **kwargs):  # noqa: E501
        """Register a new prediction set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.registry_service_register_prediction_set2_with_http_info(body, project_id_uuid, model_id_uuid, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelIdUuidDatasetIdBody1 body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :param str model_id_uuid: String value of the object ID. (required)
        :param str dataset_id: Uniquely specifies a Dataset. (required)
        :return: RimeRegisterPredictionSetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid', 'model_id_uuid', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method registry_service_register_prediction_set2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `registry_service_register_prediction_set2`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `registry_service_register_prediction_set2`")  # noqa: E501
        # verify the required parameter 'model_id_uuid' is set
        if ('model_id_uuid' not in params or
                params['model_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_id_uuid` when calling `registry_service_register_prediction_set2`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `registry_service_register_prediction_set2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501
        if 'model_id_uuid' in params:
            path_params['modelId.uuid'] = params['model_id_uuid']  # noqa: E501
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/registry/{projectId.uuid}/prediction/{modelId.uuid}/{datasetId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRegisterPredictionSetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
