# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class MonitorServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def monitor_service_create_custom_monitor(self, body, name, **kwargs):  # noqa: E501
        """CreateCustomMonitor  # noqa: E501

        Create a new custom monitor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.monitor_service_create_custom_monitor(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustommonitorsNameBody body: (required)
        :param str name: The name of the monitor. (required)
        :return: RimeCreateCustomMonitorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.monitor_service_create_custom_monitor_with_http_info(body, name, **kwargs)  # noqa: E501
        else:
            (data) = self.monitor_service_create_custom_monitor_with_http_info(body, name, **kwargs)  # noqa: E501
            return data

    def monitor_service_create_custom_monitor_with_http_info(self, body, name, **kwargs):  # noqa: E501
        """CreateCustomMonitor  # noqa: E501

        Create a new custom monitor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.monitor_service_create_custom_monitor_with_http_info(body, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustommonitorsNameBody body: (required)
        :param str name: The name of the monitor. (required)
        :return: RimeCreateCustomMonitorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method monitor_service_create_custom_monitor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `monitor_service_create_custom_monitor`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `monitor_service_create_custom_monitor`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/custom-monitors/{name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateCustomMonitorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def monitor_service_delete_custom_monitor(self, monitor_id_uuid, **kwargs):  # noqa: E501
        """DeleteCustomMonitor  # noqa: E501

        Delete a custom monitor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.monitor_service_delete_custom_monitor(monitor_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str monitor_id_uuid: String value of the object ID. (required)
        :return: RimeDeleteCustomMonitorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.monitor_service_delete_custom_monitor_with_http_info(monitor_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.monitor_service_delete_custom_monitor_with_http_info(monitor_id_uuid, **kwargs)  # noqa: E501
            return data

    def monitor_service_delete_custom_monitor_with_http_info(self, monitor_id_uuid, **kwargs):  # noqa: E501
        """DeleteCustomMonitor  # noqa: E501

        Delete a custom monitor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.monitor_service_delete_custom_monitor_with_http_info(monitor_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str monitor_id_uuid: String value of the object ID. (required)
        :return: RimeDeleteCustomMonitorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['monitor_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method monitor_service_delete_custom_monitor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'monitor_id_uuid' is set
        if ('monitor_id_uuid' not in params or
                params['monitor_id_uuid'] is None):
            raise ValueError("Missing the required parameter `monitor_id_uuid` when calling `monitor_service_delete_custom_monitor`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'monitor_id_uuid' in params:
            path_params['monitorId.uuid'] = params['monitor_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/custom-monitors/{monitorId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteCustomMonitorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def monitor_service_get_monitor_result(self, monitor_id_uuid, **kwargs):  # noqa: E501
        """GetMonitorResult  # noqa: E501

        Graph a monitor within a time range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.monitor_service_get_monitor_result(monitor_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str monitor_id_uuid: String value of the object ID. (required)
        :param datetime time_interval_start_time:
        :param datetime time_interval_end_time:
        :return: RimeGetMonitorResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.monitor_service_get_monitor_result_with_http_info(monitor_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.monitor_service_get_monitor_result_with_http_info(monitor_id_uuid, **kwargs)  # noqa: E501
            return data

    def monitor_service_get_monitor_result_with_http_info(self, monitor_id_uuid, **kwargs):  # noqa: E501
        """GetMonitorResult  # noqa: E501

        Graph a monitor within a time range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.monitor_service_get_monitor_result_with_http_info(monitor_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str monitor_id_uuid: String value of the object ID. (required)
        :param datetime time_interval_start_time:
        :param datetime time_interval_end_time:
        :return: RimeGetMonitorResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['monitor_id_uuid', 'time_interval_start_time', 'time_interval_end_time']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method monitor_service_get_monitor_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'monitor_id_uuid' is set
        if ('monitor_id_uuid' not in params or
                params['monitor_id_uuid'] is None):
            raise ValueError("Missing the required parameter `monitor_id_uuid` when calling `monitor_service_get_monitor_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'monitor_id_uuid' in params:
            path_params['monitorId.uuid'] = params['monitor_id_uuid']  # noqa: E501

        query_params = []
        if 'time_interval_start_time' in params:
            query_params.append(('timeInterval.startTime', params['time_interval_start_time']))  # noqa: E501
        if 'time_interval_end_time' in params:
            query_params.append(('timeInterval.endTime', params['time_interval_end_time']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/monitors/result/{monitorId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetMonitorResultResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def monitor_service_list_metric_identifiers(self, firewall_id_uuid, **kwargs):  # noqa: E501
        """ListMetricIdentifiers  # noqa: E501

        List all possible Custom Monitor Metric Identifiers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.monitor_service_list_metric_identifiers(firewall_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id_uuid: String value of the object ID. (required)
        :return: RimeListMetricIdentifiersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.monitor_service_list_metric_identifiers_with_http_info(firewall_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.monitor_service_list_metric_identifiers_with_http_info(firewall_id_uuid, **kwargs)  # noqa: E501
            return data

    def monitor_service_list_metric_identifiers_with_http_info(self, firewall_id_uuid, **kwargs):  # noqa: E501
        """ListMetricIdentifiers  # noqa: E501

        List all possible Custom Monitor Metric Identifiers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.monitor_service_list_metric_identifiers_with_http_info(firewall_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id_uuid: String value of the object ID. (required)
        :return: RimeListMetricIdentifiersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method monitor_service_list_metric_identifiers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id_uuid' is set
        if ('firewall_id_uuid' not in params or
                params['firewall_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_id_uuid` when calling `monitor_service_list_metric_identifiers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id_uuid' in params:
            path_params['firewallId.uuid'] = params['firewall_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/custom-monitors/metrics/{firewallId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListMetricIdentifiersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def monitor_service_list_monitors(self, firewall_id_uuid, **kwargs):  # noqa: E501
        """ListMonitors  # noqa: E501

        lists monitors by firewall ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.monitor_service_list_monitors(firewall_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id_uuid: String value of the object ID. (required)
        :param list[str] first_page_req_included_monitor_types: Specifies a list of monitor types. Filters results to match the specified monitor types.
        :param list[str] first_page_req_included_risk_category_types: Specifies a list of risk category types. Filters results to match the specified risk category types.
        :param bool first_page_req_pinned_monitors_only: When the value of this Boolean is True, this endpoint returns a list of pinned Monitors. Otherwise, this endpoint does not filter Monitors by pinned status.
        :param str page_token: Specifies a page of the list returned by a ListMonitors query. The ListMonitors query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Monitor objects to return in a single page.
        :return: RimeListMonitorsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.monitor_service_list_monitors_with_http_info(firewall_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.monitor_service_list_monitors_with_http_info(firewall_id_uuid, **kwargs)  # noqa: E501
            return data

    def monitor_service_list_monitors_with_http_info(self, firewall_id_uuid, **kwargs):  # noqa: E501
        """ListMonitors  # noqa: E501

        lists monitors by firewall ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.monitor_service_list_monitors_with_http_info(firewall_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id_uuid: String value of the object ID. (required)
        :param list[str] first_page_req_included_monitor_types: Specifies a list of monitor types. Filters results to match the specified monitor types.
        :param list[str] first_page_req_included_risk_category_types: Specifies a list of risk category types. Filters results to match the specified risk category types.
        :param bool first_page_req_pinned_monitors_only: When the value of this Boolean is True, this endpoint returns a list of pinned Monitors. Otherwise, this endpoint does not filter Monitors by pinned status.
        :param str page_token: Specifies a page of the list returned by a ListMonitors query. The ListMonitors query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageReq field.
        :param str page_size: The maximum number of Monitor objects to return in a single page.
        :return: RimeListMonitorsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id_uuid', 'first_page_req_included_monitor_types', 'first_page_req_included_risk_category_types', 'first_page_req_pinned_monitors_only', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method monitor_service_list_monitors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id_uuid' is set
        if ('firewall_id_uuid' not in params or
                params['firewall_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_id_uuid` when calling `monitor_service_list_monitors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id_uuid' in params:
            path_params['firewallId.uuid'] = params['firewall_id_uuid']  # noqa: E501

        query_params = []
        if 'first_page_req_included_monitor_types' in params:
            query_params.append(('firstPageReq.includedMonitorTypes', params['first_page_req_included_monitor_types']))  # noqa: E501
            collection_formats['firstPageReq.includedMonitorTypes'] = 'multi'  # noqa: E501
        if 'first_page_req_included_risk_category_types' in params:
            query_params.append(('firstPageReq.includedRiskCategoryTypes', params['first_page_req_included_risk_category_types']))  # noqa: E501
            collection_formats['firstPageReq.includedRiskCategoryTypes'] = 'multi'  # noqa: E501
        if 'first_page_req_pinned_monitors_only' in params:
            query_params.append(('firstPageReq.pinnedMonitorsOnly', params['first_page_req_pinned_monitors_only']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/monitors/{firewallId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListMonitorsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def monitor_service_update_monitor(self, body, monitor_id_uuid, **kwargs):  # noqa: E501
        """UpdateMonitor  # noqa: E501

        Updates a monitor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.monitor_service_update_monitor(body, monitor_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MonitorsMonitorIdUuidBody body: (required)
        :param str monitor_id_uuid: String value of the object ID. (required)
        :return: RimeUpdateMonitorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.monitor_service_update_monitor_with_http_info(body, monitor_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.monitor_service_update_monitor_with_http_info(body, monitor_id_uuid, **kwargs)  # noqa: E501
            return data

    def monitor_service_update_monitor_with_http_info(self, body, monitor_id_uuid, **kwargs):  # noqa: E501
        """UpdateMonitor  # noqa: E501

        Updates a monitor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.monitor_service_update_monitor_with_http_info(body, monitor_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MonitorsMonitorIdUuidBody body: (required)
        :param str monitor_id_uuid: String value of the object ID. (required)
        :return: RimeUpdateMonitorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'monitor_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method monitor_service_update_monitor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `monitor_service_update_monitor`")  # noqa: E501
        # verify the required parameter 'monitor_id_uuid' is set
        if ('monitor_id_uuid' not in params or
                params['monitor_id_uuid'] is None):
            raise ValueError("Missing the required parameter `monitor_id_uuid` when calling `monitor_service_update_monitor`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'monitor_id_uuid' in params:
            path_params['monitor.id.uuid'] = params['monitor_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/monitors/{monitor.id.uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateMonitorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
