# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class FirewallServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def firewall_service_create_firewall(self, body, **kwargs):  # noqa: E501
        """CreateFirewall  # noqa: E501

        Creates a firewall with the required fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_create_firewall(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateFirewallRequest body: (required)
        :return: RimeCreateFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_create_firewall_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_create_firewall_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def firewall_service_create_firewall_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateFirewall  # noqa: E501

        Creates a firewall with the required fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_create_firewall_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateFirewallRequest body: (required)
        :return: RimeCreateFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_create_firewall" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `firewall_service_create_firewall`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateFirewallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_delete_firewall(self, firewall_id_uuid, **kwargs):  # noqa: E501
        """DeleteFirewall  # noqa: E501

        Deletes the firewall with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_delete_firewall(firewall_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id_uuid: String value of the object ID. (required)
        :return: RimeDeleteFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_delete_firewall_with_http_info(firewall_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_delete_firewall_with_http_info(firewall_id_uuid, **kwargs)  # noqa: E501
            return data

    def firewall_service_delete_firewall_with_http_info(self, firewall_id_uuid, **kwargs):  # noqa: E501
        """DeleteFirewall  # noqa: E501

        Deletes the firewall with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_delete_firewall_with_http_info(firewall_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id_uuid: String value of the object ID. (required)
        :return: RimeDeleteFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_delete_firewall" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id_uuid' is set
        if ('firewall_id_uuid' not in params or
                params['firewall_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_id_uuid` when calling `firewall_service_delete_firewall`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id_uuid' in params:
            path_params['firewallId.uuid'] = params['firewall_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewallId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteFirewallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_get_firewall(self, firewall_id_uuid, **kwargs):  # noqa: E501
        """GetFirewall  # noqa: E501

        Gets the firewall that matches the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_get_firewall(firewall_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id_uuid: String value of the object ID. (required)
        :return: RimeGetFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_get_firewall_with_http_info(firewall_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_get_firewall_with_http_info(firewall_id_uuid, **kwargs)  # noqa: E501
            return data

    def firewall_service_get_firewall_with_http_info(self, firewall_id_uuid, **kwargs):  # noqa: E501
        """GetFirewall  # noqa: E501

        Gets the firewall that matches the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_get_firewall_with_http_info(firewall_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id_uuid: String value of the object ID. (required)
        :return: RimeGetFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_get_firewall" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id_uuid' is set
        if ('firewall_id_uuid' not in params or
                params['firewall_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_id_uuid` when calling `firewall_service_get_firewall`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id_uuid' in params:
            path_params['firewallId.uuid'] = params['firewall_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewallId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetFirewallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_get_url(self, firewall_id_uuid, **kwargs):  # noqa: E501
        """GetURL  # noqa: E501

        This endpoint is intended to only be used by the SDK.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_get_url(firewall_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id_uuid: String value of the object ID. (required)
        :return: RimeGetURLResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_get_url_with_http_info(firewall_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_get_url_with_http_info(firewall_id_uuid, **kwargs)  # noqa: E501
            return data

    def firewall_service_get_url_with_http_info(self, firewall_id_uuid, **kwargs):  # noqa: E501
        """GetURL  # noqa: E501

        This endpoint is intended to only be used by the SDK.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_get_url_with_http_info(firewall_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str firewall_id_uuid: String value of the object ID. (required)
        :return: RimeGetURLResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['firewall_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_get_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'firewall_id_uuid' is set
        if ('firewall_id_uuid' not in params or
                params['firewall_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_id_uuid` when calling `firewall_service_get_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_id_uuid' in params:
            path_params['firewallId.uuid'] = params['firewall_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/firewall/{firewallId.uuid}/url', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetURLResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def firewall_service_update_firewall(self, body, firewall_firewall_id_uuid, **kwargs):  # noqa: E501
        """UpdateFirewall  # noqa: E501

        Updates a firewall's editable fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_update_firewall(body, firewall_firewall_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallFirewallFirewallIdUuidBody body: (required)
        :param str firewall_firewall_id_uuid: String value of the object ID. (required)
        :return: RimeUpdateFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.firewall_service_update_firewall_with_http_info(body, firewall_firewall_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.firewall_service_update_firewall_with_http_info(body, firewall_firewall_id_uuid, **kwargs)  # noqa: E501
            return data

    def firewall_service_update_firewall_with_http_info(self, body, firewall_firewall_id_uuid, **kwargs):  # noqa: E501
        """UpdateFirewall  # noqa: E501

        Updates a firewall's editable fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.firewall_service_update_firewall_with_http_info(body, firewall_firewall_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FirewallFirewallFirewallIdUuidBody body: (required)
        :param str firewall_firewall_id_uuid: String value of the object ID. (required)
        :return: RimeUpdateFirewallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'firewall_firewall_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method firewall_service_update_firewall" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `firewall_service_update_firewall`")  # noqa: E501
        # verify the required parameter 'firewall_firewall_id_uuid' is set
        if ('firewall_firewall_id_uuid' not in params or
                params['firewall_firewall_id_uuid'] is None):
            raise ValueError("Missing the required parameter `firewall_firewall_id_uuid` when calling `firewall_service_update_firewall`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'firewall_firewall_id_uuid' in params:
            path_params['firewall.firewallId.uuid'] = params['firewall_firewall_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/firewall/{firewall.firewallId.uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateFirewallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
