/**
 * Configure docker on the runners.
 *
 * @see https://docs.gitlab.com/runner/configuration/advanced-configuration.html#the-runnersdocker-section
 * @stability stable
 */
export interface DockerConfiguration {
    /**
     * Wildcard list of images that can be specified in the .gitlab-ci.yml file. If not present, all images are allowed (equivalent to ["*\/*:*"]). See Restrict Docker images and services.
     *
     * @stability stable
     */
    readonly allowedImages?: string[];
    /**
     * Wildcard list of services that can be specified in the .gitlab-ci.yml file. If not present, all images are allowed (equivalent to [*\/*:*]). See Restrict Docker images and services.
     *
     * @stability stable
     */
    readonly allowedServices?: string[];
    /**
     * Directory where Docker caches should be stored.
     *
     * This path can be absolute or relative to current working directory. See disable_cache for more information.
     *
     * @stability stable
     */
    readonly cacheDir?: string;
    /**
     * Add additional Linux capabilities to the container.
     *
     * @default ["CAP_SYS_ADMIN"]
     * @stability stable
     */
    readonly capAdd?: string[];
    /**
     * Drop additional Linux capabilities from the container.
     *
     * @stability stable
     */
    readonly capDrop?: string[];
    /**
     * The control group’s CpusetCpus.
     *
     * A string.
     *
     * @stability stable
     */
    readonly cpusetCpus?: string;
    /**
     * Number of CPU shares used to set relative CPU usage.
     *
     * Default is 1024.
     *
     * @stability stable
     */
    readonly cpuShares?: number;
    /**
     * Number of CPUs (available in Docker 1.13 or later. A string.
     *
     * @stability stable
     */
    readonly cpus?: string;
    /**
     * Share additional host devices with the container.
     *
     * @stability stable
     */
    readonly devices?: string[];
    /**
     * The Docker executor has two levels of caching: a global one (like any other executor) and a local cache based on Docker volumes.
     *
     * This configuration flag acts only on the local one which disables the use of automatically created (not mapped to a host directory) cache volumes. In other words, it only prevents creating a container that holds temporary files of builds, it does not disable the cache if the runner is configured in distributed cache mode.
     *
     * @default false
     * @stability stable
     */
    readonly disableCache?: boolean;
    /**
     * Disable the image entrypoint overwriting.
     *
     * @stability stable
     */
    readonly disableEntrypointOverwrite?: boolean;
    /**
     * A list of DNS servers for the container to use.
     *
     * @stability stable
     */
    readonly dns?: string[];
    /**
     * A list of DNS search domains.
     *
     * @stability stable
     */
    readonly dnsSearch?: string[];
    /**
     * Hosts that should be defined in container environment.
     *
     * @stability stable
     */
    readonly extraHosts?: string[];
    /**
     * GPU devices for Docker container.
     *
     * Uses the same format as the docker cli. View details in the Docker documentation.
     *
     * @stability stable
     */
    readonly gpus?: string[];
    /**
     * (Advanced) The default helper image used to clone repositories and upload artifacts.
     *
     * @stability stable
     */
    readonly helperImage?: string;
    /**
     * Sets the helper image flavor (alpine, alpine3.12, alpine3.13, alpine3.14 or ubuntu). Defaults to alpine. The alpine flavor uses the same version as alpine3.12.
     *
     * @stability stable
     */
    readonly helperImageFlavor?: string;
    /**
     * Custom Docker endpoint.
     *
     * Default is DOCKER_HOST environment or unix:///var/run/docker.sock.
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * Custom hostname for the Docker container.
     *
     * @stability stable
     */
    readonly hostname?: string;
    /**
     * The image to run jobs with.
     *
     * @stability stable
     */
    readonly image?: string;
    /**
     * Containers that should be linked with container that runs the job.
     *
     * @stability stable
     */
    readonly links?: string[];
    /**
     * The memory limit.
     *
     * A string.
     *
     * @stability stable
     */
    readonly memory?: string;
    /**
     * The total memory limit.
     *
     * A string.
     *
     * @stability stable
     */
    readonly memorySwap?: string;
    /**
     * The memory soft limit.
     *
     * A string.
     *
     * @stability stable
     */
    readonly memoryReservation?: string;
    /**
     * Add container to a custom network.
     *
     * @stability stable
     */
    readonly networkMode?: string;
    /**
     * If an out-of-memory (OOM) error occurs, do not kill processes in a container.
     *
     * @stability stable
     */
    readonly oomKillDisable?: boolean;
    /**
     * OOM score adjustment.
     *
     * Positive means kill earlier.
     *
     * @stability stable
     */
    readonly oomScoreAdjust?: string;
    /**
     * Make the container run in privileged mode.
     *
     * Insecure.
     *
     * @default true
     * @stability stable
     */
    readonly privileged?: boolean;
    /**
     * The image pull policy: never, if-not-present or always (default).
     *
     * View details in the pull policies documentation. You can also add multiple pull policies.
     *
     * @stability stable
     */
    readonly pullPolicy?: string;
    /**
     * The runtime for the Docker container.
     *
     * @stability stable
     */
    readonly runtime?: string;
    /**
     * Security options (–security-opt in docker run).
     *
     * Takes a list of : separated key/values.
     *
     * @stability stable
     */
    readonly securityOpt?: string;
    /**
     * Shared memory size for images (in bytes).
     *
     * @default 0
     * @stability stable
     */
    readonly shmSize?: number;
    /**
     * The sysctl options.
     *
     * @stability stable
     */
    readonly sysctls?: string;
    /**
     * A directory where ca.pem, cert.pem or key.pem are stored and used to make a secure TLS connection to Docker. Useful in boot2docker.
     *
     * @stability stable
     */
    readonly tlsCertPath?: string;
    /**
     * Enable or disable TLS verification of connections to Docker daemon.
     *
     * Disabled by default.
     *
     * @default false
     * @stability stable
     */
    readonly tlsVerify?: boolean;
    /**
     * The user namespace mode for the container and Docker services when user namespace remapping option is enabled.
     *
     * Available in Docker 1.10 or later.
     *
     * @stability stable
     */
    readonly usernsMode?: string;
    /**
     * Additional volumes that should be mounted.
     *
     * Same syntax as the Docker -v flag.
     *
     * @stability stable
     */
    readonly volumes?: string[];
    /**
     * A list of volumes to inherit from another container in the form <container name>[:<ro|rw>].
     *
     * Access level defaults to read-write, but can be manually set to ro (read-only) or rw (read-write).
     *
     * @stability stable
     */
    readonly volumesFrom?: string[];
    /**
     * The volume driver to use for the container.
     *
     * @stability stable
     */
    readonly volumeDriver?: string;
    /**
     * How long to wait for Docker services.
     *
     * Set to 0 to disable. Default is 30.
     *
     * @default 300
     * @stability stable
     */
    readonly waitForServicesTimeout?: number;
}
