# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ConfigMapEnvSourceResponse',
    'ConfigMapKeySelectorResponse',
    'ConfigMapVolumeSourceResponse',
    'ContainerPortResponse',
    'ContainerResponse',
    'EnvFromSourceResponse',
    'EnvVarResponse',
    'EnvVarSourceResponse',
    'ExecActionResponse',
    'GoogleRpcStatusResponse',
    'HTTPGetActionResponse',
    'HTTPHeaderResponse',
    'InstanceAttemptResultResponse',
    'InstanceSpecResponse',
    'InstanceStatusResponse',
    'InstanceTemplateSpecResponse',
    'JobConditionResponse',
    'JobSpecResponse',
    'JobStatusResponse',
    'KeyToPathResponse',
    'LocalObjectReferenceResponse',
    'ObjectMetaResponse',
    'OwnerReferenceResponse',
    'ProbeResponse',
    'ResourceRequirementsResponse',
    'SecretEnvSourceResponse',
    'SecretKeySelectorResponse',
    'SecretVolumeSourceResponse',
    'SecurityContextResponse',
    'TCPSocketActionResponse',
    'VolumeMountResponse',
    'VolumeResponse',
]

@pulumi.output_type
class ConfigMapEnvSourceResponse(dict):
    """
    Not supported by Cloud Run ConfigMapEnvSource selects a ConfigMap to populate the environment variables with. The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMapEnvSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMapEnvSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMapEnvSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        Not supported by Cloud Run ConfigMapEnvSource selects a ConfigMap to populate the environment variables with. The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
        :param 'LocalObjectReferenceResponse' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: The ConfigMap to select from.
        :param bool optional: (Optional) Specify whether the ConfigMap must be defined
        """
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The ConfigMap to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        (Optional) Specify whether the ConfigMap must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ConfigMapKeySelectorResponse(dict):
    """
    Not supported by Cloud Run Selects a key from a ConfigMap.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMapKeySelectorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMapKeySelectorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMapKeySelectorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        Not supported by Cloud Run Selects a key from a ConfigMap.
        :param str key: The key to select.
        :param 'LocalObjectReferenceResponse' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: The ConfigMap to select from.
        :param bool optional: (Optional) Specify whether the ConfigMap or its key must be defined
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key to select.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The ConfigMap to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        (Optional) Specify whether the ConfigMap or its key must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ConfigMapVolumeSourceResponse(dict):
    """
    Not supported by Cloud Run Adapts a ConfigMap into a volume. The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMapVolumeSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMapVolumeSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMapVolumeSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_mode: int,
                 items: Sequence['outputs.KeyToPathResponse'],
                 name: str,
                 optional: bool):
        """
        Not supported by Cloud Run Adapts a ConfigMap into a volume. The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths.
        :param int default_mode: (Optional) Integer representation of mode bits to use on created files by default. Must be a value between 01 and 0777 (octal). If 0 or not set, it will default to 0644. Directories within the path are not affected by this setting. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['KeyToPathResponse'] items: (Optional) If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified that is not present in the Secret, the volume setup will error unless it is marked optional.
        :param str name: Name of the config.
        :param bool optional: (Optional) Specify whether the Secret or its keys must be defined.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> int:
        """
        (Optional) Integer representation of mode bits to use on created files by default. Must be a value between 01 and 0777 (octal). If 0 or not set, it will default to 0644. Directories within the path are not affected by this setting. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.KeyToPathResponse']:
        """
        (Optional) If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified that is not present in the Secret, the volume setup will error unless it is marked optional.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        (Optional) Specify whether the Secret or its keys must be defined.
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ContainerPortResponse(dict):
    """
    ContainerPort represents a network port in a single container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerPortResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerPortResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerPortResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: int,
                 name: str,
                 protocol: str):
        """
        ContainerPort represents a network port in a single container.
        :param int container_port: (Optional) Port number the container listens on. This must be a valid port number, 0 < x < 65536.
        :param str name: (Optional) If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        :param str protocol: (Optional) Protocol for port. Must be "TCP". Defaults to "TCP".
        """
        pulumi.set(__self__, "container_port", container_port)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> int:
        """
        (Optional) Port number the container listens on. This must be a valid port number, 0 < x < 65536.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Optional) If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        (Optional) Protocol for port. Must be "TCP". Defaults to "TCP".
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ContainerResponse(dict):
    """
    A single application container. This specifies both the container to run, the command to run in the container and the arguments to supply to it. Note that additional arguments may be supplied by the system to the container at runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "envFrom":
            suggest = "env_from"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "readinessProbe":
            suggest = "readiness_probe"
        elif key == "securityContext":
            suggest = "security_context"
        elif key == "startupProbe":
            suggest = "startup_probe"
        elif key == "terminationMessagePath":
            suggest = "termination_message_path"
        elif key == "terminationMessagePolicy":
            suggest = "termination_message_policy"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Sequence[str],
                 command: Sequence[str],
                 env: Sequence['outputs.EnvVarResponse'],
                 env_from: Sequence['outputs.EnvFromSourceResponse'],
                 image: str,
                 image_pull_policy: str,
                 liveness_probe: 'outputs.ProbeResponse',
                 name: str,
                 ports: Sequence['outputs.ContainerPortResponse'],
                 readiness_probe: 'outputs.ProbeResponse',
                 resources: 'outputs.ResourceRequirementsResponse',
                 security_context: 'outputs.SecurityContextResponse',
                 startup_probe: 'outputs.ProbeResponse',
                 termination_message_path: str,
                 termination_message_policy: str,
                 volume_mounts: Sequence['outputs.VolumeMountResponse'],
                 working_dir: str):
        """
        A single application container. This specifies both the container to run, the command to run in the container and the arguments to supply to it. Note that additional arguments may be supplied by the system to the container at runtime.
        :param Sequence[str] args: (Optional) Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence['EnvVarResponse'] env: (Optional) List of environment variables to set in the container.
        :param Sequence['EnvFromSourceResponse'] env_from: (Optional) List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        :param str image: Only supports containers from Google Container Registry or Artifact Registry URL of the Container image. More info: https://kubernetes.io/docs/concepts/containers/images
        :param str image_pull_policy: (Optional) Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        :param 'ProbeResponse' liveness_probe: (Optional) Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param str name: (Optional) Name of the container specified as a DNS_LABEL. Currently unused in Cloud Run. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-label-names
        :param Sequence['ContainerPortResponse'] ports: (Optional) List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible. If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on.
        :param 'ProbeResponse' readiness_probe: (Optional) Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param 'ResourceRequirementsResponse' resources: (Optional) Compute Resources required by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        :param 'SecurityContextResponse' security_context: (Optional) Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        :param 'ProbeResponse' startup_probe: (Optional) Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param str termination_message_path: (Optional) Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log.
        :param str termination_message_policy: (Optional) Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        :param Sequence['VolumeMountResponse'] volume_mounts: (Optional) Volume to mount into the container's filesystem. Only supports SecretVolumeSources. Pod volumes to mount into the container's filesystem.
        :param str working_dir: (Optional) Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "env_from", env_from)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        pulumi.set(__self__, "liveness_probe", liveness_probe)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "readiness_probe", readiness_probe)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "security_context", security_context)
        pulumi.set(__self__, "startup_probe", startup_probe)
        pulumi.set(__self__, "termination_message_path", termination_message_path)
        pulumi.set(__self__, "termination_message_policy", termination_message_policy)
        pulumi.set(__self__, "volume_mounts", volume_mounts)
        pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        (Optional) Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Sequence[str]:
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def env(self) -> Sequence['outputs.EnvVarResponse']:
        """
        (Optional) List of environment variables to set in the container.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="envFrom")
    def env_from(self) -> Sequence['outputs.EnvFromSourceResponse']:
        """
        (Optional) List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        """
        return pulumi.get(self, "env_from")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        Only supports containers from Google Container Registry or Artifact Registry URL of the Container image. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> str:
        """
        (Optional) Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        """
        return pulumi.get(self, "image_pull_policy")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> 'outputs.ProbeResponse':
        """
        (Optional) Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Optional) Name of the container specified as a DNS_LABEL. Currently unused in Cloud Run. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-label-names
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.ContainerPortResponse']:
        """
        (Optional) List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible. If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> 'outputs.ProbeResponse':
        """
        (Optional) Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "readiness_probe")

    @property
    @pulumi.getter
    def resources(self) -> 'outputs.ResourceRequirementsResponse':
        """
        (Optional) Compute Resources required by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> 'outputs.SecurityContextResponse':
        """
        (Optional) Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        """
        return pulumi.get(self, "security_context")

    @property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> 'outputs.ProbeResponse':
        """
        (Optional) Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "startup_probe")

    @property
    @pulumi.getter(name="terminationMessagePath")
    def termination_message_path(self) -> str:
        """
        (Optional) Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log.
        """
        return pulumi.get(self, "termination_message_path")

    @property
    @pulumi.getter(name="terminationMessagePolicy")
    def termination_message_policy(self) -> str:
        """
        (Optional) Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_policy")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.VolumeMountResponse']:
        """
        (Optional) Volume to mount into the container's filesystem. Only supports SecretVolumeSources. Pod volumes to mount into the container's filesystem.
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> str:
        """
        (Optional) Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class EnvFromSourceResponse(dict):
    """
    Not supported by Cloud Run EnvFromSource represents the source of a set of ConfigMaps
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMapRef":
            suggest = "config_map_ref"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvFromSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvFromSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvFromSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map_ref: 'outputs.ConfigMapEnvSourceResponse',
                 prefix: str,
                 secret_ref: 'outputs.SecretEnvSourceResponse'):
        """
        Not supported by Cloud Run EnvFromSource represents the source of a set of ConfigMaps
        :param 'ConfigMapEnvSourceResponse' config_map_ref: (Optional) The ConfigMap to select from
        :param str prefix: (Optional) An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
        :param 'SecretEnvSourceResponse' secret_ref: (Optional) The Secret to select from
        """
        pulumi.set(__self__, "config_map_ref", config_map_ref)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter(name="configMapRef")
    def config_map_ref(self) -> 'outputs.ConfigMapEnvSourceResponse':
        """
        (Optional) The ConfigMap to select from
        """
        return pulumi.get(self, "config_map_ref")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        (Optional) An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> 'outputs.SecretEnvSourceResponse':
        """
        (Optional) The Secret to select from
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class EnvVarResponse(dict):
    """
    EnvVar represents an environment variable present in a Container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvVarResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvVarResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvVarResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: str,
                 value_from: 'outputs.EnvVarSourceResponse'):
        """
        EnvVar represents an environment variable present in a Container.
        :param str name: Name of the environment variable. Must be a C_IDENTIFIER.
        :param str value: (Optional) Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
        :param 'EnvVarSourceResponse' value_from: (Optional) Source for the environment variable's value. Only supports secret_key_ref. Source for the environment variable's value. Cannot be used if value is not empty.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        (Optional) Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> 'outputs.EnvVarSourceResponse':
        """
        (Optional) Source for the environment variable's value. Only supports secret_key_ref. Source for the environment variable's value. Cannot be used if value is not empty.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class EnvVarSourceResponse(dict):
    """
    EnvVarSource represents a source for the value of an EnvVar.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMapKeyRef":
            suggest = "config_map_key_ref"
        elif key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvVarSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvVarSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvVarSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map_key_ref: 'outputs.ConfigMapKeySelectorResponse',
                 secret_key_ref: 'outputs.SecretKeySelectorResponse'):
        """
        EnvVarSource represents a source for the value of an EnvVar.
        :param 'ConfigMapKeySelectorResponse' config_map_key_ref: (Optional) Not supported by Cloud Run Selects a key of a ConfigMap.
        :param 'SecretKeySelectorResponse' secret_key_ref: (Optional) Selects a key (version) of a secret in Secret Manager.
        """
        pulumi.set(__self__, "config_map_key_ref", config_map_key_ref)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="configMapKeyRef")
    def config_map_key_ref(self) -> 'outputs.ConfigMapKeySelectorResponse':
        """
        (Optional) Not supported by Cloud Run Selects a key of a ConfigMap.
        """
        return pulumi.get(self, "config_map_key_ref")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> 'outputs.SecretKeySelectorResponse':
        """
        (Optional) Selects a key (version) of a secret in Secret Manager.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class ExecActionResponse(dict):
    """
    Not supported by Cloud Run ExecAction describes a "run in container" action.
    """
    def __init__(__self__, *,
                 command: Sequence[str]):
        """
        Not supported by Cloud Run ExecAction describes a "run in container" action.
        :param Sequence[str] command: (Optional) Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
        """
        pulumi.set(__self__, "command", command)

    @property
    @pulumi.getter
    def command(self) -> Sequence[str]:
        """
        (Optional) Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
        """
        return pulumi.get(self, "command")


@pulumi.output_type
class GoogleRpcStatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class HTTPGetActionResponse(dict):
    """
    Not supported by Cloud Run HTTPGetAction describes an action based on HTTP Get requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HTTPGetActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HTTPGetActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HTTPGetActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: str,
                 http_headers: Sequence['outputs.HTTPHeaderResponse'],
                 path: str,
                 scheme: str):
        """
        Not supported by Cloud Run HTTPGetAction describes an action based on HTTP Get requests.
        :param str host: (Optional) Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        :param Sequence['HTTPHeaderResponse'] http_headers: (Optional) Custom headers to set in the request. HTTP allows repeated headers.
        :param str path: (Optional) Path to access on the HTTP server.
        :param str scheme: (Optional) Scheme to use for connecting to the host. Defaults to HTTP.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "http_headers", http_headers)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        (Optional) Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Sequence['outputs.HTTPHeaderResponse']:
        """
        (Optional) Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        (Optional) Path to access on the HTTP server.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def scheme(self) -> str:
        """
        (Optional) Scheme to use for connecting to the host. Defaults to HTTP.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class HTTPHeaderResponse(dict):
    """
    Not supported by Cloud Run HTTPHeader describes a custom header to be used in HTTP probes
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Not supported by Cloud Run HTTPHeader describes a custom header to be used in HTTP probes
        :param str name: The header field name
        :param str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InstanceAttemptResultResponse(dict):
    """
    Result of an instance attempt.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exitCode":
            suggest = "exit_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAttemptResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAttemptResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAttemptResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exit_code: int,
                 status: 'outputs.GoogleRpcStatusResponse'):
        """
        Result of an instance attempt.
        :param int exit_code: Optional. The exit code of this attempt. This may be unset if the container was unable to exit cleanly with a code due to some other failure. See status field for possible failure details.
        :param 'GoogleRpcStatusResponse' status: Optional. The status of this attempt. If the status code is OK, then the attempt succeeded.
        """
        pulumi.set(__self__, "exit_code", exit_code)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> int:
        """
        Optional. The exit code of this attempt. This may be unset if the container was unable to exit cleanly with a code due to some other failure. See status field for possible failure details.
        """
        return pulumi.get(self, "exit_code")

    @property
    @pulumi.getter
    def status(self) -> 'outputs.GoogleRpcStatusResponse':
        """
        Optional. The status of this attempt. If the status code is OK, then the attempt succeeded.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class InstanceSpecResponse(dict):
    """
    InstanceSpec is a description of an instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDeadlineSeconds":
            suggest = "active_deadline_seconds"
        elif key == "restartPolicy":
            suggest = "restart_policy"
        elif key == "serviceAccountName":
            suggest = "service_account_name"
        elif key == "terminationGracePeriodSeconds":
            suggest = "termination_grace_period_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_deadline_seconds: str,
                 containers: Sequence['outputs.ContainerResponse'],
                 restart_policy: str,
                 service_account_name: str,
                 termination_grace_period_seconds: str,
                 volumes: Sequence['outputs.VolumeResponse']):
        """
        InstanceSpec is a description of an instance.
        :param str active_deadline_seconds: Optional. Optional duration in seconds the instance may be active relative to StartTime before the system will actively try to mark it failed and kill associated containers. If set to zero, the system will never attempt to kill an instance based on time. Otherwise, value must be a positive integer. +optional
        :param Sequence['ContainerResponse'] containers: Optional. List of containers belonging to the instance. We disallow a number of fields on this Container. Only a single container may be provided.
        :param str restart_policy: Optional. Restart policy for all containers within the instance. Allowed values are: - OnFailure: Instances will always be restarted on failure if the backoffLimit has not been reached. - Never: Instances are never restarted and all failures are permanent. Cannot be used if backoffLimit is set. +optional
        :param str service_account_name: Optional. Email address of the IAM service account associated with the instance of a Job. The service account represents the identity of the running instance, and determines what permissions the instance has. If not provided, the instance will use the project's default service account. +optional
        :param str termination_grace_period_seconds: Optional. Optional duration in seconds the instance needs to terminate gracefully. Value must be non-negative integer. The value zero indicates delete immediately. The grace period is the duration in seconds after the processes running in the instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. +optional
        :param Sequence['VolumeResponse'] volumes: Optional. List of volumes that can be mounted by containers belonging to the instance. More info: https://kubernetes.io/docs/concepts/storage/volumes +optional
        """
        pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "restart_policy", restart_policy)
        pulumi.set(__self__, "service_account_name", service_account_name)
        pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> str:
        """
        Optional. Optional duration in seconds the instance may be active relative to StartTime before the system will actively try to mark it failed and kill associated containers. If set to zero, the system will never attempt to kill an instance based on time. Otherwise, value must be a positive integer. +optional
        """
        return pulumi.get(self, "active_deadline_seconds")

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.ContainerResponse']:
        """
        Optional. List of containers belonging to the instance. We disallow a number of fields on this Container. Only a single container may be provided.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> str:
        """
        Optional. Restart policy for all containers within the instance. Allowed values are: - OnFailure: Instances will always be restarted on failure if the backoffLimit has not been reached. - Never: Instances are never restarted and all failures are permanent. Cannot be used if backoffLimit is set. +optional
        """
        return pulumi.get(self, "restart_policy")

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> str:
        """
        Optional. Email address of the IAM service account associated with the instance of a Job. The service account represents the identity of the running instance, and determines what permissions the instance has. If not provided, the instance will use the project's default service account. +optional
        """
        return pulumi.get(self, "service_account_name")

    @property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> str:
        """
        Optional. Optional duration in seconds the instance needs to terminate gracefully. Value must be non-negative integer. The value zero indicates delete immediately. The grace period is the duration in seconds after the processes running in the instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. +optional
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.VolumeResponse']:
        """
        Optional. List of volumes that can be mounted by containers belonging to the instance. More info: https://kubernetes.io/docs/concepts/storage/volumes +optional
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class InstanceStatusResponse(dict):
    """
    Instance represents the status of an instance of a Job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionTime":
            suggest = "completion_time"
        elif key == "lastAttemptResult":
            suggest = "last_attempt_result"
        elif key == "lastExitCode":
            suggest = "last_exit_code"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completion_time: str,
                 failed: int,
                 index: int,
                 last_attempt_result: 'outputs.InstanceAttemptResultResponse',
                 last_exit_code: int,
                 restarted: int,
                 start_time: str,
                 succeeded: int):
        """
        Instance represents the status of an instance of a Job.
        :param str completion_time: Optional. Represents time when the instance was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param int failed: Optional. The number of times this instance exited with code > 0; +optional
        :param int index: Index of the instance, unique per Job, and beginning at 0.
        :param 'InstanceAttemptResultResponse' last_attempt_result: Optional. Result of the last attempt of this instance. +optional
        :param int last_exit_code: Optional. Last exit code seen for this instance. +optional
        :param int restarted: Optional. The number of times this instance was restarted. Instances are restarted according the restartPolicy configured in the Job template. +optional
        :param str start_time: Optional. Represents time when the instance was created by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param int succeeded: Optional. The number of times this instance exited with code == 0. +optional
        """
        pulumi.set(__self__, "completion_time", completion_time)
        pulumi.set(__self__, "failed", failed)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "last_attempt_result", last_attempt_result)
        pulumi.set(__self__, "last_exit_code", last_exit_code)
        pulumi.set(__self__, "restarted", restarted)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "succeeded", succeeded)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> str:
        """
        Optional. Represents time when the instance was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter
    def failed(self) -> int:
        """
        Optional. The number of times this instance exited with code > 0; +optional
        """
        return pulumi.get(self, "failed")

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        Index of the instance, unique per Job, and beginning at 0.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="lastAttemptResult")
    def last_attempt_result(self) -> 'outputs.InstanceAttemptResultResponse':
        """
        Optional. Result of the last attempt of this instance. +optional
        """
        return pulumi.get(self, "last_attempt_result")

    @property
    @pulumi.getter(name="lastExitCode")
    def last_exit_code(self) -> int:
        """
        Optional. Last exit code seen for this instance. +optional
        """
        return pulumi.get(self, "last_exit_code")

    @property
    @pulumi.getter
    def restarted(self) -> int:
        """
        Optional. The number of times this instance was restarted. Instances are restarted according the restartPolicy configured in the Job template. +optional
        """
        return pulumi.get(self, "restarted")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Optional. Represents time when the instance was created by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def succeeded(self) -> int:
        """
        Optional. The number of times this instance exited with code == 0. +optional
        """
        return pulumi.get(self, "succeeded")


@pulumi.output_type
class InstanceTemplateSpecResponse(dict):
    """
    InstanceTemplateSpec describes the data an instance should have when created from a template.
    """
    def __init__(__self__, *,
                 spec: 'outputs.InstanceSpecResponse'):
        """
        InstanceTemplateSpec describes the data an instance should have when created from a template.
        :param 'InstanceSpecResponse' spec: Optional. Specification of the desired behavior of the instance. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status +optional
        """
        pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.InstanceSpecResponse':
        """
        Optional. Specification of the desired behavior of the instance. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status +optional
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class JobConditionResponse(dict):
    """
    JobCondition defines a readiness condition for a Revision.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: str,
                 message: str,
                 reason: str,
                 severity: str,
                 status: str,
                 type: str):
        """
        JobCondition defines a readiness condition for a Revision.
        :param str last_transition_time: Optional. Last time the condition transitioned from one status to another.
        :param str message: Optional. Human readable message indicating details about the current status.
        :param str reason: Optional. One-word CamelCase reason for the condition's last transition.
        :param str severity: Optional. How to interpret failures of this condition, one of Error, Warning, Info
        :param str status: Status of the condition, one of True, False, Unknown.
        :param str type: Type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types include: * "Completed": True when the Job has successfully completed. * "Started": True when the Job has successfully started running. * "ResourcesAvailable": True when underlying resources have been provisioned.
        """
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> str:
        """
        Optional. Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Optional. Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        Optional. One-word CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Optional. How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types include: * "Completed": True when the Job has successfully completed. * "Started": True when the Job has successfully started running. * "ResourcesAvailable": True when underlying resources have been provisioned.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobSpecResponse(dict):
    """
    JobSpec describes how the job execution will look like.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDeadlineSeconds":
            suggest = "active_deadline_seconds"
        elif key == "backoffLimit":
            suggest = "backoff_limit"
        elif key == "ttlSecondsAfterFinished":
            suggest = "ttl_seconds_after_finished"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_deadline_seconds: str,
                 backoff_limit: int,
                 completions: int,
                 parallelism: int,
                 template: 'outputs.InstanceTemplateSpecResponse',
                 ttl_seconds_after_finished: int):
        """
        JobSpec describes how the job execution will look like.
        :param str active_deadline_seconds: Optional. Not supported. Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it. If set to zero, the system will never attempt to terminate the job based on time. Otherwise, the value must be positive integer. +optional
        :param int backoff_limit: Optional. Specifies the number of retries per instance, before marking this job failed. If set to zero, instances will never retry on failure. +optional
        :param int completions: Optional. Specifies the desired number of successfully finished instances the job should be run with. Setting to 1 means that parallelism is limited to 1 and the success of that instance signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        :param int parallelism: Optional. Specifies the maximum desired number of instances the job should run at any given time. Must be <= completions. The actual number of instances running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        :param 'InstanceTemplateSpecResponse' template: Optional. Describes the instance that will be created when executing a job.
        :param int ttl_seconds_after_finished: Optional. Not supported. ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job won't be automatically deleted. +optional
        """
        pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        pulumi.set(__self__, "backoff_limit", backoff_limit)
        pulumi.set(__self__, "completions", completions)
        pulumi.set(__self__, "parallelism", parallelism)
        pulumi.set(__self__, "template", template)
        pulumi.set(__self__, "ttl_seconds_after_finished", ttl_seconds_after_finished)

    @property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> str:
        """
        Optional. Not supported. Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it. If set to zero, the system will never attempt to terminate the job based on time. Otherwise, the value must be positive integer. +optional
        """
        return pulumi.get(self, "active_deadline_seconds")

    @property
    @pulumi.getter(name="backoffLimit")
    def backoff_limit(self) -> int:
        """
        Optional. Specifies the number of retries per instance, before marking this job failed. If set to zero, instances will never retry on failure. +optional
        """
        return pulumi.get(self, "backoff_limit")

    @property
    @pulumi.getter
    def completions(self) -> int:
        """
        Optional. Specifies the desired number of successfully finished instances the job should be run with. Setting to 1 means that parallelism is limited to 1 and the success of that instance signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        """
        return pulumi.get(self, "completions")

    @property
    @pulumi.getter
    def parallelism(self) -> int:
        """
        Optional. Specifies the maximum desired number of instances the job should run at any given time. Must be <= completions. The actual number of instances running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter
    def template(self) -> 'outputs.InstanceTemplateSpecResponse':
        """
        Optional. Describes the instance that will be created when executing a job.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="ttlSecondsAfterFinished")
    def ttl_seconds_after_finished(self) -> int:
        """
        Optional. Not supported. ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job won't be automatically deleted. +optional
        """
        return pulumi.get(self, "ttl_seconds_after_finished")


@pulumi.output_type
class JobStatusResponse(dict):
    """
    JobStatus represents the current state of a Job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionTime":
            suggest = "completion_time"
        elif key == "imageDigest":
            suggest = "image_digest"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active: int,
                 completion_time: str,
                 conditions: Sequence['outputs.JobConditionResponse'],
                 failed: int,
                 image_digest: str,
                 instances: Sequence['outputs.InstanceStatusResponse'],
                 observed_generation: int,
                 start_time: str,
                 succeeded: int):
        """
        JobStatus represents the current state of a Job.
        :param int active: Optional. The number of actively running instances. +optional
        :param str completion_time: Optional. Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param Sequence['JobConditionResponse'] conditions: Optional. The latest available observations of a job's current state. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        :param int failed: Optional. The number of instances which reached phase Failed. +optional
        :param str image_digest: Optional. ImageDigest holds the resolved digest for the image specified within .Spec.Template.Spec.Container.Image. The digest is resolved during the creation of the Job. This field holds the digest value regardless of whether a tag or digest was originally specified in the Container object.
        :param Sequence['InstanceStatusResponse'] instances: Optional. Status of completed, failed, and running instances. +optional
        :param int observed_generation: Optional. The 'generation' of the job that was last processed by the controller.
        :param str start_time: Optional. Represents time when the job was acknowledged by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param int succeeded: Optional. The number of instances which reached phase Succeeded. +optional
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "completion_time", completion_time)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "failed", failed)
        pulumi.set(__self__, "image_digest", image_digest)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "observed_generation", observed_generation)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "succeeded", succeeded)

    @property
    @pulumi.getter
    def active(self) -> int:
        """
        Optional. The number of actively running instances. +optional
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> str:
        """
        Optional. Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.JobConditionResponse']:
        """
        Optional. The latest available observations of a job's current state. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def failed(self) -> int:
        """
        Optional. The number of instances which reached phase Failed. +optional
        """
        return pulumi.get(self, "failed")

    @property
    @pulumi.getter(name="imageDigest")
    def image_digest(self) -> str:
        """
        Optional. ImageDigest holds the resolved digest for the image specified within .Spec.Template.Spec.Container.Image. The digest is resolved during the creation of the Job. This field holds the digest value regardless of whether a tag or digest was originally specified in the Container object.
        """
        return pulumi.get(self, "image_digest")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.InstanceStatusResponse']:
        """
        Optional. Status of completed, failed, and running instances. +optional
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> int:
        """
        Optional. The 'generation' of the job that was last processed by the controller.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Optional. Represents time when the job was acknowledged by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def succeeded(self) -> int:
        """
        Optional. The number of instances which reached phase Succeeded. +optional
        """
        return pulumi.get(self, "succeeded")


@pulumi.output_type
class KeyToPathResponse(dict):
    """
    Maps a string key to a path within a volume.
    """
    def __init__(__self__, *,
                 key: str,
                 mode: int,
                 path: str):
        """
        Maps a string key to a path within a volume.
        :param str key: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version. The key to project.
        :param int mode: (Optional) Mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param str path: The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version. The key to project.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def mode(self) -> int:
        """
        (Optional) Mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class LocalObjectReferenceResponse(dict):
    """
    Not supported by Cloud Run LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
    """
    def __init__(__self__, *,
                 name: str):
        """
        Not supported by Cloud Run LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
        :param str name: (Optional) Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Optional) Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ObjectMetaResponse(dict):
    """
    k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"
        elif key == "creationTimestamp":
            suggest = "creation_timestamp"
        elif key == "deletionGracePeriodSeconds":
            suggest = "deletion_grace_period_seconds"
        elif key == "deletionTimestamp":
            suggest = "deletion_timestamp"
        elif key == "generateName":
            suggest = "generate_name"
        elif key == "ownerReferences":
            suggest = "owner_references"
        elif key == "resourceVersion":
            suggest = "resource_version"
        elif key == "selfLink":
            suggest = "self_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectMetaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectMetaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectMetaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 cluster_name: str,
                 creation_timestamp: str,
                 deletion_grace_period_seconds: int,
                 deletion_timestamp: str,
                 finalizers: Sequence[str],
                 generate_name: str,
                 generation: int,
                 labels: Mapping[str, str],
                 name: str,
                 namespace: str,
                 owner_references: Sequence['outputs.OwnerReferenceResponse'],
                 resource_version: str,
                 self_link: str,
                 uid: str):
        """
        k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
        :param Mapping[str, str] annotations: (Optional) Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/user-guide/annotations
        :param str cluster_name: (Optional) Not supported by Cloud Run The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.
        :param str creation_timestamp: (Optional) CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC. Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param int deletion_grace_period_seconds: (Optional) Not supported by Cloud Run Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.
        :param str deletion_timestamp: (Optional) Not supported by Cloud Run DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested. Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param Sequence[str] finalizers: (Optional) Not supported by Cloud Run Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. +patchStrategy=merge
        :param str generate_name: (Optional) Not supported by Cloud Run GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server. If this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header). Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#idempotency string generateName = 2;
        :param int generation: (Optional) A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.
        :param Mapping[str, str] labels: (Optional) Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and routes. More info: https://kubernetes.io/docs/user-guide/labels
        :param str name: Name must be unique within a namespace, within a Cloud Run region. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/user-guide/identifiers#names +optional
        :param str namespace: Namespace defines the space within each name must be unique, within a Cloud Run region. In Cloud Run the namespace must be equal to either the project ID or project number.
        :param Sequence['OwnerReferenceResponse'] owner_references: (Optional) Not supported by Cloud Run List of objects that own this object. If ALL objects in the list have been deleted, this object will be garbage collected.
        :param str resource_version: Optional. An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server or omit the value to disable conflict-detection. They may only be valid for a particular resource or set of resources. Populated by the system. Read-only. Value must be treated as opaque by clients or omitted. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        :param str self_link: (Optional) SelfLink is a URL representing this object. Populated by the system. Read-only. string selfLink = 4;
        :param str uid: (Optional) UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations. Populated by the system. Read-only. More info: https://kubernetes.io/docs/user-guide/identifiers#uids
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        pulumi.set(__self__, "deletion_grace_period_seconds", deletion_grace_period_seconds)
        pulumi.set(__self__, "deletion_timestamp", deletion_timestamp)
        pulumi.set(__self__, "finalizers", finalizers)
        pulumi.set(__self__, "generate_name", generate_name)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "owner_references", owner_references)
        pulumi.set(__self__, "resource_version", resource_version)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        (Optional) Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/user-guide/annotations
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        (Optional) Not supported by Cloud Run The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> str:
        """
        (Optional) CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC. Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="deletionGracePeriodSeconds")
    def deletion_grace_period_seconds(self) -> int:
        """
        (Optional) Not supported by Cloud Run Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.
        """
        return pulumi.get(self, "deletion_grace_period_seconds")

    @property
    @pulumi.getter(name="deletionTimestamp")
    def deletion_timestamp(self) -> str:
        """
        (Optional) Not supported by Cloud Run DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested. Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        """
        return pulumi.get(self, "deletion_timestamp")

    @property
    @pulumi.getter
    def finalizers(self) -> Sequence[str]:
        """
        (Optional) Not supported by Cloud Run Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. +patchStrategy=merge
        """
        return pulumi.get(self, "finalizers")

    @property
    @pulumi.getter(name="generateName")
    def generate_name(self) -> str:
        """
        (Optional) Not supported by Cloud Run GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server. If this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header). Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#idempotency string generateName = 2;
        """
        return pulumi.get(self, "generate_name")

    @property
    @pulumi.getter
    def generation(self) -> int:
        """
        (Optional) A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        (Optional) Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and routes. More info: https://kubernetes.io/docs/user-guide/labels
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name must be unique within a namespace, within a Cloud Run region. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/user-guide/identifiers#names +optional
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace defines the space within each name must be unique, within a Cloud Run region. In Cloud Run the namespace must be equal to either the project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="ownerReferences")
    def owner_references(self) -> Sequence['outputs.OwnerReferenceResponse']:
        """
        (Optional) Not supported by Cloud Run List of objects that own this object. If ALL objects in the list have been deleted, this object will be garbage collected.
        """
        return pulumi.get(self, "owner_references")

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> str:
        """
        Optional. An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server or omit the value to disable conflict-detection. They may only be valid for a particular resource or set of resources. Populated by the system. Read-only. Value must be treated as opaque by clients or omitted. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        (Optional) SelfLink is a URL representing this object. Populated by the system. Read-only. string selfLink = 4;
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        (Optional) UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations. Populated by the system. Read-only. More info: https://kubernetes.io/docs/user-guide/identifiers#uids
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class OwnerReferenceResponse(dict):
    """
    OwnerReference contains enough information to let you identify an owning object. Currently, an owning object must be in the same namespace, so there is no namespace field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"
        elif key == "blockOwnerDeletion":
            suggest = "block_owner_deletion"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OwnerReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OwnerReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OwnerReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: str,
                 block_owner_deletion: bool,
                 controller: bool,
                 kind: str,
                 name: str,
                 uid: str):
        """
        OwnerReference contains enough information to let you identify an owning object. Currently, an owning object must be in the same namespace, so there is no namespace field.
        :param str api_version: API version of the referent.
        :param bool block_owner_deletion: If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned. +optional
        :param bool controller: If true, this reference points to the managing controller. +optional
        :param str kind: Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param str name: Name of the referent. More info: https://kubernetes.io/docs/user-guide/identifiers#names
        :param str uid: UID of the referent. More info: https://kubernetes.io/docs/user-guide/identifiers#uids
        """
        pulumi.set(__self__, "api_version", api_version)
        pulumi.set(__self__, "block_owner_deletion", block_owner_deletion)
        pulumi.set(__self__, "controller", controller)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> str:
        """
        API version of the referent.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter(name="blockOwnerDeletion")
    def block_owner_deletion(self) -> bool:
        """
        If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned. +optional
        """
        return pulumi.get(self, "block_owner_deletion")

    @property
    @pulumi.getter
    def controller(self) -> bool:
        """
        If true, this reference points to the managing controller. +optional
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the referent. More info: https://kubernetes.io/docs/user-guide/identifiers#names
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        UID of the referent. More info: https://kubernetes.io/docs/user-guide/identifiers#uids
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ProbeResponse(dict):
    """
    Not supported by Cloud Run Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exec":
            suggest = "exec_"
        elif key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProbeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProbeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProbeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exec_: 'outputs.ExecActionResponse',
                 failure_threshold: int,
                 http_get: 'outputs.HTTPGetActionResponse',
                 initial_delay_seconds: int,
                 period_seconds: int,
                 success_threshold: int,
                 tcp_socket: 'outputs.TCPSocketActionResponse',
                 timeout_seconds: int):
        """
        Not supported by Cloud Run Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
        :param 'ExecActionResponse' exec_: (Optional) One and only one of the following should be specified. Exec specifies the action to take. A field inlined from the Handler message.
        :param int failure_threshold: (Optional) Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param 'HTTPGetActionResponse' http_get: (Optional) HTTPGet specifies the http request to perform. A field inlined from the Handler message.
        :param int initial_delay_seconds: (Optional) Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param int period_seconds: (Optional) How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.
        :param int success_threshold: (Optional) Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness. Minimum value is 1.
        :param 'TCPSocketActionResponse' tcp_socket: (Optional) TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported A field inlined from the Handler message.
        :param int timeout_seconds: (Optional) Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        pulumi.set(__self__, "exec_", exec_)
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "http_get", http_get)
        pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "success_threshold", success_threshold)
        pulumi.set(__self__, "tcp_socket", tcp_socket)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> 'outputs.ExecActionResponse':
        """
        (Optional) One and only one of the following should be specified. Exec specifies the action to take. A field inlined from the Handler message.
        """
        return pulumi.get(self, "exec_")

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> int:
        """
        (Optional) Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> 'outputs.HTTPGetActionResponse':
        """
        (Optional) HTTPGet specifies the http request to perform. A field inlined from the Handler message.
        """
        return pulumi.get(self, "http_get")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> int:
        """
        (Optional) Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> int:
        """
        (Optional) How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> int:
        """
        (Optional) Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness. Minimum value is 1.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> 'outputs.TCPSocketActionResponse':
        """
        (Optional) TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported A field inlined from the Handler message.
        """
        return pulumi.get(self, "tcp_socket")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> int:
        """
        (Optional) Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ResourceRequirementsResponse(dict):
    """
    ResourceRequirements describes the compute resource requirements.
    """
    def __init__(__self__, *,
                 limits: Mapping[str, str],
                 requests: Mapping[str, str]):
        """
        ResourceRequirements describes the compute resource requirements.
        :param Mapping[str, str] limits: (Optional) Only memory and CPU are supported. Limits describes the maximum amount of compute resources allowed. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param Mapping[str, str] requests: (Optional) Only memory and CPU are supported. Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Mapping[str, str]:
        """
        (Optional) Only memory and CPU are supported. Limits describes the maximum amount of compute resources allowed. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def requests(self) -> Mapping[str, str]:
        """
        (Optional) Only memory and CPU are supported. Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class SecretEnvSourceResponse(dict):
    """
    Not supported by Cloud Run SecretEnvSource selects a Secret to populate the environment variables with. The contents of the target Secret's Data field will represent the key-value pairs as environment variables.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretEnvSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretEnvSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretEnvSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        Not supported by Cloud Run SecretEnvSource selects a Secret to populate the environment variables with. The contents of the target Secret's Data field will represent the key-value pairs as environment variables.
        :param 'LocalObjectReferenceResponse' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: The Secret to select from.
        :param bool optional: (Optional) Specify whether the Secret must be defined
        """
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Secret to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        (Optional) Specify whether the Secret must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class SecretKeySelectorResponse(dict):
    """
    SecretKeySelector selects a key of a Secret.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretKeySelectorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretKeySelectorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretKeySelectorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        SecretKeySelector selects a key of a Secret.
        :param str key: A Cloud Secret Manager secret version. Must be 'latest' for the latest version or an integer for a specific version. The key of the secret to select from. Must be a valid secret key.
        :param 'LocalObjectReferenceResponse' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: The name of the secret in Cloud Secret Manager. By default, the secret is assumed to be in the same project. If the secret is in another project, you must define an alias. An alias definition has the form: :projects//secrets/. If multiple alias definitions are needed, they must be separated by commas. The alias definitions must be set on the run.googleapis.com/secrets annotation. The name of the secret in the pod's namespace to select from.
        :param bool optional: (Optional) Specify whether the Secret or its key must be defined
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A Cloud Secret Manager secret version. Must be 'latest' for the latest version or an integer for a specific version. The key of the secret to select from. Must be a valid secret key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. By default, the secret is assumed to be in the same project. If the secret is in another project, you must define an alias. An alias definition has the form: :projects//secrets/. If multiple alias definitions are needed, they must be separated by commas. The alias definitions must be set on the run.googleapis.com/secrets annotation. The name of the secret in the pod's namespace to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        (Optional) Specify whether the Secret or its key must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class SecretVolumeSourceResponse(dict):
    """
    The secret's value will be presented as the content of a file whose name is defined in the item path. If no items are defined, the name of the file is the secret_name. The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"
        elif key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretVolumeSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretVolumeSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretVolumeSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_mode: int,
                 items: Sequence['outputs.KeyToPathResponse'],
                 optional: bool,
                 secret_name: str):
        """
        The secret's value will be presented as the content of a file whose name is defined in the item path. If no items are defined, the name of the file is the secret_name. The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names.
        :param int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 01 and 0777 (octal). If 0 or not set, it will default to 0644. Directories within the path are not affected by this setting. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['KeyToPathResponse'] items: (Optional) If unspecified, the volume will expose a file whose name is the secret_name. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a key and a path. If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified that is not present in the Secret, the volume setup will error unless it is marked optional.
        :param bool optional: (Optional) Specify whether the Secret or its keys must be defined.
        :param str secret_name: The name of the secret in Cloud Secret Manager. By default, the secret is assumed to be in the same project. If the secret is in another project, you must define an alias. An alias definition has the form: :projects//secrets/. If multiple alias definitions are needed, they must be separated by commas. The alias definitions must be set on the run.googleapis.com/secrets annotation. Name of the secret in the container's namespace to use.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "optional", optional)
        pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> int:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 01 and 0777 (octal). If 0 or not set, it will default to 0644. Directories within the path are not affected by this setting. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.KeyToPathResponse']:
        """
        (Optional) If unspecified, the volume will expose a file whose name is the secret_name. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a key and a path. If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified that is not present in the Secret, the volume setup will error unless it is marked optional.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        (Optional) Specify whether the Secret or its keys must be defined.
        """
        return pulumi.get(self, "optional")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. By default, the secret is assumed to be in the same project. If the secret is in another project, you must define an alias. An alias definition has the form: :projects//secrets/. If multiple alias definitions are needed, they must be separated by commas. The alias definitions must be set on the run.googleapis.com/secrets annotation. Name of the secret in the container's namespace to use.
        """
        return pulumi.get(self, "secret_name")


@pulumi.output_type
class SecurityContextResponse(dict):
    """
    Not supported by Cloud Run SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext. When both are set, the values in SecurityContext take precedence.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runAsUser":
            suggest = "run_as_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 run_as_user: int):
        """
        Not supported by Cloud Run SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext. When both are set, the values in SecurityContext take precedence.
        :param int run_as_user: (Optional) The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        pulumi.set(__self__, "run_as_user", run_as_user)

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> int:
        """
        (Optional) The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        return pulumi.get(self, "run_as_user")


@pulumi.output_type
class TCPSocketActionResponse(dict):
    """
    Not supported by Cloud Run TCPSocketAction describes an action based on opening a socket
    """
    def __init__(__self__, *,
                 host: str,
                 port: int):
        """
        Not supported by Cloud Run TCPSocketAction describes an action based on opening a socket
        :param str host: (Optional) Optional: Host name to connect to, defaults to the pod IP.
        :param int port: Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. This field is currently limited to integer types only because of proto's inability to properly support the IntOrString golang type.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        (Optional) Optional: Host name to connect to, defaults to the pod IP.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. This field is currently limited to integer types only because of proto's inability to properly support the IntOrString golang type.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class VolumeMountResponse(dict):
    """
    VolumeMount describes a mounting of a Volume within a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "subPath":
            suggest = "sub_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeMountResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeMountResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeMountResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: str,
                 name: str,
                 read_only: bool,
                 sub_path: str):
        """
        VolumeMount describes a mounting of a Volume within a container.
        :param str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'.
        :param str name: The name of the volume. There must be a corresponding Volume with the same name.
        :param bool read_only: (Optional) Only true is accepted. Defaults to true.
        :param str sub_path: (Optional) Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "sub_path", sub_path)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the volume. There must be a corresponding Volume with the same name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        """
        (Optional) Only true is accepted. Defaults to true.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> str:
        """
        (Optional) Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
        """
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class VolumeResponse(dict):
    """
    Volume represents a named volume in a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMap":
            suggest = "config_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map: 'outputs.ConfigMapVolumeSourceResponse',
                 name: str,
                 secret: 'outputs.SecretVolumeSourceResponse'):
        """
        Volume represents a named volume in a container.
        :param str name: Volume's name. In Cloud Run Fully Managed, the name 'cloudsql' is reserved.
        """
        pulumi.set(__self__, "config_map", config_map)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="configMap")
    def config_map(self) -> 'outputs.ConfigMapVolumeSourceResponse':
        return pulumi.get(self, "config_map")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Volume's name. In Cloud Run Fully Managed, the name 'cloudsql' is reserved.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> 'outputs.SecretVolumeSourceResponse':
        return pulumi.get(self, "secret")


