# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AcceleratorConfigResponse',
    'BindingResponse',
    'ContainerImageResponse',
    'DataprocParametersResponse',
    'DiskResponse',
    'EncryptionConfigResponse',
    'ExecutionResponse',
    'ExecutionTemplateResponse',
    'ExprResponse',
    'GuestOsFeatureResponse',
    'LocalDiskInitializeParamsResponse',
    'LocalDiskResponse',
    'ReservationAffinityResponse',
    'RuntimeAcceleratorConfigResponse',
    'RuntimeAccessConfigResponse',
    'RuntimeGuestOsFeatureResponse',
    'RuntimeMetricsResponse',
    'RuntimeShieldedInstanceConfigResponse',
    'RuntimeSoftwareConfigResponse',
    'SchedulerAcceleratorConfigResponse',
    'ShieldedInstanceConfigResponse',
    'UpgradeHistoryEntryResponse',
    'VertexAIParametersResponse',
    'VirtualMachineConfigResponse',
    'VirtualMachineResponse',
    'VmImageResponse',
]

@pulumi.output_type
class AcceleratorConfigResponse(dict):
    """
    Definition of a hardware accelerator. Note that not all combinations of `type` and `core_count` are valid. Check [GPUs on Compute Engine](/compute/docs/gpus/#gpus-list) to find a valid combination. TPUs are not supported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coreCount":
            suggest = "core_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AcceleratorConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AcceleratorConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AcceleratorConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 core_count: str,
                 type: str):
        """
        Definition of a hardware accelerator. Note that not all combinations of `type` and `core_count` are valid. Check [GPUs on Compute Engine](/compute/docs/gpus/#gpus-list) to find a valid combination. TPUs are not supported.
        :param str core_count: Count of cores of this accelerator.
        :param str type: Type of this accelerator.
        """
        pulumi.set(__self__, "core_count", core_count)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> str:
        """
        Count of cores of this accelerator.
        """
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of this accelerator.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ContainerImageResponse(dict):
    """
    Definition of a container image for starting a notebook instance with the environment installed in a container.
    """
    def __init__(__self__, *,
                 repository: str,
                 tag: str):
        """
        Definition of a container image for starting a notebook instance with the environment installed in a container.
        :param str repository: The path to the container image repository. For example: `gcr.io/{project_id}/{image_name}`
        :param str tag: The tag of the container image. If not specified, this defaults to the latest tag.
        """
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The path to the container image repository. For example: `gcr.io/{project_id}/{image_name}`
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        The tag of the container image. If not specified, this defaults to the latest tag.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class DataprocParametersResponse(dict):
    """
    Parameters used in Dataproc JobType executions.
    """
    def __init__(__self__, *,
                 cluster: str):
        """
        Parameters used in Dataproc JobType executions.
        :param str cluster: URI for cluster used to run Dataproc execution. Format: `projects/{PROJECT_ID}/regions/{REGION}/clusters/{CLUSTER_NAME}`
        """
        pulumi.set(__self__, "cluster", cluster)

    @property
    @pulumi.getter
    def cluster(self) -> str:
        """
        URI for cluster used to run Dataproc execution. Format: `projects/{PROJECT_ID}/regions/{REGION}/clusters/{CLUSTER_NAME}`
        """
        return pulumi.get(self, "cluster")


@pulumi.output_type
class DiskResponse(dict):
    """
    An instance-attached disk resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoDelete":
            suggest = "auto_delete"
        elif key == "deviceName":
            suggest = "device_name"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "guestOsFeatures":
            suggest = "guest_os_features"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_delete: bool,
                 boot: bool,
                 device_name: str,
                 disk_size_gb: str,
                 guest_os_features: Sequence['outputs.GuestOsFeatureResponse'],
                 index: str,
                 interface: str,
                 kind: str,
                 licenses: Sequence[str],
                 mode: str,
                 source: str,
                 type: str):
        """
        An instance-attached disk resource.
        :param bool auto_delete: Indicates whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        :param bool boot: Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        :param str device_name: Indicates a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine.This field is only applicable for persistent disks.
        :param str disk_size_gb: Indicates the size of the disk in base-2 GB.
        :param Sequence['GuestOsFeatureResponse'] guest_os_features: Indicates a list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        :param str index: A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
        :param str interface: Indicates the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance. Valid values: * NVME * SCSI
        :param str kind: Type of the resource. Always compute#attachedDisk for attached disks.
        :param Sequence[str] licenses: A list of publicly visible licenses. Reserved for Google's use. A License represents billing and aggregate usage data for public and marketplace images.
        :param str mode: The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode. Valid values: * READ_ONLY * READ_WRITE
        :param str source: Indicates a valid partial or full URL to an existing Persistent Disk resource.
        :param str type: Indicates the type of the disk, either SCRATCH or PERSISTENT. Valid values: * PERSISTENT * SCRATCH
        """
        pulumi.set(__self__, "auto_delete", auto_delete)
        pulumi.set(__self__, "boot", boot)
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "guest_os_features", guest_os_features)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "interface", interface)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "licenses", licenses)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> bool:
        """
        Indicates whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        """
        return pulumi.get(self, "auto_delete")

    @property
    @pulumi.getter
    def boot(self) -> bool:
        """
        Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        """
        return pulumi.get(self, "boot")

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        Indicates a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine.This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> str:
        """
        Indicates the size of the disk in base-2 GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Sequence['outputs.GuestOsFeatureResponse']:
        """
        Indicates a list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        """
        return pulumi.get(self, "guest_os_features")

    @property
    @pulumi.getter
    def index(self) -> str:
        """
        A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def interface(self) -> str:
        """
        Indicates the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance. Valid values: * NVME * SCSI
        """
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of the resource. Always compute#attachedDisk for attached disks.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def licenses(self) -> Sequence[str]:
        """
        A list of publicly visible licenses. Reserved for Google's use. A License represents billing and aggregate usage data for public and marketplace images.
        """
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode. Valid values: * READ_ONLY * READ_WRITE
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        Indicates a valid partial or full URL to an existing Persistent Disk resource.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of the disk, either SCRATCH or PERSISTENT. Valid values: * PERSISTENT * SCRATCH
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EncryptionConfigResponse(dict):
    """
    Represents a custom encryption key configuration that can be applied to a resource. This will encrypt all disks in Virtual Machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key: str):
        """
        Represents a custom encryption key configuration that can be applied to a resource. This will encrypt all disks in Virtual Machine.
        :param str kms_key: The Cloud KMS resource identifier of the customer-managed encryption key used to protect a resource, such as a disks. It has the following format: `projects/{PROJECT_ID}/locations/{REGION}/keyRings/{KEY_RING_NAME}/cryptoKeys/{KEY_NAME}`
        """
        pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> str:
        """
        The Cloud KMS resource identifier of the customer-managed encryption key used to protect a resource, such as a disks. It has the following format: `projects/{PROJECT_ID}/locations/{REGION}/keyRings/{KEY_RING_NAME}/cryptoKeys/{KEY_NAME}`
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class ExecutionResponse(dict):
    """
    The definition of a single executed notebook.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "executionTemplate":
            suggest = "execution_template"
        elif key == "jobUri":
            suggest = "job_uri"
        elif key == "outputNotebookFile":
            suggest = "output_notebook_file"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecutionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecutionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecutionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 display_name: str,
                 execution_template: 'outputs.ExecutionTemplateResponse',
                 job_uri: str,
                 name: str,
                 output_notebook_file: str,
                 state: str,
                 update_time: str):
        """
        The definition of a single executed notebook.
        :param str create_time: Time the Execution was instantiated.
        :param str description: A brief description of this execution.
        :param str display_name: Name used for UI purposes. Name can only contain alphanumeric characters and underscores '_'.
        :param 'ExecutionTemplateResponse' execution_template: execute metadata including name, hardware spec, region, labels, etc.
        :param str job_uri: The URI of the external job used to execute the notebook.
        :param str name: The resource name of the execute. Format: `projects/{project_id}/locations/{location}/executions/{execution_id}`
        :param str output_notebook_file: Output notebook file generated by this execution
        :param str state: State of the underlying AI Platform job.
        :param str update_time: Time the Execution was last updated.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "execution_template", execution_template)
        pulumi.set(__self__, "job_uri", job_uri)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "output_notebook_file", output_notebook_file)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time the Execution was instantiated.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A brief description of this execution.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name used for UI purposes. Name can only contain alphanumeric characters and underscores '_'.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionTemplate")
    def execution_template(self) -> 'outputs.ExecutionTemplateResponse':
        """
        execute metadata including name, hardware spec, region, labels, etc.
        """
        return pulumi.get(self, "execution_template")

    @property
    @pulumi.getter(name="jobUri")
    def job_uri(self) -> str:
        """
        The URI of the external job used to execute the notebook.
        """
        return pulumi.get(self, "job_uri")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the execute. Format: `projects/{project_id}/locations/{location}/executions/{execution_id}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputNotebookFile")
    def output_notebook_file(self) -> str:
        """
        Output notebook file generated by this execution
        """
        return pulumi.get(self, "output_notebook_file")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the underlying AI Platform job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Time the Execution was last updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class ExecutionTemplateResponse(dict):
    """
    The description a notebook execution workload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorConfig":
            suggest = "accelerator_config"
        elif key == "containerImageUri":
            suggest = "container_image_uri"
        elif key == "dataprocParameters":
            suggest = "dataproc_parameters"
        elif key == "inputNotebookFile":
            suggest = "input_notebook_file"
        elif key == "jobType":
            suggest = "job_type"
        elif key == "kernelSpec":
            suggest = "kernel_spec"
        elif key == "masterType":
            suggest = "master_type"
        elif key == "outputNotebookFolder":
            suggest = "output_notebook_folder"
        elif key == "paramsYamlFile":
            suggest = "params_yaml_file"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "vertexAiParameters":
            suggest = "vertex_ai_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecutionTemplateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecutionTemplateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecutionTemplateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_config: 'outputs.SchedulerAcceleratorConfigResponse',
                 container_image_uri: str,
                 dataproc_parameters: 'outputs.DataprocParametersResponse',
                 input_notebook_file: str,
                 job_type: str,
                 kernel_spec: str,
                 labels: Mapping[str, str],
                 master_type: str,
                 output_notebook_folder: str,
                 parameters: str,
                 params_yaml_file: str,
                 service_account: str,
                 tensorboard: str,
                 vertex_ai_parameters: 'outputs.VertexAIParametersResponse'):
        """
        The description a notebook execution workload.
        :param 'SchedulerAcceleratorConfigResponse' accelerator_config: Configuration (count and accelerator type) for hardware running notebook execution.
        :param str container_image_uri: Container Image URI to a DLVM Example: 'gcr.io/deeplearning-platform-release/base-cu100' More examples can be found at: https://cloud.google.com/ai-platform/deep-learning-containers/docs/choosing-container
        :param 'DataprocParametersResponse' dataproc_parameters: Parameters used in Dataproc JobType executions.
        :param str input_notebook_file: Path to the notebook file to execute. Must be in a Google Cloud Storage bucket. Format: `gs://{bucket_name}/{folder}/{notebook_file_name}` Ex: `gs://notebook_user/scheduled_notebooks/sentiment_notebook.ipynb`
        :param str job_type: The type of Job to be used on this execution.
        :param str kernel_spec: Name of the kernel spec to use. This must be specified if the kernel spec name on the execution target does not match the name in the input notebook file.
        :param Mapping[str, str] labels: Labels for execution. If execution is scheduled, a field included will be 'nbs-scheduled'. Otherwise, it is an immediate execution, and an included field will be 'nbs-immediate'. Use fields to efficiently index between various types of executions.
        :param str master_type: Specifies the type of virtual machine to use for your training job's master worker. You must specify this field when `scaleTier` is set to `CUSTOM`. You can use certain Compute Engine machine types directly in this field. The following types are supported: - `n1-standard-4` - `n1-standard-8` - `n1-standard-16` - `n1-standard-32` - `n1-standard-64` - `n1-standard-96` - `n1-highmem-2` - `n1-highmem-4` - `n1-highmem-8` - `n1-highmem-16` - `n1-highmem-32` - `n1-highmem-64` - `n1-highmem-96` - `n1-highcpu-16` - `n1-highcpu-32` - `n1-highcpu-64` - `n1-highcpu-96` Alternatively, you can use the following legacy machine types: - `standard` - `large_model` - `complex_model_s` - `complex_model_m` - `complex_model_l` - `standard_gpu` - `complex_model_m_gpu` - `complex_model_l_gpu` - `standard_p100` - `complex_model_m_p100` - `standard_v100` - `large_model_v100` - `complex_model_m_v100` - `complex_model_l_v100` Finally, if you want to use a TPU for training, specify `cloud_tpu` in this field. Learn more about the [special configuration options for training with TPU](https://cloud.google.com/ai-platform/training/docs/using-tpus#configuring_a_custom_tpu_machine).
        :param str output_notebook_folder: Path to the notebook folder to write to. Must be in a Google Cloud Storage bucket path. Format: `gs://{bucket_name}/{folder}` Ex: `gs://notebook_user/scheduled_notebooks`
        :param str parameters: Parameters used within the 'input_notebook_file' notebook.
        :param str params_yaml_file: Parameters to be overridden in the notebook during execution. Ref https://papermill.readthedocs.io/en/latest/usage-parameterize.html on how to specifying parameters in the input notebook and pass them here in an YAML file. Ex: `gs://notebook_user/scheduled_notebooks/sentiment_notebook_params.yaml`
        :param str service_account: The email address of a service account to use when running the execution. You must have the `iam.serviceAccounts.actAs` permission for the specified service account.
        :param str tensorboard: The name of a Vertex AI [Tensorboard] resource to which this execution will upload Tensorboard logs. Format: `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
        :param 'VertexAIParametersResponse' vertex_ai_parameters: Parameters used in Vertex AI JobType executions.
        """
        pulumi.set(__self__, "accelerator_config", accelerator_config)
        pulumi.set(__self__, "container_image_uri", container_image_uri)
        pulumi.set(__self__, "dataproc_parameters", dataproc_parameters)
        pulumi.set(__self__, "input_notebook_file", input_notebook_file)
        pulumi.set(__self__, "job_type", job_type)
        pulumi.set(__self__, "kernel_spec", kernel_spec)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "master_type", master_type)
        pulumi.set(__self__, "output_notebook_folder", output_notebook_folder)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "params_yaml_file", params_yaml_file)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "tensorboard", tensorboard)
        pulumi.set(__self__, "vertex_ai_parameters", vertex_ai_parameters)

    @property
    @pulumi.getter(name="acceleratorConfig")
    def accelerator_config(self) -> 'outputs.SchedulerAcceleratorConfigResponse':
        """
        Configuration (count and accelerator type) for hardware running notebook execution.
        """
        return pulumi.get(self, "accelerator_config")

    @property
    @pulumi.getter(name="containerImageUri")
    def container_image_uri(self) -> str:
        """
        Container Image URI to a DLVM Example: 'gcr.io/deeplearning-platform-release/base-cu100' More examples can be found at: https://cloud.google.com/ai-platform/deep-learning-containers/docs/choosing-container
        """
        return pulumi.get(self, "container_image_uri")

    @property
    @pulumi.getter(name="dataprocParameters")
    def dataproc_parameters(self) -> 'outputs.DataprocParametersResponse':
        """
        Parameters used in Dataproc JobType executions.
        """
        return pulumi.get(self, "dataproc_parameters")

    @property
    @pulumi.getter(name="inputNotebookFile")
    def input_notebook_file(self) -> str:
        """
        Path to the notebook file to execute. Must be in a Google Cloud Storage bucket. Format: `gs://{bucket_name}/{folder}/{notebook_file_name}` Ex: `gs://notebook_user/scheduled_notebooks/sentiment_notebook.ipynb`
        """
        return pulumi.get(self, "input_notebook_file")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> str:
        """
        The type of Job to be used on this execution.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter(name="kernelSpec")
    def kernel_spec(self) -> str:
        """
        Name of the kernel spec to use. This must be specified if the kernel spec name on the execution target does not match the name in the input notebook file.
        """
        return pulumi.get(self, "kernel_spec")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels for execution. If execution is scheduled, a field included will be 'nbs-scheduled'. Otherwise, it is an immediate execution, and an included field will be 'nbs-immediate'. Use fields to efficiently index between various types of executions.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="masterType")
    def master_type(self) -> str:
        """
        Specifies the type of virtual machine to use for your training job's master worker. You must specify this field when `scaleTier` is set to `CUSTOM`. You can use certain Compute Engine machine types directly in this field. The following types are supported: - `n1-standard-4` - `n1-standard-8` - `n1-standard-16` - `n1-standard-32` - `n1-standard-64` - `n1-standard-96` - `n1-highmem-2` - `n1-highmem-4` - `n1-highmem-8` - `n1-highmem-16` - `n1-highmem-32` - `n1-highmem-64` - `n1-highmem-96` - `n1-highcpu-16` - `n1-highcpu-32` - `n1-highcpu-64` - `n1-highcpu-96` Alternatively, you can use the following legacy machine types: - `standard` - `large_model` - `complex_model_s` - `complex_model_m` - `complex_model_l` - `standard_gpu` - `complex_model_m_gpu` - `complex_model_l_gpu` - `standard_p100` - `complex_model_m_p100` - `standard_v100` - `large_model_v100` - `complex_model_m_v100` - `complex_model_l_v100` Finally, if you want to use a TPU for training, specify `cloud_tpu` in this field. Learn more about the [special configuration options for training with TPU](https://cloud.google.com/ai-platform/training/docs/using-tpus#configuring_a_custom_tpu_machine).
        """
        return pulumi.get(self, "master_type")

    @property
    @pulumi.getter(name="outputNotebookFolder")
    def output_notebook_folder(self) -> str:
        """
        Path to the notebook folder to write to. Must be in a Google Cloud Storage bucket path. Format: `gs://{bucket_name}/{folder}` Ex: `gs://notebook_user/scheduled_notebooks`
        """
        return pulumi.get(self, "output_notebook_folder")

    @property
    @pulumi.getter
    def parameters(self) -> str:
        """
        Parameters used within the 'input_notebook_file' notebook.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="paramsYamlFile")
    def params_yaml_file(self) -> str:
        """
        Parameters to be overridden in the notebook during execution. Ref https://papermill.readthedocs.io/en/latest/usage-parameterize.html on how to specifying parameters in the input notebook and pass them here in an YAML file. Ex: `gs://notebook_user/scheduled_notebooks/sentiment_notebook_params.yaml`
        """
        return pulumi.get(self, "params_yaml_file")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        The email address of a service account to use when running the execution. You must have the `iam.serviceAccounts.actAs` permission for the specified service account.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def tensorboard(self) -> str:
        """
        The name of a Vertex AI [Tensorboard] resource to which this execution will upload Tensorboard logs. Format: `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
        """
        return pulumi.get(self, "tensorboard")

    @property
    @pulumi.getter(name="vertexAiParameters")
    def vertex_ai_parameters(self) -> 'outputs.VertexAIParametersResponse':
        """
        Parameters used in Vertex AI JobType executions.
        """
        return pulumi.get(self, "vertex_ai_parameters")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GuestOsFeatureResponse(dict):
    """
    Guest OS features for boot disk.
    """
    def __init__(__self__, *,
                 type: str):
        """
        Guest OS features for boot disk.
        :param str type: The ID of a supported feature. Read Enabling guest operating system features to see a list of available options. Valid values: * FEATURE_TYPE_UNSPECIFIED * MULTI_IP_SUBNET * SECURE_BOOT * UEFI_COMPATIBLE * VIRTIO_SCSI_MULTIQUEUE * WINDOWS
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The ID of a supported feature. Read Enabling guest operating system features to see a list of available options. Valid values: * FEATURE_TYPE_UNSPECIFIED * MULTI_IP_SUBNET * SECURE_BOOT * UEFI_COMPATIBLE * VIRTIO_SCSI_MULTIQUEUE * WINDOWS
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LocalDiskInitializeParamsResponse(dict):
    """
    Input only. Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new runtime. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskName":
            suggest = "disk_name"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "diskType":
            suggest = "disk_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocalDiskInitializeParamsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocalDiskInitializeParamsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocalDiskInitializeParamsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 disk_name: str,
                 disk_size_gb: str,
                 disk_type: str,
                 labels: Mapping[str, str]):
        """
        Input only. Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new runtime. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
        :param str description: Optional. Provide this property when creating the disk.
        :param str disk_name: Optional. Specifies the disk name. If not specified, the default is to use the name of the instance. If the disk with the instance name exists already in the given zone/region, a new name will be automatically generated.
        :param str disk_size_gb: Optional. Specifies the size of the disk in base-2 GB. If not specified, the disk will be the same size as the image (usually 10GB). If specified, the size must be equal to or larger than 10GB. Default 100 GB.
        :param str disk_type: Input only. The type of the boot disk attached to this instance, defaults to standard persistent disk (`PD_STANDARD`).
        :param Mapping[str, str] labels: Optional. Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Provide this property when creating the disk.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> str:
        """
        Optional. Specifies the disk name. If not specified, the default is to use the name of the instance. If the disk with the instance name exists already in the given zone/region, a new name will be automatically generated.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> str:
        """
        Optional. Specifies the size of the disk in base-2 GB. If not specified, the disk will be the same size as the image (usually 10GB). If specified, the size must be equal to or larger than 10GB. Default 100 GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        Input only. The type of the boot disk attached to this instance, defaults to standard persistent disk (`PD_STANDARD`).
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class LocalDiskResponse(dict):
    """
    A Local attached disk resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoDelete":
            suggest = "auto_delete"
        elif key == "deviceName":
            suggest = "device_name"
        elif key == "guestOsFeatures":
            suggest = "guest_os_features"
        elif key == "initializeParams":
            suggest = "initialize_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocalDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocalDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocalDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_delete: bool,
                 boot: bool,
                 device_name: str,
                 guest_os_features: Sequence['outputs.RuntimeGuestOsFeatureResponse'],
                 index: int,
                 initialize_params: 'outputs.LocalDiskInitializeParamsResponse',
                 interface: str,
                 kind: str,
                 licenses: Sequence[str],
                 mode: str,
                 source: str,
                 type: str):
        """
        A Local attached disk resource.
        :param bool auto_delete: Optional. Output only. Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        :param bool boot: Optional. Output only. Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        :param str device_name: Optional. Output only. Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
        :param Sequence['RuntimeGuestOsFeatureResponse'] guest_os_features: Indicates a list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        :param int index: A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
        :param 'LocalDiskInitializeParamsResponse' initialize_params: Input only. Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
        :param str interface: Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance. Valid values: * NVME * SCSI
        :param str kind: Type of the resource. Always compute#attachedDisk for attached disks.
        :param Sequence[str] licenses: Any valid publicly visible licenses.
        :param str mode: The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode. Valid values: * READ_ONLY * READ_WRITE
        :param str source: Specifies a valid partial or full URL to an existing Persistent Disk resource.
        :param str type: Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT. Valid values: * PERSISTENT * SCRATCH
        """
        pulumi.set(__self__, "auto_delete", auto_delete)
        pulumi.set(__self__, "boot", boot)
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "guest_os_features", guest_os_features)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "initialize_params", initialize_params)
        pulumi.set(__self__, "interface", interface)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "licenses", licenses)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> bool:
        """
        Optional. Output only. Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        """
        return pulumi.get(self, "auto_delete")

    @property
    @pulumi.getter
    def boot(self) -> bool:
        """
        Optional. Output only. Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        """
        return pulumi.get(self, "boot")

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        Optional. Output only. Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Sequence['outputs.RuntimeGuestOsFeatureResponse']:
        """
        Indicates a list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        """
        return pulumi.get(self, "guest_os_features")

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="initializeParams")
    def initialize_params(self) -> 'outputs.LocalDiskInitializeParamsResponse':
        """
        Input only. Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
        """
        return pulumi.get(self, "initialize_params")

    @property
    @pulumi.getter
    def interface(self) -> str:
        """
        Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance. Valid values: * NVME * SCSI
        """
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of the resource. Always compute#attachedDisk for attached disks.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def licenses(self) -> Sequence[str]:
        """
        Any valid publicly visible licenses.
        """
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode. Valid values: * READ_ONLY * READ_WRITE
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT. Valid values: * PERSISTENT * SCRATCH
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReservationAffinityResponse(dict):
    """
    Reservation Affinity for consuming Zonal reservation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumeReservationType":
            suggest = "consume_reservation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReservationAffinityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReservationAffinityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReservationAffinityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consume_reservation_type: str,
                 key: str,
                 values: Sequence[str]):
        """
        Reservation Affinity for consuming Zonal reservation.
        :param str consume_reservation_type: Optional. Type of reservation to consume
        :param str key: Optional. Corresponds to the label key of reservation resource.
        :param Sequence[str] values: Optional. Corresponds to the label values of reservation resource.
        """
        pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> str:
        """
        Optional. Type of reservation to consume
        """
        return pulumi.get(self, "consume_reservation_type")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Optional. Corresponds to the label key of reservation resource.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Optional. Corresponds to the label values of reservation resource.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class RuntimeAcceleratorConfigResponse(dict):
    """
    Definition of the types of hardware accelerators that can be used. Definition of the types of hardware accelerators that can be used. See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `nvidia-tesla-k80` * `nvidia-tesla-p100` * `nvidia-tesla-v100` * `nvidia-tesla-p4` * `nvidia-tesla-t4` * `nvidia-tesla-a100`
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coreCount":
            suggest = "core_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeAcceleratorConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeAcceleratorConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeAcceleratorConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 core_count: str,
                 type: str):
        """
        Definition of the types of hardware accelerators that can be used. Definition of the types of hardware accelerators that can be used. See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `nvidia-tesla-k80` * `nvidia-tesla-p100` * `nvidia-tesla-v100` * `nvidia-tesla-p4` * `nvidia-tesla-t4` * `nvidia-tesla-a100`
        :param str core_count: Count of cores of this accelerator.
        :param str type: Accelerator model.
        """
        pulumi.set(__self__, "core_count", core_count)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> str:
        """
        Count of cores of this accelerator.
        """
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Accelerator model.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RuntimeAccessConfigResponse(dict):
    """
    Specifies the login configuration for Runtime
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessType":
            suggest = "access_type"
        elif key == "proxyUri":
            suggest = "proxy_uri"
        elif key == "runtimeOwner":
            suggest = "runtime_owner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeAccessConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeAccessConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeAccessConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_type: str,
                 proxy_uri: str,
                 runtime_owner: str):
        """
        Specifies the login configuration for Runtime
        :param str access_type: The type of access mode this instance.
        :param str proxy_uri: The proxy endpoint that is used to access the runtime.
        :param str runtime_owner: The owner of this runtime after creation. Format: `alias@example.com` Currently supports one owner only.
        """
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "proxy_uri", proxy_uri)
        pulumi.set(__self__, "runtime_owner", runtime_owner)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> str:
        """
        The type of access mode this instance.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="proxyUri")
    def proxy_uri(self) -> str:
        """
        The proxy endpoint that is used to access the runtime.
        """
        return pulumi.get(self, "proxy_uri")

    @property
    @pulumi.getter(name="runtimeOwner")
    def runtime_owner(self) -> str:
        """
        The owner of this runtime after creation. Format: `alias@example.com` Currently supports one owner only.
        """
        return pulumi.get(self, "runtime_owner")


@pulumi.output_type
class RuntimeGuestOsFeatureResponse(dict):
    """
    Optional. A list of features to enable on the guest operating system. Applicable only for bootable images. Read [Enabling guest operating system features](https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features) to see a list of available options. Guest OS features for boot disk.
    """
    def __init__(__self__, *,
                 type: str):
        """
        Optional. A list of features to enable on the guest operating system. Applicable only for bootable images. Read [Enabling guest operating system features](https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features) to see a list of available options. Guest OS features for boot disk.
        :param str type: The ID of a supported feature. Read [Enabling guest operating system features](https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features) to see a list of available options. Valid values: * FEATURE_TYPE_UNSPECIFIED * MULTI_IP_SUBNET * SECURE_BOOT * UEFI_COMPATIBLE * VIRTIO_SCSI_MULTIQUEUE * WINDOWS
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The ID of a supported feature. Read [Enabling guest operating system features](https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features) to see a list of available options. Valid values: * FEATURE_TYPE_UNSPECIFIED * MULTI_IP_SUBNET * SECURE_BOOT * UEFI_COMPATIBLE * VIRTIO_SCSI_MULTIQUEUE * WINDOWS
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RuntimeMetricsResponse(dict):
    """
    Contains runtime daemon metrics, such as OS and kernels and sessions stats.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemMetrics":
            suggest = "system_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeMetricsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeMetricsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeMetricsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 system_metrics: Mapping[str, str]):
        """
        Contains runtime daemon metrics, such as OS and kernels and sessions stats.
        :param Mapping[str, str] system_metrics: The system metrics.
        """
        pulumi.set(__self__, "system_metrics", system_metrics)

    @property
    @pulumi.getter(name="systemMetrics")
    def system_metrics(self) -> Mapping[str, str]:
        """
        The system metrics.
        """
        return pulumi.get(self, "system_metrics")


@pulumi.output_type
class RuntimeShieldedInstanceConfigResponse(dict):
    """
    A set of Shielded Instance options. Check [Images using supported Shielded VM features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm). Not all combinations are valid.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"
        elif key == "enableVtpm":
            suggest = "enable_vtpm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeShieldedInstanceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeShieldedInstanceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeShieldedInstanceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: bool,
                 enable_secure_boot: bool,
                 enable_vtpm: bool):
        """
        A set of Shielded Instance options. Check [Images using supported Shielded VM features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm). Not all combinations are valid.
        :param bool enable_integrity_monitoring: Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the boot integrity of the instance. The attestation is performed against the integrity policy baseline. This baseline is initially derived from the implicitly trusted boot image when the instance is created. Enabled by default.
        :param bool enable_secure_boot: Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails. Disabled by default.
        :param bool enable_vtpm: Defines whether the instance has the vTPM enabled. Enabled by default.
        """
        pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> bool:
        """
        Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the boot integrity of the instance. The attestation is performed against the integrity policy baseline. This baseline is initially derived from the implicitly trusted boot image when the instance is created. Enabled by default.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> bool:
        """
        Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails. Disabled by default.
        """
        return pulumi.get(self, "enable_secure_boot")

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> bool:
        """
        Defines whether the instance has the vTPM enabled. Enabled by default.
        """
        return pulumi.get(self, "enable_vtpm")


@pulumi.output_type
class RuntimeSoftwareConfigResponse(dict):
    """
    Specifies the selection and configuration of software inside the runtime. The properties to set on runtime. Properties keys are specified in `key:value` format, for example: * `idle_shutdown: true` * `idle_shutdown_timeout: 180` * `enable_health_monitoring: true`
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customGpuDriverPath":
            suggest = "custom_gpu_driver_path"
        elif key == "enableHealthMonitoring":
            suggest = "enable_health_monitoring"
        elif key == "idleShutdown":
            suggest = "idle_shutdown"
        elif key == "idleShutdownTimeout":
            suggest = "idle_shutdown_timeout"
        elif key == "installGpuDriver":
            suggest = "install_gpu_driver"
        elif key == "notebookUpgradeSchedule":
            suggest = "notebook_upgrade_schedule"
        elif key == "postStartupScript":
            suggest = "post_startup_script"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeSoftwareConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeSoftwareConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeSoftwareConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_gpu_driver_path: str,
                 enable_health_monitoring: bool,
                 idle_shutdown: bool,
                 idle_shutdown_timeout: int,
                 install_gpu_driver: bool,
                 kernels: Sequence['outputs.ContainerImageResponse'],
                 notebook_upgrade_schedule: str,
                 post_startup_script: str,
                 upgradeable: bool):
        """
        Specifies the selection and configuration of software inside the runtime. The properties to set on runtime. Properties keys are specified in `key:value` format, for example: * `idle_shutdown: true` * `idle_shutdown_timeout: 180` * `enable_health_monitoring: true`
        :param str custom_gpu_driver_path: Specify a custom Cloud Storage path where the GPU driver is stored. If not specified, we'll automatically choose from official GPU drivers.
        :param bool enable_health_monitoring: Verifies core internal services are running. Default: True
        :param bool idle_shutdown: Runtime will automatically shutdown after idle_shutdown_time. Default: True
        :param int idle_shutdown_timeout: Time in minutes to wait before shutting down runtime. Default: 180 minutes
        :param bool install_gpu_driver: Install Nvidia Driver automatically. Default: True
        :param Sequence['ContainerImageResponse'] kernels: Optional. Use a list of container images to use as Kernels in the notebook instance.
        :param str notebook_upgrade_schedule: Cron expression in UTC timezone, used to schedule instance auto upgrade. Please follow the [cron format](https://en.wikipedia.org/wiki/Cron).
        :param str post_startup_script: Path to a Bash script that automatically runs after a notebook instance fully boots up. The path must be a URL or Cloud Storage path (`gs://path-to-file/file-name`).
        :param bool upgradeable: Bool indicating whether an newer image is available in an image family.
        """
        pulumi.set(__self__, "custom_gpu_driver_path", custom_gpu_driver_path)
        pulumi.set(__self__, "enable_health_monitoring", enable_health_monitoring)
        pulumi.set(__self__, "idle_shutdown", idle_shutdown)
        pulumi.set(__self__, "idle_shutdown_timeout", idle_shutdown_timeout)
        pulumi.set(__self__, "install_gpu_driver", install_gpu_driver)
        pulumi.set(__self__, "kernels", kernels)
        pulumi.set(__self__, "notebook_upgrade_schedule", notebook_upgrade_schedule)
        pulumi.set(__self__, "post_startup_script", post_startup_script)
        pulumi.set(__self__, "upgradeable", upgradeable)

    @property
    @pulumi.getter(name="customGpuDriverPath")
    def custom_gpu_driver_path(self) -> str:
        """
        Specify a custom Cloud Storage path where the GPU driver is stored. If not specified, we'll automatically choose from official GPU drivers.
        """
        return pulumi.get(self, "custom_gpu_driver_path")

    @property
    @pulumi.getter(name="enableHealthMonitoring")
    def enable_health_monitoring(self) -> bool:
        """
        Verifies core internal services are running. Default: True
        """
        return pulumi.get(self, "enable_health_monitoring")

    @property
    @pulumi.getter(name="idleShutdown")
    def idle_shutdown(self) -> bool:
        """
        Runtime will automatically shutdown after idle_shutdown_time. Default: True
        """
        return pulumi.get(self, "idle_shutdown")

    @property
    @pulumi.getter(name="idleShutdownTimeout")
    def idle_shutdown_timeout(self) -> int:
        """
        Time in minutes to wait before shutting down runtime. Default: 180 minutes
        """
        return pulumi.get(self, "idle_shutdown_timeout")

    @property
    @pulumi.getter(name="installGpuDriver")
    def install_gpu_driver(self) -> bool:
        """
        Install Nvidia Driver automatically. Default: True
        """
        return pulumi.get(self, "install_gpu_driver")

    @property
    @pulumi.getter
    def kernels(self) -> Sequence['outputs.ContainerImageResponse']:
        """
        Optional. Use a list of container images to use as Kernels in the notebook instance.
        """
        return pulumi.get(self, "kernels")

    @property
    @pulumi.getter(name="notebookUpgradeSchedule")
    def notebook_upgrade_schedule(self) -> str:
        """
        Cron expression in UTC timezone, used to schedule instance auto upgrade. Please follow the [cron format](https://en.wikipedia.org/wiki/Cron).
        """
        return pulumi.get(self, "notebook_upgrade_schedule")

    @property
    @pulumi.getter(name="postStartupScript")
    def post_startup_script(self) -> str:
        """
        Path to a Bash script that automatically runs after a notebook instance fully boots up. The path must be a URL or Cloud Storage path (`gs://path-to-file/file-name`).
        """
        return pulumi.get(self, "post_startup_script")

    @property
    @pulumi.getter
    def upgradeable(self) -> bool:
        """
        Bool indicating whether an newer image is available in an image family.
        """
        return pulumi.get(self, "upgradeable")


@pulumi.output_type
class SchedulerAcceleratorConfigResponse(dict):
    """
    Definition of a hardware accelerator. Note that not all combinations of `type` and `core_count` are valid. Check [GPUs on Compute Engine](https://cloud.google.com/compute/docs/gpus) to find a valid combination. TPUs are not supported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coreCount":
            suggest = "core_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulerAcceleratorConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulerAcceleratorConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulerAcceleratorConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 core_count: str,
                 type: str):
        """
        Definition of a hardware accelerator. Note that not all combinations of `type` and `core_count` are valid. Check [GPUs on Compute Engine](https://cloud.google.com/compute/docs/gpus) to find a valid combination. TPUs are not supported.
        :param str core_count: Count of cores of this accelerator.
        :param str type: Type of this accelerator.
        """
        pulumi.set(__self__, "core_count", core_count)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> str:
        """
        Count of cores of this accelerator.
        """
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of this accelerator.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ShieldedInstanceConfigResponse(dict):
    """
    A set of Shielded Instance options. Check [Images using supported Shielded VM features] Not all combinations are valid.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"
        elif key == "enableVtpm":
            suggest = "enable_vtpm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShieldedInstanceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShieldedInstanceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShieldedInstanceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: bool,
                 enable_secure_boot: bool,
                 enable_vtpm: bool):
        """
        A set of Shielded Instance options. Check [Images using supported Shielded VM features] Not all combinations are valid.
        :param bool enable_integrity_monitoring: Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the boot integrity of the instance. The attestation is performed against the integrity policy baseline. This baseline is initially derived from the implicitly trusted boot image when the instance is created. Enabled by default.
        :param bool enable_secure_boot: Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails. Disabled by default.
        :param bool enable_vtpm: Defines whether the instance has the vTPM enabled. Enabled by default.
        """
        pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> bool:
        """
        Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the boot integrity of the instance. The attestation is performed against the integrity policy baseline. This baseline is initially derived from the implicitly trusted boot image when the instance is created. Enabled by default.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> bool:
        """
        Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails. Disabled by default.
        """
        return pulumi.get(self, "enable_secure_boot")

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> bool:
        """
        Defines whether the instance has the vTPM enabled. Enabled by default.
        """
        return pulumi.get(self, "enable_vtpm")


@pulumi.output_type
class UpgradeHistoryEntryResponse(dict):
    """
    The entry of VM image upgrade history.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerImage":
            suggest = "container_image"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "targetImage":
            suggest = "target_image"
        elif key == "targetVersion":
            suggest = "target_version"
        elif key == "vmImage":
            suggest = "vm_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeHistoryEntryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeHistoryEntryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeHistoryEntryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 container_image: str,
                 create_time: str,
                 framework: str,
                 snapshot: str,
                 state: str,
                 target_image: str,
                 target_version: str,
                 version: str,
                 vm_image: str):
        """
        The entry of VM image upgrade history.
        :param str action: Action. Rolloback or Upgrade.
        :param str container_image: The container image before this instance upgrade.
        :param str create_time: The time that this instance upgrade history entry is created.
        :param str framework: The framework of this notebook instance.
        :param str snapshot: The snapshot of the boot disk of this notebook instance before upgrade.
        :param str state: The state of this instance upgrade history entry.
        :param str target_image: Target VM Image. Format: ainotebooks-vm/project/image-name/name.
        :param str target_version: Target VM Version, like m63.
        :param str version: The version of the notebook instance before this upgrade.
        :param str vm_image: The VM image before this instance upgrade.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "container_image", container_image)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "framework", framework)
        pulumi.set(__self__, "snapshot", snapshot)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "target_image", target_image)
        pulumi.set(__self__, "target_version", target_version)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "vm_image", vm_image)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Action. Rolloback or Upgrade.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> str:
        """
        The container image before this instance upgrade.
        """
        return pulumi.get(self, "container_image")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time that this instance upgrade history entry is created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def framework(self) -> str:
        """
        The framework of this notebook instance.
        """
        return pulumi.get(self, "framework")

    @property
    @pulumi.getter
    def snapshot(self) -> str:
        """
        The snapshot of the boot disk of this notebook instance before upgrade.
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of this instance upgrade history entry.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetImage")
    def target_image(self) -> str:
        """
        Target VM Image. Format: ainotebooks-vm/project/image-name/name.
        """
        return pulumi.get(self, "target_image")

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> str:
        """
        Target VM Version, like m63.
        """
        return pulumi.get(self, "target_version")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the notebook instance before this upgrade.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> str:
        """
        The VM image before this instance upgrade.
        """
        return pulumi.get(self, "vm_image")


@pulumi.output_type
class VertexAIParametersResponse(dict):
    """
    Parameters used in Vertex AI JobType executions.
    """
    def __init__(__self__, *,
                 env: Mapping[str, str],
                 network: str):
        """
        Parameters used in Vertex AI JobType executions.
        :param Mapping[str, str] env: Environment variables. At most 100 environment variables can be specified and unique. Example: GCP_BUCKET=gs://my-bucket/samples/
        :param str network: The full name of the Compute Engine [network](/compute/docs/networks-and-firewalls#networks) to which the Job should be peered. For example, `projects/12345/global/networks/myVPC`. [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert) is of the form `projects/{project}/global/networks/{network}`. Where {project} is a project number, as in `12345`, and {network} is a network name. Private services access must already be configured for the network. If left unspecified, the job is not peered with any network.
        """
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter
    def env(self) -> Mapping[str, str]:
        """
        Environment variables. At most 100 environment variables can be specified and unique. Example: GCP_BUCKET=gs://my-bucket/samples/
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The full name of the Compute Engine [network](/compute/docs/networks-and-firewalls#networks) to which the Job should be peered. For example, `projects/12345/global/networks/myVPC`. [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert) is of the form `projects/{project}/global/networks/{network}`. Where {project} is a project number, as in `12345`, and {network} is a network name. Private services access must already be configured for the network. If left unspecified, the job is not peered with any network.
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class VirtualMachineConfigResponse(dict):
    """
    The config settings for virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorConfig":
            suggest = "accelerator_config"
        elif key == "containerImages":
            suggest = "container_images"
        elif key == "dataDisk":
            suggest = "data_disk"
        elif key == "encryptionConfig":
            suggest = "encryption_config"
        elif key == "guestAttributes":
            suggest = "guest_attributes"
        elif key == "internalIpOnly":
            suggest = "internal_ip_only"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "nicType":
            suggest = "nic_type"
        elif key == "reservedIpRange":
            suggest = "reserved_ip_range"
        elif key == "shieldedInstanceConfig":
            suggest = "shielded_instance_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_config: 'outputs.RuntimeAcceleratorConfigResponse',
                 container_images: Sequence['outputs.ContainerImageResponse'],
                 data_disk: 'outputs.LocalDiskResponse',
                 encryption_config: 'outputs.EncryptionConfigResponse',
                 guest_attributes: Mapping[str, str],
                 internal_ip_only: bool,
                 labels: Mapping[str, str],
                 machine_type: str,
                 metadata: Mapping[str, str],
                 network: str,
                 nic_type: str,
                 reserved_ip_range: str,
                 shielded_instance_config: 'outputs.RuntimeShieldedInstanceConfigResponse',
                 subnet: str,
                 tags: Sequence[str],
                 zone: str):
        """
        The config settings for virtual machine.
        :param 'RuntimeAcceleratorConfigResponse' accelerator_config: Optional. The Compute Engine accelerator configuration for this runtime.
        :param Sequence['ContainerImageResponse'] container_images: Optional. Use a list of container images to use as Kernels in the notebook instance.
        :param 'LocalDiskResponse' data_disk: Data disk option configuration settings.
        :param 'EncryptionConfigResponse' encryption_config: Optional. Encryption settings for virtual machine data disk.
        :param Mapping[str, str] guest_attributes: The Compute Engine guest attributes. (see [Project and instance guest attributes](https://cloud.google.com/compute/docs/storing-retrieving-metadata#guest_attributes)).
        :param bool internal_ip_only: Optional. If true, runtime will only have internal IP addresses. By default, runtimes are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each vm. This `internal_ip_only` restriction can only be enabled for subnetwork enabled networks, and all dependencies must be configured to be accessible without external IP addresses.
        :param Mapping[str, str] labels: Optional. The labels to associate with this runtime. Label **keys** must contain 1 to 63 characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be empty, but, if present, must contain 1 to 63 characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a cluster.
        :param str machine_type: The Compute Engine machine type used for runtimes. Short name is valid. Examples: * `n1-standard-2` * `e2-standard-8`
        :param Mapping[str, str] metadata: Optional. The Compute Engine metadata entries to add to virtual machine. (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        :param str network: Optional. The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork. If neither `network` nor `subnet` is specified, the "default" network of the project is used, if it exists. A full URL or partial URI. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default` * `projects/[project_id]/regions/global/default` Runtimes are managed resources inside Google Infrastructure. Runtimes support the following network configurations: * Google Managed Network (Network & subnet are empty) * Consumer Project VPC (network & subnet are required). Requires configuring Private Service Access. * Shared VPC (network & subnet are required). Requires configuring Private Service Access.
        :param str nic_type: Optional. The type of vNIC to be used on this interface. This may be gVNIC or VirtioNet.
        :param str reserved_ip_range: Optional. Reserved IP Range name is used for VPC Peering. The subnetwork allocation will use the range *name* if it's assigned. Example: managed-notebooks-range-c PEERING_RANGE_NAME_3=managed-notebooks-range-c gcloud compute addresses create $PEERING_RANGE_NAME_3 \ --global \ --prefix-length=24 \ --description="Google Cloud Managed Notebooks Range 24 c" \ --network=$NETWORK \ --addresses=192.168.0.0 \ --purpose=VPC_PEERING Field value will be: `managed-notebooks-range-c`
        :param 'RuntimeShieldedInstanceConfigResponse' shielded_instance_config: Optional. Shielded VM Instance configuration settings.
        :param str subnet: Optional. The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network. A full URL or partial URI are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0` * `projects/[project_id]/regions/us-east1/subnetworks/sub0`
        :param Sequence[str] tags: Optional. The Compute Engine tags to add to runtime (see [Tagging instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        :param str zone: The zone where the virtual machine is located. If using regional request, the notebooks service will pick a location in the corresponding runtime region. On a get request, zone will always be present. Example: * `us-central1-b`
        """
        pulumi.set(__self__, "accelerator_config", accelerator_config)
        pulumi.set(__self__, "container_images", container_images)
        pulumi.set(__self__, "data_disk", data_disk)
        pulumi.set(__self__, "encryption_config", encryption_config)
        pulumi.set(__self__, "guest_attributes", guest_attributes)
        pulumi.set(__self__, "internal_ip_only", internal_ip_only)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "nic_type", nic_type)
        pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)
        pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="acceleratorConfig")
    def accelerator_config(self) -> 'outputs.RuntimeAcceleratorConfigResponse':
        """
        Optional. The Compute Engine accelerator configuration for this runtime.
        """
        return pulumi.get(self, "accelerator_config")

    @property
    @pulumi.getter(name="containerImages")
    def container_images(self) -> Sequence['outputs.ContainerImageResponse']:
        """
        Optional. Use a list of container images to use as Kernels in the notebook instance.
        """
        return pulumi.get(self, "container_images")

    @property
    @pulumi.getter(name="dataDisk")
    def data_disk(self) -> 'outputs.LocalDiskResponse':
        """
        Data disk option configuration settings.
        """
        return pulumi.get(self, "data_disk")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> 'outputs.EncryptionConfigResponse':
        """
        Optional. Encryption settings for virtual machine data disk.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter(name="guestAttributes")
    def guest_attributes(self) -> Mapping[str, str]:
        """
        The Compute Engine guest attributes. (see [Project and instance guest attributes](https://cloud.google.com/compute/docs/storing-retrieving-metadata#guest_attributes)).
        """
        return pulumi.get(self, "guest_attributes")

    @property
    @pulumi.getter(name="internalIpOnly")
    def internal_ip_only(self) -> bool:
        """
        Optional. If true, runtime will only have internal IP addresses. By default, runtimes are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each vm. This `internal_ip_only` restriction can only be enabled for subnetwork enabled networks, and all dependencies must be configured to be accessible without external IP addresses.
        """
        return pulumi.get(self, "internal_ip_only")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. The labels to associate with this runtime. Label **keys** must contain 1 to 63 characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be empty, but, if present, must contain 1 to 63 characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a cluster.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The Compute Engine machine type used for runtimes. Short name is valid. Examples: * `n1-standard-2` * `e2-standard-8`
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Optional. The Compute Engine metadata entries to add to virtual machine. (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        Optional. The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork. If neither `network` nor `subnet` is specified, the "default" network of the project is used, if it exists. A full URL or partial URI. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default` * `projects/[project_id]/regions/global/default` Runtimes are managed resources inside Google Infrastructure. Runtimes support the following network configurations: * Google Managed Network (Network & subnet are empty) * Consumer Project VPC (network & subnet are required). Requires configuring Private Service Access. * Shared VPC (network & subnet are required). Requires configuring Private Service Access.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="nicType")
    def nic_type(self) -> str:
        """
        Optional. The type of vNIC to be used on this interface. This may be gVNIC or VirtioNet.
        """
        return pulumi.get(self, "nic_type")

    @property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> str:
        """
        Optional. Reserved IP Range name is used for VPC Peering. The subnetwork allocation will use the range *name* if it's assigned. Example: managed-notebooks-range-c PEERING_RANGE_NAME_3=managed-notebooks-range-c gcloud compute addresses create $PEERING_RANGE_NAME_3 \ --global \ --prefix-length=24 \ --description="Google Cloud Managed Notebooks Range 24 c" \ --network=$NETWORK \ --addresses=192.168.0.0 \ --purpose=VPC_PEERING Field value will be: `managed-notebooks-range-c`
        """
        return pulumi.get(self, "reserved_ip_range")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> 'outputs.RuntimeShieldedInstanceConfigResponse':
        """
        Optional. Shielded VM Instance configuration settings.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def subnet(self) -> str:
        """
        Optional. The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network. A full URL or partial URI are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0` * `projects/[project_id]/regions/us-east1/subnetworks/sub0`
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Optional. The Compute Engine tags to add to runtime (see [Tagging instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The zone where the virtual machine is located. If using regional request, the notebooks service will pick a location in the corresponding runtime region. On a get request, zone will always be present. Example: * `us-central1-b`
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class VirtualMachineResponse(dict):
    """
    Runtime using Virtual Machine for computing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "instanceName":
            suggest = "instance_name"
        elif key == "virtualMachineConfig":
            suggest = "virtual_machine_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_id: str,
                 instance_name: str,
                 virtual_machine_config: 'outputs.VirtualMachineConfigResponse'):
        """
        Runtime using Virtual Machine for computing.
        :param str instance_id: The unique identifier of the Managed Compute Engine instance.
        :param str instance_name: The user-friendly name of the Managed Compute Engine instance.
        :param 'VirtualMachineConfigResponse' virtual_machine_config: Virtual Machine configuration settings.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "virtual_machine_config", virtual_machine_config)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The unique identifier of the Managed Compute Engine instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The user-friendly name of the Managed Compute Engine instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="virtualMachineConfig")
    def virtual_machine_config(self) -> 'outputs.VirtualMachineConfigResponse':
        """
        Virtual Machine configuration settings.
        """
        return pulumi.get(self, "virtual_machine_config")


@pulumi.output_type
class VmImageResponse(dict):
    """
    Definition of a custom Compute Engine virtual machine image for starting a notebook instance with the environment installed directly on the VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageFamily":
            suggest = "image_family"
        elif key == "imageName":
            suggest = "image_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_family: str,
                 image_name: str,
                 project: str):
        """
        Definition of a custom Compute Engine virtual machine image for starting a notebook instance with the environment installed directly on the VM.
        :param str image_family: Use this VM image family to find the image; the newest image in this family will be used.
        :param str image_name: Use VM image name to find the image.
        :param str project: The name of the Google Cloud project that this VM image belongs to. Format: `projects/{project_id}`
        """
        pulumi.set(__self__, "image_family", image_family)
        pulumi.set(__self__, "image_name", image_name)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="imageFamily")
    def image_family(self) -> str:
        """
        Use this VM image family to find the image; the newest image in this family will be used.
        """
        return pulumi.get(self, "image_family")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        Use VM image name to find the image.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The name of the Google Cloud project that this VM image belongs to. Format: `projects/{project_id}`
        """
        return pulumi.get(self, "project")


