# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetInstanceResult',
    'AwaitableGetInstanceResult',
    'get_instance',
    'get_instance_output',
]

@pulumi.output_type
class GetInstanceResult:
    def __init__(__self__, accelerator_config=None, boot_disk_size_gb=None, boot_disk_type=None, container_image=None, create_time=None, creator=None, custom_gpu_driver_path=None, data_disk_size_gb=None, data_disk_type=None, disk_encryption=None, disks=None, install_gpu_driver=None, instance_owners=None, kms_key=None, labels=None, machine_type=None, metadata=None, name=None, network=None, nic_type=None, no_proxy_access=None, no_public_ip=None, no_remove_data_disk=None, post_startup_script=None, proxy_uri=None, reservation_affinity=None, service_account=None, service_account_scopes=None, shielded_instance_config=None, state=None, subnet=None, tags=None, update_time=None, upgrade_history=None, vm_image=None):
        if accelerator_config and not isinstance(accelerator_config, dict):
            raise TypeError("Expected argument 'accelerator_config' to be a dict")
        pulumi.set(__self__, "accelerator_config", accelerator_config)
        if boot_disk_size_gb and not isinstance(boot_disk_size_gb, str):
            raise TypeError("Expected argument 'boot_disk_size_gb' to be a str")
        pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type and not isinstance(boot_disk_type, str):
            raise TypeError("Expected argument 'boot_disk_type' to be a str")
        pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if container_image and not isinstance(container_image, dict):
            raise TypeError("Expected argument 'container_image' to be a dict")
        pulumi.set(__self__, "container_image", container_image)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if creator and not isinstance(creator, str):
            raise TypeError("Expected argument 'creator' to be a str")
        pulumi.set(__self__, "creator", creator)
        if custom_gpu_driver_path and not isinstance(custom_gpu_driver_path, str):
            raise TypeError("Expected argument 'custom_gpu_driver_path' to be a str")
        pulumi.set(__self__, "custom_gpu_driver_path", custom_gpu_driver_path)
        if data_disk_size_gb and not isinstance(data_disk_size_gb, str):
            raise TypeError("Expected argument 'data_disk_size_gb' to be a str")
        pulumi.set(__self__, "data_disk_size_gb", data_disk_size_gb)
        if data_disk_type and not isinstance(data_disk_type, str):
            raise TypeError("Expected argument 'data_disk_type' to be a str")
        pulumi.set(__self__, "data_disk_type", data_disk_type)
        if disk_encryption and not isinstance(disk_encryption, str):
            raise TypeError("Expected argument 'disk_encryption' to be a str")
        pulumi.set(__self__, "disk_encryption", disk_encryption)
        if disks and not isinstance(disks, list):
            raise TypeError("Expected argument 'disks' to be a list")
        pulumi.set(__self__, "disks", disks)
        if install_gpu_driver and not isinstance(install_gpu_driver, bool):
            raise TypeError("Expected argument 'install_gpu_driver' to be a bool")
        pulumi.set(__self__, "install_gpu_driver", install_gpu_driver)
        if instance_owners and not isinstance(instance_owners, list):
            raise TypeError("Expected argument 'instance_owners' to be a list")
        pulumi.set(__self__, "instance_owners", instance_owners)
        if kms_key and not isinstance(kms_key, str):
            raise TypeError("Expected argument 'kms_key' to be a str")
        pulumi.set(__self__, "kms_key", kms_key)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if machine_type and not isinstance(machine_type, str):
            raise TypeError("Expected argument 'machine_type' to be a str")
        pulumi.set(__self__, "machine_type", machine_type)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network and not isinstance(network, str):
            raise TypeError("Expected argument 'network' to be a str")
        pulumi.set(__self__, "network", network)
        if nic_type and not isinstance(nic_type, str):
            raise TypeError("Expected argument 'nic_type' to be a str")
        pulumi.set(__self__, "nic_type", nic_type)
        if no_proxy_access and not isinstance(no_proxy_access, bool):
            raise TypeError("Expected argument 'no_proxy_access' to be a bool")
        pulumi.set(__self__, "no_proxy_access", no_proxy_access)
        if no_public_ip and not isinstance(no_public_ip, bool):
            raise TypeError("Expected argument 'no_public_ip' to be a bool")
        pulumi.set(__self__, "no_public_ip", no_public_ip)
        if no_remove_data_disk and not isinstance(no_remove_data_disk, bool):
            raise TypeError("Expected argument 'no_remove_data_disk' to be a bool")
        pulumi.set(__self__, "no_remove_data_disk", no_remove_data_disk)
        if post_startup_script and not isinstance(post_startup_script, str):
            raise TypeError("Expected argument 'post_startup_script' to be a str")
        pulumi.set(__self__, "post_startup_script", post_startup_script)
        if proxy_uri and not isinstance(proxy_uri, str):
            raise TypeError("Expected argument 'proxy_uri' to be a str")
        pulumi.set(__self__, "proxy_uri", proxy_uri)
        if reservation_affinity and not isinstance(reservation_affinity, dict):
            raise TypeError("Expected argument 'reservation_affinity' to be a dict")
        pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if service_account and not isinstance(service_account, str):
            raise TypeError("Expected argument 'service_account' to be a str")
        pulumi.set(__self__, "service_account", service_account)
        if service_account_scopes and not isinstance(service_account_scopes, list):
            raise TypeError("Expected argument 'service_account_scopes' to be a list")
        pulumi.set(__self__, "service_account_scopes", service_account_scopes)
        if shielded_instance_config and not isinstance(shielded_instance_config, dict):
            raise TypeError("Expected argument 'shielded_instance_config' to be a dict")
        pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet and not isinstance(subnet, str):
            raise TypeError("Expected argument 'subnet' to be a str")
        pulumi.set(__self__, "subnet", subnet)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if upgrade_history and not isinstance(upgrade_history, list):
            raise TypeError("Expected argument 'upgrade_history' to be a list")
        pulumi.set(__self__, "upgrade_history", upgrade_history)
        if vm_image and not isinstance(vm_image, dict):
            raise TypeError("Expected argument 'vm_image' to be a dict")
        pulumi.set(__self__, "vm_image", vm_image)

    @property
    @pulumi.getter(name="acceleratorConfig")
    def accelerator_config(self) -> 'outputs.AcceleratorConfigResponse':
        """
        The hardware accelerator used on this instance. If you use accelerators, make sure that your configuration has [enough vCPUs and memory to support the `machine_type` you have selected](/compute/docs/gpus/#gpus-list).
        """
        return pulumi.get(self, "accelerator_config")

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> str:
        """
        Input only. The size of the boot disk in GB attached to this instance, up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB. If not specified, this defaults to 100.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> str:
        """
        Input only. The type of the boot disk attached to this instance, defaults to standard persistent disk (`PD_STANDARD`).
        """
        return pulumi.get(self, "boot_disk_type")

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> 'outputs.ContainerImageResponse':
        """
        Use a container image to start the notebook instance.
        """
        return pulumi.get(self, "container_image")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Instance creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> str:
        """
        Email address of entity that sent original CreateInstance request.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="customGpuDriverPath")
    def custom_gpu_driver_path(self) -> str:
        """
        Specify a custom Cloud Storage path where the GPU driver is stored. If not specified, we'll automatically choose from official GPU drivers.
        """
        return pulumi.get(self, "custom_gpu_driver_path")

    @property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> str:
        """
        Input only. The size of the data disk in GB attached to this instance, up to a maximum of 64000 GB (64 TB). You can choose the size of the data disk based on how big your notebooks and data are. If not specified, this defaults to 100.
        """
        return pulumi.get(self, "data_disk_size_gb")

    @property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> str:
        """
        Input only. The type of the data disk attached to this instance, defaults to standard persistent disk (`PD_STANDARD`).
        """
        return pulumi.get(self, "data_disk_type")

    @property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> str:
        """
        Input only. Disk encryption method used on the boot and data disks, defaults to GMEK.
        """
        return pulumi.get(self, "disk_encryption")

    @property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.DiskResponse']:
        """
        Attached disks to notebook instance.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="installGpuDriver")
    def install_gpu_driver(self) -> bool:
        """
        Whether the end user authorizes Google Cloud to install GPU driver on this instance. If this field is empty or set to false, the GPU driver won't be installed. Only applicable to instances with GPUs.
        """
        return pulumi.get(self, "install_gpu_driver")

    @property
    @pulumi.getter(name="instanceOwners")
    def instance_owners(self) -> Sequence[str]:
        """
        Input only. The owner of this instance after creation. Format: `alias@example.com` Currently supports one owner only. If not specified, all of the service account users of your VM instance's service account can use the instance.
        """
        return pulumi.get(self, "instance_owners")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> str:
        """
        Input only. The KMS key used to encrypt the disks, only applicable if disk_encryption is CMEK. Format: `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}` Learn more about [using your own encryption keys](/kms/docs/quickstart).
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels to apply to this instance. These can be later modified by the setLabels method.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The [Compute Engine machine type](/compute/docs/machine-types) of this instance.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Custom metadata to apply to this instance.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of this notebook instance. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The name of the VPC that this instance is in. Format: `projects/{project_id}/global/networks/{network_id}`
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="nicType")
    def nic_type(self) -> str:
        """
        Optional. The type of vNIC to be used on this interface. This may be gVNIC or VirtioNet.
        """
        return pulumi.get(self, "nic_type")

    @property
    @pulumi.getter(name="noProxyAccess")
    def no_proxy_access(self) -> bool:
        """
        If true, the notebook instance will not register with the proxy.
        """
        return pulumi.get(self, "no_proxy_access")

    @property
    @pulumi.getter(name="noPublicIp")
    def no_public_ip(self) -> bool:
        """
        If true, no public IP will be assigned to this instance.
        """
        return pulumi.get(self, "no_public_ip")

    @property
    @pulumi.getter(name="noRemoveDataDisk")
    def no_remove_data_disk(self) -> bool:
        """
        Input only. If true, the data disk will not be auto deleted when deleting the instance.
        """
        return pulumi.get(self, "no_remove_data_disk")

    @property
    @pulumi.getter(name="postStartupScript")
    def post_startup_script(self) -> str:
        """
        Path to a Bash script that automatically runs after a notebook instance fully boots up. The path must be a URL or Cloud Storage path (`gs://path-to-file/file-name`).
        """
        return pulumi.get(self, "post_startup_script")

    @property
    @pulumi.getter(name="proxyUri")
    def proxy_uri(self) -> str:
        """
        The proxy endpoint that is used to access the Jupyter notebook.
        """
        return pulumi.get(self, "proxy_uri")

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> 'outputs.ReservationAffinityResponse':
        """
        Optional. The optional reservation affinity. Setting this field will apply the specified [Zonal Compute Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources) to this notebook instance.
        """
        return pulumi.get(self, "reservation_affinity")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        The service account on this instance, giving access to other Google Cloud services. You can use any service account within the same project, but you must have the service account user permission to use the instance. If not specified, the [Compute Engine default service account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> Sequence[str]:
        """
        Optional. The URIs of service account scopes to be included in Compute Engine instances. If not specified, the following [scopes](https://cloud.google.com/compute/docs/access/service-accounts#accesscopesiam) are defined: - https://www.googleapis.com/auth/cloud-platform - https://www.googleapis.com/auth/userinfo.email If not using default scopes, you need at least: https://www.googleapis.com/auth/compute
        """
        return pulumi.get(self, "service_account_scopes")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> 'outputs.ShieldedInstanceConfigResponse':
        """
        Optional. Shielded VM configuration. [Images using supported Shielded VM features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of this instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def subnet(self) -> str:
        """
        The name of the subnet that this instance is in. Format: `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Optional. The Compute Engine tags to add to runtime (see [Tagging instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Instance update time.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="upgradeHistory")
    def upgrade_history(self) -> Sequence['outputs.UpgradeHistoryEntryResponse']:
        """
        The upgrade history of this instance.
        """
        return pulumi.get(self, "upgrade_history")

    @property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> 'outputs.VmImageResponse':
        """
        Use a Compute Engine VM image to start the notebook instance.
        """
        return pulumi.get(self, "vm_image")


class AwaitableGetInstanceResult(GetInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceResult(
            accelerator_config=self.accelerator_config,
            boot_disk_size_gb=self.boot_disk_size_gb,
            boot_disk_type=self.boot_disk_type,
            container_image=self.container_image,
            create_time=self.create_time,
            creator=self.creator,
            custom_gpu_driver_path=self.custom_gpu_driver_path,
            data_disk_size_gb=self.data_disk_size_gb,
            data_disk_type=self.data_disk_type,
            disk_encryption=self.disk_encryption,
            disks=self.disks,
            install_gpu_driver=self.install_gpu_driver,
            instance_owners=self.instance_owners,
            kms_key=self.kms_key,
            labels=self.labels,
            machine_type=self.machine_type,
            metadata=self.metadata,
            name=self.name,
            network=self.network,
            nic_type=self.nic_type,
            no_proxy_access=self.no_proxy_access,
            no_public_ip=self.no_public_ip,
            no_remove_data_disk=self.no_remove_data_disk,
            post_startup_script=self.post_startup_script,
            proxy_uri=self.proxy_uri,
            reservation_affinity=self.reservation_affinity,
            service_account=self.service_account,
            service_account_scopes=self.service_account_scopes,
            shielded_instance_config=self.shielded_instance_config,
            state=self.state,
            subnet=self.subnet,
            tags=self.tags,
            update_time=self.update_time,
            upgrade_history=self.upgrade_history,
            vm_image=self.vm_image)


def get_instance(instance_id: Optional[str] = None,
                 location: Optional[str] = None,
                 project: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceResult:
    """
    Gets details of a single Instance.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:notebooks/v1:getInstance', __args__, opts=opts, typ=GetInstanceResult).value

    return AwaitableGetInstanceResult(
        accelerator_config=__ret__.accelerator_config,
        boot_disk_size_gb=__ret__.boot_disk_size_gb,
        boot_disk_type=__ret__.boot_disk_type,
        container_image=__ret__.container_image,
        create_time=__ret__.create_time,
        creator=__ret__.creator,
        custom_gpu_driver_path=__ret__.custom_gpu_driver_path,
        data_disk_size_gb=__ret__.data_disk_size_gb,
        data_disk_type=__ret__.data_disk_type,
        disk_encryption=__ret__.disk_encryption,
        disks=__ret__.disks,
        install_gpu_driver=__ret__.install_gpu_driver,
        instance_owners=__ret__.instance_owners,
        kms_key=__ret__.kms_key,
        labels=__ret__.labels,
        machine_type=__ret__.machine_type,
        metadata=__ret__.metadata,
        name=__ret__.name,
        network=__ret__.network,
        nic_type=__ret__.nic_type,
        no_proxy_access=__ret__.no_proxy_access,
        no_public_ip=__ret__.no_public_ip,
        no_remove_data_disk=__ret__.no_remove_data_disk,
        post_startup_script=__ret__.post_startup_script,
        proxy_uri=__ret__.proxy_uri,
        reservation_affinity=__ret__.reservation_affinity,
        service_account=__ret__.service_account,
        service_account_scopes=__ret__.service_account_scopes,
        shielded_instance_config=__ret__.shielded_instance_config,
        state=__ret__.state,
        subnet=__ret__.subnet,
        tags=__ret__.tags,
        update_time=__ret__.update_time,
        upgrade_history=__ret__.upgrade_history,
        vm_image=__ret__.vm_image)


@_utilities.lift_output_func(get_instance)
def get_instance_output(instance_id: Optional[pulumi.Input[str]] = None,
                        location: Optional[pulumi.Input[str]] = None,
                        project: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceResult]:
    """
    Gets details of a single Instance.
    """
    ...
