# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetExecutionResult',
    'AwaitableGetExecutionResult',
    'get_execution',
    'get_execution_output',
]

@pulumi.output_type
class GetExecutionResult:
    def __init__(__self__, create_time=None, description=None, display_name=None, execution_template=None, job_uri=None, name=None, output_notebook_file=None, state=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if execution_template and not isinstance(execution_template, dict):
            raise TypeError("Expected argument 'execution_template' to be a dict")
        pulumi.set(__self__, "execution_template", execution_template)
        if job_uri and not isinstance(job_uri, str):
            raise TypeError("Expected argument 'job_uri' to be a str")
        pulumi.set(__self__, "job_uri", job_uri)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if output_notebook_file and not isinstance(output_notebook_file, str):
            raise TypeError("Expected argument 'output_notebook_file' to be a str")
        pulumi.set(__self__, "output_notebook_file", output_notebook_file)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time the Execution was instantiated.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A brief description of this execution.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name used for UI purposes. Name can only contain alphanumeric characters and underscores '_'.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionTemplate")
    def execution_template(self) -> 'outputs.ExecutionTemplateResponse':
        """
        execute metadata including name, hardware spec, region, labels, etc.
        """
        return pulumi.get(self, "execution_template")

    @property
    @pulumi.getter(name="jobUri")
    def job_uri(self) -> str:
        """
        The URI of the external job used to execute the notebook.
        """
        return pulumi.get(self, "job_uri")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the execute. Format: `projects/{project_id}/locations/{location}/executions/{execution_id}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputNotebookFile")
    def output_notebook_file(self) -> str:
        """
        Output notebook file generated by this execution
        """
        return pulumi.get(self, "output_notebook_file")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the underlying AI Platform job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Time the Execution was last updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetExecutionResult(GetExecutionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExecutionResult(
            create_time=self.create_time,
            description=self.description,
            display_name=self.display_name,
            execution_template=self.execution_template,
            job_uri=self.job_uri,
            name=self.name,
            output_notebook_file=self.output_notebook_file,
            state=self.state,
            update_time=self.update_time)


def get_execution(execution_id: Optional[str] = None,
                  location: Optional[str] = None,
                  project: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExecutionResult:
    """
    Gets details of executions
    """
    __args__ = dict()
    __args__['executionId'] = execution_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:notebooks/v1:getExecution', __args__, opts=opts, typ=GetExecutionResult).value

    return AwaitableGetExecutionResult(
        create_time=__ret__.create_time,
        description=__ret__.description,
        display_name=__ret__.display_name,
        execution_template=__ret__.execution_template,
        job_uri=__ret__.job_uri,
        name=__ret__.name,
        output_notebook_file=__ret__.output_notebook_file,
        state=__ret__.state,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_execution)
def get_execution_output(execution_id: Optional[pulumi.Input[str]] = None,
                         location: Optional[pulumi.Input[str]] = None,
                         project: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExecutionResult]:
    """
    Gets details of executions
    """
    ...
