# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AbortInfoResponse',
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'BindingResponse',
    'CloudFunctionEndpointResponse',
    'CloudSQLInstanceInfoResponse',
    'DeliverInfoResponse',
    'DropInfoResponse',
    'EndpointInfoResponse',
    'EndpointResponse',
    'ExprResponse',
    'FirewallInfoResponse',
    'ForwardInfoResponse',
    'ForwardingRuleInfoResponse',
    'GKEMasterInfoResponse',
    'InstanceInfoResponse',
    'LatencyDistributionResponse',
    'LatencyPercentileResponse',
    'LoadBalancerBackendResponse',
    'LoadBalancerInfoResponse',
    'NetworkInfoResponse',
    'ProbingDetailsResponse',
    'ReachabilityDetailsResponse',
    'RouteInfoResponse',
    'StatusResponse',
    'StepResponse',
    'TraceResponse',
    'VpnGatewayInfoResponse',
    'VpnTunnelInfoResponse',
]

@pulumi.output_type
class AbortInfoResponse(dict):
    """
    Details of the final state "abort" and associated resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AbortInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AbortInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AbortInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cause: str,
                 resource_uri: str):
        """
        Details of the final state "abort" and associated resource.
        :param str cause: Causes that the analysis is aborted.
        :param str resource_uri: URI of the resource that caused the abort.
        """
        pulumi.set(__self__, "cause", cause)
        pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter
    def cause(self) -> str:
        """
        Causes that the analysis is aborted.
        """
        return pulumi.get(self, "cause")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> str:
        """
        URI of the resource that caused the abort.
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class CloudFunctionEndpointResponse(dict):
    """
    Wrapper for cloud function attributes.
    """
    def __init__(__self__, *,
                 uri: str):
        """
        Wrapper for cloud function attributes.
        :param str uri: A [Cloud function](https://cloud.google.com/functions) name.
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        A [Cloud function](https://cloud.google.com/functions) name.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class CloudSQLInstanceInfoResponse(dict):
    """
    For display only. Metadata associated with a Cloud SQL instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "externalIp":
            suggest = "external_ip"
        elif key == "internalIp":
            suggest = "internal_ip"
        elif key == "networkUri":
            suggest = "network_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudSQLInstanceInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudSQLInstanceInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudSQLInstanceInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 external_ip: str,
                 internal_ip: str,
                 network_uri: str,
                 region: str,
                 uri: str):
        """
        For display only. Metadata associated with a Cloud SQL instance.
        :param str display_name: Name of a Cloud SQL instance.
        :param str external_ip: External IP address of a Cloud SQL instance.
        :param str internal_ip: Internal IP address of a Cloud SQL instance.
        :param str network_uri: URI of a Cloud SQL instance network or empty string if the instance does not have one.
        :param str region: Region in which the Cloud SQL instance is running.
        :param str uri: URI of a Cloud SQL instance.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "external_ip", external_ip)
        pulumi.set(__self__, "internal_ip", internal_ip)
        pulumi.set(__self__, "network_uri", network_uri)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of a Cloud SQL instance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> str:
        """
        External IP address of a Cloud SQL instance.
        """
        return pulumi.get(self, "external_ip")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> str:
        """
        Internal IP address of a Cloud SQL instance.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter(name="networkUri")
    def network_uri(self) -> str:
        """
        URI of a Cloud SQL instance network or empty string if the instance does not have one.
        """
        return pulumi.get(self, "network_uri")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region in which the Cloud SQL instance is running.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of a Cloud SQL instance.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class DeliverInfoResponse(dict):
    """
    Details of the final state "deliver" and associated resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliverInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliverInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliverInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_uri: str,
                 target: str):
        """
        Details of the final state "deliver" and associated resource.
        :param str resource_uri: URI of the resource that the packet is delivered to.
        :param str target: Target type where the packet is delivered to.
        """
        pulumi.set(__self__, "resource_uri", resource_uri)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> str:
        """
        URI of the resource that the packet is delivered to.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Target type where the packet is delivered to.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class DropInfoResponse(dict):
    """
    Details of the final state "drop" and associated resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DropInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DropInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DropInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cause: str,
                 resource_uri: str):
        """
        Details of the final state "drop" and associated resource.
        :param str cause: Cause that the packet is dropped.
        :param str resource_uri: URI of the resource that caused the drop.
        """
        pulumi.set(__self__, "cause", cause)
        pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter
    def cause(self) -> str:
        """
        Cause that the packet is dropped.
        """
        return pulumi.get(self, "cause")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> str:
        """
        URI of the resource that caused the drop.
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class EndpointInfoResponse(dict):
    """
    For display only. The specification of the endpoints for the test. EndpointInfo is derived from source and destination Endpoint and validated by the backend data plane model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationIp":
            suggest = "destination_ip"
        elif key == "destinationNetworkUri":
            suggest = "destination_network_uri"
        elif key == "destinationPort":
            suggest = "destination_port"
        elif key == "sourceAgentUri":
            suggest = "source_agent_uri"
        elif key == "sourceIp":
            suggest = "source_ip"
        elif key == "sourceNetworkUri":
            suggest = "source_network_uri"
        elif key == "sourcePort":
            suggest = "source_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_ip: str,
                 destination_network_uri: str,
                 destination_port: int,
                 protocol: str,
                 source_agent_uri: str,
                 source_ip: str,
                 source_network_uri: str,
                 source_port: int):
        """
        For display only. The specification of the endpoints for the test. EndpointInfo is derived from source and destination Endpoint and validated by the backend data plane model.
        :param str destination_ip: Destination IP address.
        :param str destination_network_uri: URI of the network where this packet is sent to.
        :param int destination_port: Destination port. Only valid when protocol is TCP or UDP.
        :param str protocol: IP protocol in string format, for example: "TCP", "UDP", "ICMP".
        :param str source_agent_uri: URI of the source telemetry agent this packet originates from.
        :param str source_ip: Source IP address.
        :param str source_network_uri: URI of the network where this packet originates from.
        :param int source_port: Source port. Only valid when protocol is TCP or UDP.
        """
        pulumi.set(__self__, "destination_ip", destination_ip)
        pulumi.set(__self__, "destination_network_uri", destination_network_uri)
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_agent_uri", source_agent_uri)
        pulumi.set(__self__, "source_ip", source_ip)
        pulumi.set(__self__, "source_network_uri", source_network_uri)
        pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter(name="destinationIp")
    def destination_ip(self) -> str:
        """
        Destination IP address.
        """
        return pulumi.get(self, "destination_ip")

    @property
    @pulumi.getter(name="destinationNetworkUri")
    def destination_network_uri(self) -> str:
        """
        URI of the network where this packet is sent to.
        """
        return pulumi.get(self, "destination_network_uri")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> int:
        """
        Destination port. Only valid when protocol is TCP or UDP.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        IP protocol in string format, for example: "TCP", "UDP", "ICMP".
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceAgentUri")
    def source_agent_uri(self) -> str:
        """
        URI of the source telemetry agent this packet originates from.
        """
        return pulumi.get(self, "source_agent_uri")

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> str:
        """
        Source IP address.
        """
        return pulumi.get(self, "source_ip")

    @property
    @pulumi.getter(name="sourceNetworkUri")
    def source_network_uri(self) -> str:
        """
        URI of the network where this packet originates from.
        """
        return pulumi.get(self, "source_network_uri")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> int:
        """
        Source port. Only valid when protocol is TCP or UDP.
        """
        return pulumi.get(self, "source_port")


@pulumi.output_type
class EndpointResponse(dict):
    """
    Source or destination of the Connectivity Test.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudFunction":
            suggest = "cloud_function"
        elif key == "cloudSqlInstance":
            suggest = "cloud_sql_instance"
        elif key == "gkeMasterCluster":
            suggest = "gke_master_cluster"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkType":
            suggest = "network_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_function: 'outputs.CloudFunctionEndpointResponse',
                 cloud_sql_instance: str,
                 gke_master_cluster: str,
                 instance: str,
                 ip_address: str,
                 network: str,
                 network_type: str,
                 port: int,
                 project: str):
        """
        Source or destination of the Connectivity Test.
        :param 'CloudFunctionEndpointResponse' cloud_function: A [Cloud function](https://cloud.google.com/functions).
        :param str cloud_sql_instance: A [Cloud SQL](https://cloud.google.com/sql) instance URI.
        :param str gke_master_cluster: A cluster URI for [Google Kubernetes Engine master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
        :param str instance: A Compute Engine instance URI.
        :param str ip_address: The IP address of the endpoint, which can be an external or internal IP. An IPv6 address is only allowed when the test's destination is a [global load balancer VIP](https://cloud.google.com/load-balancing/docs/load-balancing-overview).
        :param str network: A Compute Engine network URI.
        :param str network_type: Type of the network where the endpoint is located. Applicable only to source endpoint, as destination network type can be inferred from the source.
        :param int port: The IP protocol port of the endpoint. Only applicable when protocol is TCP or UDP.
        :param str project: Project ID where the endpoint is located. The Project ID can be derived from the URI if you provide a VM instance or network URI. The following are two cases where you must provide the project ID: 1. Only the IP address is specified, and the IP address is within a GCP project. 2. When you are using Shared VPC and the IP address that you provide is from the service project. In this case, the network that the IP address resides in is defined in the host project.
        """
        pulumi.set(__self__, "cloud_function", cloud_function)
        pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        pulumi.set(__self__, "gke_master_cluster", gke_master_cluster)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="cloudFunction")
    def cloud_function(self) -> 'outputs.CloudFunctionEndpointResponse':
        """
        A [Cloud function](https://cloud.google.com/functions).
        """
        return pulumi.get(self, "cloud_function")

    @property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> str:
        """
        A [Cloud SQL](https://cloud.google.com/sql) instance URI.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @property
    @pulumi.getter(name="gkeMasterCluster")
    def gke_master_cluster(self) -> str:
        """
        A cluster URI for [Google Kubernetes Engine master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
        """
        return pulumi.get(self, "gke_master_cluster")

    @property
    @pulumi.getter
    def instance(self) -> str:
        """
        A Compute Engine instance URI.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the endpoint, which can be an external or internal IP. An IPv6 address is only allowed when the test's destination is a [global load balancer VIP](https://cloud.google.com/load-balancing/docs/load-balancing-overview).
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        A Compute Engine network URI.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        Type of the network where the endpoint is located. Applicable only to source endpoint, as destination network type can be inferred from the source.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The IP protocol port of the endpoint. Only applicable when protocol is TCP or UDP.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Project ID where the endpoint is located. The Project ID can be derived from the URI if you provide a VM instance or network URI. The following are two cases where you must provide the project ID: 1. Only the IP address is specified, and the IP address is within a GCP project. 2. When you are using Shared VPC and the IP address that you provide is from the service project. In this case, the network that the IP address resides in is defined in the host project.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class FirewallInfoResponse(dict):
    """
    For display only. Metadata associated with a VPC firewall rule, an implied VPC firewall rule, or a hierarchical firewall policy rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "firewallRuleType":
            suggest = "firewall_rule_type"
        elif key == "networkUri":
            suggest = "network_uri"
        elif key == "targetServiceAccounts":
            suggest = "target_service_accounts"
        elif key == "targetTags":
            suggest = "target_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 direction: str,
                 display_name: str,
                 firewall_rule_type: str,
                 network_uri: str,
                 policy: str,
                 priority: int,
                 target_service_accounts: Sequence[str],
                 target_tags: Sequence[str],
                 uri: str):
        """
        For display only. Metadata associated with a VPC firewall rule, an implied VPC firewall rule, or a hierarchical firewall policy rule.
        :param str action: Possible values: ALLOW, DENY
        :param str direction: Possible values: INGRESS, EGRESS
        :param str display_name: The display name of the VPC firewall rule. This field is not applicable to hierarchical firewall policy rules.
        :param str firewall_rule_type: The firewall rule's type.
        :param str network_uri: The URI of the VPC network that the firewall rule is associated with. This field is not applicable to hierarchical firewall policy rules.
        :param str policy: The hierarchical firewall policy that this rule is associated with. This field is not applicable to VPC firewall rules.
        :param int priority: The priority of the firewall rule.
        :param Sequence[str] target_service_accounts: The target service accounts specified by the firewall rule.
        :param Sequence[str] target_tags: The target tags defined by the VPC firewall rule. This field is not applicable to hierarchical firewall policy rules.
        :param str uri: The URI of the VPC firewall rule. This field is not applicable to implied firewall rules or hierarchical firewall policy rules.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "firewall_rule_type", firewall_rule_type)
        pulumi.set(__self__, "network_uri", network_uri)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "target_service_accounts", target_service_accounts)
        pulumi.set(__self__, "target_tags", target_tags)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Possible values: ALLOW, DENY
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        Possible values: INGRESS, EGRESS
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the VPC firewall rule. This field is not applicable to hierarchical firewall policy rules.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="firewallRuleType")
    def firewall_rule_type(self) -> str:
        """
        The firewall rule's type.
        """
        return pulumi.get(self, "firewall_rule_type")

    @property
    @pulumi.getter(name="networkUri")
    def network_uri(self) -> str:
        """
        The URI of the VPC network that the firewall rule is associated with. This field is not applicable to hierarchical firewall policy rules.
        """
        return pulumi.get(self, "network_uri")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        The hierarchical firewall policy that this rule is associated with. This field is not applicable to VPC firewall rules.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority of the firewall rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> Sequence[str]:
        """
        The target service accounts specified by the firewall rule.
        """
        return pulumi.get(self, "target_service_accounts")

    @property
    @pulumi.getter(name="targetTags")
    def target_tags(self) -> Sequence[str]:
        """
        The target tags defined by the VPC firewall rule. This field is not applicable to hierarchical firewall policy rules.
        """
        return pulumi.get(self, "target_tags")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The URI of the VPC firewall rule. This field is not applicable to implied firewall rules or hierarchical firewall policy rules.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class ForwardInfoResponse(dict):
    """
    Details of the final state "forward" and associated resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForwardInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForwardInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForwardInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_uri: str,
                 target: str):
        """
        Details of the final state "forward" and associated resource.
        :param str resource_uri: URI of the resource that the packet is forwarded to.
        :param str target: Target type where this packet is forwarded to.
        """
        pulumi.set(__self__, "resource_uri", resource_uri)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> str:
        """
        URI of the resource that the packet is forwarded to.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Target type where this packet is forwarded to.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ForwardingRuleInfoResponse(dict):
    """
    For display only. Metadata associated with a Compute Engine forwarding rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "matchedPortRange":
            suggest = "matched_port_range"
        elif key == "matchedProtocol":
            suggest = "matched_protocol"
        elif key == "networkUri":
            suggest = "network_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForwardingRuleInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForwardingRuleInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForwardingRuleInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 matched_port_range: str,
                 matched_protocol: str,
                 network_uri: str,
                 target: str,
                 uri: str,
                 vip: str):
        """
        For display only. Metadata associated with a Compute Engine forwarding rule.
        :param str display_name: Name of a Compute Engine forwarding rule.
        :param str matched_port_range: Port range defined in the forwarding rule that matches the test.
        :param str matched_protocol: Protocol defined in the forwarding rule that matches the test.
        :param str network_uri: Network URI. Only valid for Internal Load Balancer.
        :param str target: Target type of the forwarding rule.
        :param str uri: URI of a Compute Engine forwarding rule.
        :param str vip: VIP of the forwarding rule.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "matched_port_range", matched_port_range)
        pulumi.set(__self__, "matched_protocol", matched_protocol)
        pulumi.set(__self__, "network_uri", network_uri)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "vip", vip)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of a Compute Engine forwarding rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="matchedPortRange")
    def matched_port_range(self) -> str:
        """
        Port range defined in the forwarding rule that matches the test.
        """
        return pulumi.get(self, "matched_port_range")

    @property
    @pulumi.getter(name="matchedProtocol")
    def matched_protocol(self) -> str:
        """
        Protocol defined in the forwarding rule that matches the test.
        """
        return pulumi.get(self, "matched_protocol")

    @property
    @pulumi.getter(name="networkUri")
    def network_uri(self) -> str:
        """
        Network URI. Only valid for Internal Load Balancer.
        """
        return pulumi.get(self, "network_uri")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Target type of the forwarding rule.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of a Compute Engine forwarding rule.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def vip(self) -> str:
        """
        VIP of the forwarding rule.
        """
        return pulumi.get(self, "vip")


@pulumi.output_type
class GKEMasterInfoResponse(dict):
    """
    For display only. Metadata associated with a Google Kubernetes Engine (GKE) cluster master.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterNetworkUri":
            suggest = "cluster_network_uri"
        elif key == "clusterUri":
            suggest = "cluster_uri"
        elif key == "externalIp":
            suggest = "external_ip"
        elif key == "internalIp":
            suggest = "internal_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GKEMasterInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GKEMasterInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GKEMasterInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_network_uri: str,
                 cluster_uri: str,
                 external_ip: str,
                 internal_ip: str):
        """
        For display only. Metadata associated with a Google Kubernetes Engine (GKE) cluster master.
        :param str cluster_network_uri: URI of a GKE cluster network.
        :param str cluster_uri: URI of a GKE cluster.
        :param str external_ip: External IP address of a GKE cluster master.
        :param str internal_ip: Internal IP address of a GKE cluster master.
        """
        pulumi.set(__self__, "cluster_network_uri", cluster_network_uri)
        pulumi.set(__self__, "cluster_uri", cluster_uri)
        pulumi.set(__self__, "external_ip", external_ip)
        pulumi.set(__self__, "internal_ip", internal_ip)

    @property
    @pulumi.getter(name="clusterNetworkUri")
    def cluster_network_uri(self) -> str:
        """
        URI of a GKE cluster network.
        """
        return pulumi.get(self, "cluster_network_uri")

    @property
    @pulumi.getter(name="clusterUri")
    def cluster_uri(self) -> str:
        """
        URI of a GKE cluster.
        """
        return pulumi.get(self, "cluster_uri")

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> str:
        """
        External IP address of a GKE cluster master.
        """
        return pulumi.get(self, "external_ip")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> str:
        """
        Internal IP address of a GKE cluster master.
        """
        return pulumi.get(self, "internal_ip")


@pulumi.output_type
class InstanceInfoResponse(dict):
    """
    For display only. Metadata associated with a Compute Engine instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "externalIp":
            suggest = "external_ip"
        elif key == "internalIp":
            suggest = "internal_ip"
        elif key == "networkTags":
            suggest = "network_tags"
        elif key == "networkUri":
            suggest = "network_uri"
        elif key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 external_ip: str,
                 interface: str,
                 internal_ip: str,
                 network_tags: Sequence[str],
                 network_uri: str,
                 service_account: str,
                 uri: str):
        """
        For display only. Metadata associated with a Compute Engine instance.
        :param str display_name: Name of a Compute Engine instance.
        :param str external_ip: External IP address of the network interface.
        :param str interface: Name of the network interface of a Compute Engine instance.
        :param str internal_ip: Internal IP address of the network interface.
        :param Sequence[str] network_tags: Network tags configured on the instance.
        :param str network_uri: URI of a Compute Engine network.
        :param str service_account: Service account authorized for the instance.
        :param str uri: URI of a Compute Engine instance.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "external_ip", external_ip)
        pulumi.set(__self__, "interface", interface)
        pulumi.set(__self__, "internal_ip", internal_ip)
        pulumi.set(__self__, "network_tags", network_tags)
        pulumi.set(__self__, "network_uri", network_uri)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of a Compute Engine instance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> str:
        """
        External IP address of the network interface.
        """
        return pulumi.get(self, "external_ip")

    @property
    @pulumi.getter
    def interface(self) -> str:
        """
        Name of the network interface of a Compute Engine instance.
        """
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> str:
        """
        Internal IP address of the network interface.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Sequence[str]:
        """
        Network tags configured on the instance.
        """
        return pulumi.get(self, "network_tags")

    @property
    @pulumi.getter(name="networkUri")
    def network_uri(self) -> str:
        """
        URI of a Compute Engine network.
        """
        return pulumi.get(self, "network_uri")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Service account authorized for the instance.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of a Compute Engine instance.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class LatencyDistributionResponse(dict):
    """
    Describes measured latency distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latencyPercentiles":
            suggest = "latency_percentiles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LatencyDistributionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LatencyDistributionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LatencyDistributionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 latency_percentiles: Sequence['outputs.LatencyPercentileResponse']):
        """
        Describes measured latency distribution.
        :param Sequence['LatencyPercentileResponse'] latency_percentiles: Representative latency percentiles.
        """
        pulumi.set(__self__, "latency_percentiles", latency_percentiles)

    @property
    @pulumi.getter(name="latencyPercentiles")
    def latency_percentiles(self) -> Sequence['outputs.LatencyPercentileResponse']:
        """
        Representative latency percentiles.
        """
        return pulumi.get(self, "latency_percentiles")


@pulumi.output_type
class LatencyPercentileResponse(dict):
    """
    Latency percentile rank and value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latencyMicros":
            suggest = "latency_micros"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LatencyPercentileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LatencyPercentileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LatencyPercentileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 latency_micros: str,
                 percent: int):
        """
        Latency percentile rank and value.
        :param str latency_micros: percent-th percentile of latency observed, in microseconds. Fraction of percent/100 of samples have latency lower or equal to the value of this field.
        :param int percent: Percentage of samples this data point applies to.
        """
        pulumi.set(__self__, "latency_micros", latency_micros)
        pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter(name="latencyMicros")
    def latency_micros(self) -> str:
        """
        percent-th percentile of latency observed, in microseconds. Fraction of percent/100 of samples have latency lower or equal to the value of this field.
        """
        return pulumi.get(self, "latency_micros")

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        Percentage of samples this data point applies to.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class LoadBalancerBackendResponse(dict):
    """
    For display only. Metadata associated with a specific load balancer backend.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "healthCheckAllowingFirewallRules":
            suggest = "health_check_allowing_firewall_rules"
        elif key == "healthCheckBlockingFirewallRules":
            suggest = "health_check_blocking_firewall_rules"
        elif key == "healthCheckFirewallState":
            suggest = "health_check_firewall_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerBackendResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerBackendResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerBackendResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 health_check_allowing_firewall_rules: Sequence[str],
                 health_check_blocking_firewall_rules: Sequence[str],
                 health_check_firewall_state: str,
                 uri: str):
        """
        For display only. Metadata associated with a specific load balancer backend.
        :param str display_name: Name of a Compute Engine instance or network endpoint.
        :param Sequence[str] health_check_allowing_firewall_rules: A list of firewall rule URIs allowing probes from health check IP ranges.
        :param Sequence[str] health_check_blocking_firewall_rules: A list of firewall rule URIs blocking probes from health check IP ranges.
        :param str health_check_firewall_state: State of the health check firewall configuration.
        :param str uri: URI of a Compute Engine instance or network endpoint.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "health_check_allowing_firewall_rules", health_check_allowing_firewall_rules)
        pulumi.set(__self__, "health_check_blocking_firewall_rules", health_check_blocking_firewall_rules)
        pulumi.set(__self__, "health_check_firewall_state", health_check_firewall_state)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of a Compute Engine instance or network endpoint.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="healthCheckAllowingFirewallRules")
    def health_check_allowing_firewall_rules(self) -> Sequence[str]:
        """
        A list of firewall rule URIs allowing probes from health check IP ranges.
        """
        return pulumi.get(self, "health_check_allowing_firewall_rules")

    @property
    @pulumi.getter(name="healthCheckBlockingFirewallRules")
    def health_check_blocking_firewall_rules(self) -> Sequence[str]:
        """
        A list of firewall rule URIs blocking probes from health check IP ranges.
        """
        return pulumi.get(self, "health_check_blocking_firewall_rules")

    @property
    @pulumi.getter(name="healthCheckFirewallState")
    def health_check_firewall_state(self) -> str:
        """
        State of the health check firewall configuration.
        """
        return pulumi.get(self, "health_check_firewall_state")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of a Compute Engine instance or network endpoint.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class LoadBalancerInfoResponse(dict):
    """
    For display only. Metadata associated with a load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendType":
            suggest = "backend_type"
        elif key == "backendUri":
            suggest = "backend_uri"
        elif key == "healthCheckUri":
            suggest = "health_check_uri"
        elif key == "loadBalancerType":
            suggest = "load_balancer_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_type: str,
                 backend_uri: str,
                 backends: Sequence['outputs.LoadBalancerBackendResponse'],
                 health_check_uri: str,
                 load_balancer_type: str):
        """
        For display only. Metadata associated with a load balancer.
        :param str backend_type: Type of load balancer's backend configuration.
        :param str backend_uri: Backend configuration URI.
        :param Sequence['LoadBalancerBackendResponse'] backends: Information for the loadbalancer backends.
        :param str health_check_uri: URI of the health check for the load balancer.
        :param str load_balancer_type: Type of the load balancer.
        """
        pulumi.set(__self__, "backend_type", backend_type)
        pulumi.set(__self__, "backend_uri", backend_uri)
        pulumi.set(__self__, "backends", backends)
        pulumi.set(__self__, "health_check_uri", health_check_uri)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)

    @property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> str:
        """
        Type of load balancer's backend configuration.
        """
        return pulumi.get(self, "backend_type")

    @property
    @pulumi.getter(name="backendUri")
    def backend_uri(self) -> str:
        """
        Backend configuration URI.
        """
        return pulumi.get(self, "backend_uri")

    @property
    @pulumi.getter
    def backends(self) -> Sequence['outputs.LoadBalancerBackendResponse']:
        """
        Information for the loadbalancer backends.
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter(name="healthCheckUri")
    def health_check_uri(self) -> str:
        """
        URI of the health check for the load balancer.
        """
        return pulumi.get(self, "health_check_uri")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> str:
        """
        Type of the load balancer.
        """
        return pulumi.get(self, "load_balancer_type")


@pulumi.output_type
class NetworkInfoResponse(dict):
    """
    For display only. Metadata associated with a Compute Engine network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "matchedIpRange":
            suggest = "matched_ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 matched_ip_range: str,
                 uri: str):
        """
        For display only. Metadata associated with a Compute Engine network.
        :param str display_name: Name of a Compute Engine network.
        :param str matched_ip_range: The IP range that matches the test.
        :param str uri: URI of a Compute Engine network.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "matched_ip_range", matched_ip_range)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of a Compute Engine network.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="matchedIpRange")
    def matched_ip_range(self) -> str:
        """
        The IP range that matches the test.
        """
        return pulumi.get(self, "matched_ip_range")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of a Compute Engine network.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class ProbingDetailsResponse(dict):
    """
    Results of active probing from the last run of the test.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortCause":
            suggest = "abort_cause"
        elif key == "endpointInfo":
            suggest = "endpoint_info"
        elif key == "probingLatency":
            suggest = "probing_latency"
        elif key == "sentProbeCount":
            suggest = "sent_probe_count"
        elif key == "successfulProbeCount":
            suggest = "successful_probe_count"
        elif key == "verifyTime":
            suggest = "verify_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProbingDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProbingDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProbingDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 abort_cause: str,
                 endpoint_info: 'outputs.EndpointInfoResponse',
                 error: 'outputs.StatusResponse',
                 probing_latency: 'outputs.LatencyDistributionResponse',
                 result: str,
                 sent_probe_count: int,
                 successful_probe_count: int,
                 verify_time: str):
        """
        Results of active probing from the last run of the test.
        :param str abort_cause: The reason probing was aborted.
        :param 'EndpointInfoResponse' endpoint_info: The source and destination endpoints derived from the test input and used for active probing.
        :param 'StatusResponse' error: Details about an internal failure or the cancellation of active probing.
        :param 'LatencyDistributionResponse' probing_latency: Latency as measured by active probing in one direction: from the source to the destination endpoint.
        :param str result: The overall result of active probing.
        :param int sent_probe_count: Number of probes sent.
        :param int successful_probe_count: Number of probes that reached the destination.
        :param str verify_time: The time that reachability was assessed through active probing.
        """
        pulumi.set(__self__, "abort_cause", abort_cause)
        pulumi.set(__self__, "endpoint_info", endpoint_info)
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "probing_latency", probing_latency)
        pulumi.set(__self__, "result", result)
        pulumi.set(__self__, "sent_probe_count", sent_probe_count)
        pulumi.set(__self__, "successful_probe_count", successful_probe_count)
        pulumi.set(__self__, "verify_time", verify_time)

    @property
    @pulumi.getter(name="abortCause")
    def abort_cause(self) -> str:
        """
        The reason probing was aborted.
        """
        return pulumi.get(self, "abort_cause")

    @property
    @pulumi.getter(name="endpointInfo")
    def endpoint_info(self) -> 'outputs.EndpointInfoResponse':
        """
        The source and destination endpoints derived from the test input and used for active probing.
        """
        return pulumi.get(self, "endpoint_info")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.StatusResponse':
        """
        Details about an internal failure or the cancellation of active probing.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="probingLatency")
    def probing_latency(self) -> 'outputs.LatencyDistributionResponse':
        """
        Latency as measured by active probing in one direction: from the source to the destination endpoint.
        """
        return pulumi.get(self, "probing_latency")

    @property
    @pulumi.getter
    def result(self) -> str:
        """
        The overall result of active probing.
        """
        return pulumi.get(self, "result")

    @property
    @pulumi.getter(name="sentProbeCount")
    def sent_probe_count(self) -> int:
        """
        Number of probes sent.
        """
        return pulumi.get(self, "sent_probe_count")

    @property
    @pulumi.getter(name="successfulProbeCount")
    def successful_probe_count(self) -> int:
        """
        Number of probes that reached the destination.
        """
        return pulumi.get(self, "successful_probe_count")

    @property
    @pulumi.getter(name="verifyTime")
    def verify_time(self) -> str:
        """
        The time that reachability was assessed through active probing.
        """
        return pulumi.get(self, "verify_time")


@pulumi.output_type
class ReachabilityDetailsResponse(dict):
    """
    Results of the configuration analysis from the last run of the test.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "verifyTime":
            suggest = "verify_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReachabilityDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReachabilityDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReachabilityDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error: 'outputs.StatusResponse',
                 result: str,
                 traces: Sequence['outputs.TraceResponse'],
                 verify_time: str):
        """
        Results of the configuration analysis from the last run of the test.
        :param 'StatusResponse' error: The details of a failure or a cancellation of reachability analysis.
        :param str result: The overall result of the test's configuration analysis.
        :param Sequence['TraceResponse'] traces: Result may contain a list of traces if a test has multiple possible paths in the network, such as when destination endpoint is a load balancer with multiple backends.
        :param str verify_time: The time of the configuration analysis.
        """
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "result", result)
        pulumi.set(__self__, "traces", traces)
        pulumi.set(__self__, "verify_time", verify_time)

    @property
    @pulumi.getter
    def error(self) -> 'outputs.StatusResponse':
        """
        The details of a failure or a cancellation of reachability analysis.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def result(self) -> str:
        """
        The overall result of the test's configuration analysis.
        """
        return pulumi.get(self, "result")

    @property
    @pulumi.getter
    def traces(self) -> Sequence['outputs.TraceResponse']:
        """
        Result may contain a list of traces if a test has multiple possible paths in the network, such as when destination endpoint is a load balancer with multiple backends.
        """
        return pulumi.get(self, "traces")

    @property
    @pulumi.getter(name="verifyTime")
    def verify_time(self) -> str:
        """
        The time of the configuration analysis.
        """
        return pulumi.get(self, "verify_time")


@pulumi.output_type
class RouteInfoResponse(dict):
    """
    For display only. Metadata associated with a Compute Engine route.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destIpRange":
            suggest = "dest_ip_range"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "instanceTags":
            suggest = "instance_tags"
        elif key == "networkUri":
            suggest = "network_uri"
        elif key == "nextHop":
            suggest = "next_hop"
        elif key == "nextHopType":
            suggest = "next_hop_type"
        elif key == "routeType":
            suggest = "route_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dest_ip_range: str,
                 display_name: str,
                 instance_tags: Sequence[str],
                 network_uri: str,
                 next_hop: str,
                 next_hop_type: str,
                 priority: int,
                 route_type: str,
                 uri: str):
        """
        For display only. Metadata associated with a Compute Engine route.
        :param str dest_ip_range: Destination IP range of the route.
        :param str display_name: Name of a Compute Engine route.
        :param Sequence[str] instance_tags: Instance tags of the route.
        :param str network_uri: URI of a Compute Engine network.
        :param str next_hop: Next hop of the route.
        :param str next_hop_type: Type of next hop.
        :param int priority: Priority of the route.
        :param str route_type: Type of route.
        :param str uri: URI of a Compute Engine route. Dynamic route from cloud router does not have a URI. Advertised route from Google Cloud VPC to on-premises network also does not have a URI.
        """
        pulumi.set(__self__, "dest_ip_range", dest_ip_range)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "instance_tags", instance_tags)
        pulumi.set(__self__, "network_uri", network_uri)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "route_type", route_type)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="destIpRange")
    def dest_ip_range(self) -> str:
        """
        Destination IP range of the route.
        """
        return pulumi.get(self, "dest_ip_range")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of a Compute Engine route.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="instanceTags")
    def instance_tags(self) -> Sequence[str]:
        """
        Instance tags of the route.
        """
        return pulumi.get(self, "instance_tags")

    @property
    @pulumi.getter(name="networkUri")
    def network_uri(self) -> str:
        """
        URI of a Compute Engine network.
        """
        return pulumi.get(self, "network_uri")

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        Next hop of the route.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> str:
        """
        Type of next hop.
        """
        return pulumi.get(self, "next_hop_type")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Priority of the route.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="routeType")
    def route_type(self) -> str:
        """
        Type of route.
        """
        return pulumi.get(self, "route_type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of a Compute Engine route. Dynamic route from cloud router does not have a URI. Advertised route from Google Cloud VPC to on-premises network also does not have a URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class StepResponse(dict):
    """
    A simulated forwarding path is composed of multiple steps. Each step has a well-defined state and an associated configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "causesDrop":
            suggest = "causes_drop"
        elif key == "cloudSqlInstance":
            suggest = "cloud_sql_instance"
        elif key == "forwardingRule":
            suggest = "forwarding_rule"
        elif key == "gkeMaster":
            suggest = "gke_master"
        elif key == "loadBalancer":
            suggest = "load_balancer"
        elif key == "vpnGateway":
            suggest = "vpn_gateway"
        elif key == "vpnTunnel":
            suggest = "vpn_tunnel"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 abort: 'outputs.AbortInfoResponse',
                 causes_drop: bool,
                 cloud_sql_instance: 'outputs.CloudSQLInstanceInfoResponse',
                 deliver: 'outputs.DeliverInfoResponse',
                 description: str,
                 drop: 'outputs.DropInfoResponse',
                 endpoint: 'outputs.EndpointInfoResponse',
                 firewall: 'outputs.FirewallInfoResponse',
                 forward: 'outputs.ForwardInfoResponse',
                 forwarding_rule: 'outputs.ForwardingRuleInfoResponse',
                 gke_master: 'outputs.GKEMasterInfoResponse',
                 instance: 'outputs.InstanceInfoResponse',
                 load_balancer: 'outputs.LoadBalancerInfoResponse',
                 network: 'outputs.NetworkInfoResponse',
                 project: str,
                 route: 'outputs.RouteInfoResponse',
                 state: str,
                 vpn_gateway: 'outputs.VpnGatewayInfoResponse',
                 vpn_tunnel: 'outputs.VpnTunnelInfoResponse'):
        """
        A simulated forwarding path is composed of multiple steps. Each step has a well-defined state and an associated configuration.
        :param 'AbortInfoResponse' abort: Display information of the final state "abort" and reason.
        :param bool causes_drop: This is a step that leads to the final state Drop.
        :param 'CloudSQLInstanceInfoResponse' cloud_sql_instance: Display information of a Cloud SQL instance.
        :param 'DeliverInfoResponse' deliver: Display information of the final state "deliver" and reason.
        :param str description: A description of the step. Usually this is a summary of the state.
        :param 'DropInfoResponse' drop: Display information of the final state "drop" and reason.
        :param 'EndpointInfoResponse' endpoint: Display information of the source and destination under analysis. The endpoint information in an intermediate state may differ with the initial input, as it might be modified by state like NAT, or Connection Proxy.
        :param 'FirewallInfoResponse' firewall: Display information of a Compute Engine firewall rule.
        :param 'ForwardInfoResponse' forward: Display information of the final state "forward" and reason.
        :param 'ForwardingRuleInfoResponse' forwarding_rule: Display information of a Compute Engine forwarding rule.
        :param 'GKEMasterInfoResponse' gke_master: Display information of a Google Kubernetes Engine cluster master.
        :param 'InstanceInfoResponse' instance: Display information of a Compute Engine instance.
        :param 'LoadBalancerInfoResponse' load_balancer: Display information of the load balancers.
        :param 'NetworkInfoResponse' network: Display information of a Google Cloud network.
        :param str project: Project ID that contains the configuration this step is validating.
        :param 'RouteInfoResponse' route: Display information of a Compute Engine route.
        :param str state: Each step is in one of the pre-defined states.
        :param 'VpnGatewayInfoResponse' vpn_gateway: Display information of a Compute Engine VPN gateway.
        :param 'VpnTunnelInfoResponse' vpn_tunnel: Display information of a Compute Engine VPN tunnel.
        """
        pulumi.set(__self__, "abort", abort)
        pulumi.set(__self__, "causes_drop", causes_drop)
        pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        pulumi.set(__self__, "deliver", deliver)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "drop", drop)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "firewall", firewall)
        pulumi.set(__self__, "forward", forward)
        pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        pulumi.set(__self__, "gke_master", gke_master)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "load_balancer", load_balancer)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "route", route)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "vpn_gateway", vpn_gateway)
        pulumi.set(__self__, "vpn_tunnel", vpn_tunnel)

    @property
    @pulumi.getter
    def abort(self) -> 'outputs.AbortInfoResponse':
        """
        Display information of the final state "abort" and reason.
        """
        return pulumi.get(self, "abort")

    @property
    @pulumi.getter(name="causesDrop")
    def causes_drop(self) -> bool:
        """
        This is a step that leads to the final state Drop.
        """
        return pulumi.get(self, "causes_drop")

    @property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> 'outputs.CloudSQLInstanceInfoResponse':
        """
        Display information of a Cloud SQL instance.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @property
    @pulumi.getter
    def deliver(self) -> 'outputs.DeliverInfoResponse':
        """
        Display information of the final state "deliver" and reason.
        """
        return pulumi.get(self, "deliver")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the step. Usually this is a summary of the state.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def drop(self) -> 'outputs.DropInfoResponse':
        """
        Display information of the final state "drop" and reason.
        """
        return pulumi.get(self, "drop")

    @property
    @pulumi.getter
    def endpoint(self) -> 'outputs.EndpointInfoResponse':
        """
        Display information of the source and destination under analysis. The endpoint information in an intermediate state may differ with the initial input, as it might be modified by state like NAT, or Connection Proxy.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def firewall(self) -> 'outputs.FirewallInfoResponse':
        """
        Display information of a Compute Engine firewall rule.
        """
        return pulumi.get(self, "firewall")

    @property
    @pulumi.getter
    def forward(self) -> 'outputs.ForwardInfoResponse':
        """
        Display information of the final state "forward" and reason.
        """
        return pulumi.get(self, "forward")

    @property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> 'outputs.ForwardingRuleInfoResponse':
        """
        Display information of a Compute Engine forwarding rule.
        """
        return pulumi.get(self, "forwarding_rule")

    @property
    @pulumi.getter(name="gkeMaster")
    def gke_master(self) -> 'outputs.GKEMasterInfoResponse':
        """
        Display information of a Google Kubernetes Engine cluster master.
        """
        return pulumi.get(self, "gke_master")

    @property
    @pulumi.getter
    def instance(self) -> 'outputs.InstanceInfoResponse':
        """
        Display information of a Compute Engine instance.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> 'outputs.LoadBalancerInfoResponse':
        """
        Display information of the load balancers.
        """
        return pulumi.get(self, "load_balancer")

    @property
    @pulumi.getter
    def network(self) -> 'outputs.NetworkInfoResponse':
        """
        Display information of a Google Cloud network.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Project ID that contains the configuration this step is validating.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def route(self) -> 'outputs.RouteInfoResponse':
        """
        Display information of a Compute Engine route.
        """
        return pulumi.get(self, "route")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Each step is in one of the pre-defined states.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vpnGateway")
    def vpn_gateway(self) -> 'outputs.VpnGatewayInfoResponse':
        """
        Display information of a Compute Engine VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway")

    @property
    @pulumi.getter(name="vpnTunnel")
    def vpn_tunnel(self) -> 'outputs.VpnTunnelInfoResponse':
        """
        Display information of a Compute Engine VPN tunnel.
        """
        return pulumi.get(self, "vpn_tunnel")


@pulumi.output_type
class TraceResponse(dict):
    """
    Trace represents one simulated packet forwarding path. * Each trace contains multiple ordered steps. * Each step is in a particular state with associated configuration. * State is categorized as final or non-final states. * Each final state has a reason associated. * Each trace must end with a final state (the last step). ``` |---------------------Trace----------------------| Step1(State) Step2(State) --- StepN(State(final)) ```
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointInfo":
            suggest = "endpoint_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TraceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TraceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TraceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_info: 'outputs.EndpointInfoResponse',
                 steps: Sequence['outputs.StepResponse']):
        """
        Trace represents one simulated packet forwarding path. * Each trace contains multiple ordered steps. * Each step is in a particular state with associated configuration. * State is categorized as final or non-final states. * Each final state has a reason associated. * Each trace must end with a final state (the last step). ``` |---------------------Trace----------------------| Step1(State) Step2(State) --- StepN(State(final)) ```
        :param 'EndpointInfoResponse' endpoint_info: Derived from the source and destination endpoints definition specified by user request, and validated by the data plane model. If there are multiple traces starting from different source locations, then the endpoint_info may be different between traces.
        :param Sequence['StepResponse'] steps: A trace of a test contains multiple steps from the initial state to the final state (delivered, dropped, forwarded, or aborted). The steps are ordered by the processing sequence within the simulated network state machine. It is critical to preserve the order of the steps and avoid reordering or sorting them.
        """
        pulumi.set(__self__, "endpoint_info", endpoint_info)
        pulumi.set(__self__, "steps", steps)

    @property
    @pulumi.getter(name="endpointInfo")
    def endpoint_info(self) -> 'outputs.EndpointInfoResponse':
        """
        Derived from the source and destination endpoints definition specified by user request, and validated by the data plane model. If there are multiple traces starting from different source locations, then the endpoint_info may be different between traces.
        """
        return pulumi.get(self, "endpoint_info")

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.StepResponse']:
        """
        A trace of a test contains multiple steps from the initial state to the final state (delivered, dropped, forwarded, or aborted). The steps are ordered by the processing sequence within the simulated network state machine. It is critical to preserve the order of the steps and avoid reordering or sorting them.
        """
        return pulumi.get(self, "steps")


@pulumi.output_type
class VpnGatewayInfoResponse(dict):
    """
    For display only. Metadata associated with a Compute Engine VPN gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkUri":
            suggest = "network_uri"
        elif key == "vpnTunnelUri":
            suggest = "vpn_tunnel_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnGatewayInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnGatewayInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnGatewayInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 ip_address: str,
                 network_uri: str,
                 region: str,
                 uri: str,
                 vpn_tunnel_uri: str):
        """
        For display only. Metadata associated with a Compute Engine VPN gateway.
        :param str display_name: Name of a VPN gateway.
        :param str ip_address: IP address of the VPN gateway.
        :param str network_uri: URI of a Compute Engine network where the VPN gateway is configured.
        :param str region: Name of a Google Cloud region where this VPN gateway is configured.
        :param str uri: URI of a VPN gateway.
        :param str vpn_tunnel_uri: A VPN tunnel that is associated with this VPN gateway. There may be multiple VPN tunnels configured on a VPN gateway, and only the one relevant to the test is displayed.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network_uri", network_uri)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "vpn_tunnel_uri", vpn_tunnel_uri)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of a VPN gateway.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        IP address of the VPN gateway.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="networkUri")
    def network_uri(self) -> str:
        """
        URI of a Compute Engine network where the VPN gateway is configured.
        """
        return pulumi.get(self, "network_uri")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Name of a Google Cloud region where this VPN gateway is configured.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of a VPN gateway.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="vpnTunnelUri")
    def vpn_tunnel_uri(self) -> str:
        """
        A VPN tunnel that is associated with this VPN gateway. There may be multiple VPN tunnels configured on a VPN gateway, and only the one relevant to the test is displayed.
        """
        return pulumi.get(self, "vpn_tunnel_uri")


@pulumi.output_type
class VpnTunnelInfoResponse(dict):
    """
    For display only. Metadata associated with a Compute Engine VPN tunnel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "networkUri":
            suggest = "network_uri"
        elif key == "remoteGateway":
            suggest = "remote_gateway"
        elif key == "remoteGatewayIp":
            suggest = "remote_gateway_ip"
        elif key == "routingType":
            suggest = "routing_type"
        elif key == "sourceGateway":
            suggest = "source_gateway"
        elif key == "sourceGatewayIp":
            suggest = "source_gateway_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnTunnelInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnTunnelInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnTunnelInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 network_uri: str,
                 region: str,
                 remote_gateway: str,
                 remote_gateway_ip: str,
                 routing_type: str,
                 source_gateway: str,
                 source_gateway_ip: str,
                 uri: str):
        """
        For display only. Metadata associated with a Compute Engine VPN tunnel.
        :param str display_name: Name of a VPN tunnel.
        :param str network_uri: URI of a Compute Engine network where the VPN tunnel is configured.
        :param str region: Name of a Google Cloud region where this VPN tunnel is configured.
        :param str remote_gateway: URI of a VPN gateway at remote end of the tunnel.
        :param str remote_gateway_ip: Remote VPN gateway's IP address.
        :param str routing_type: Type of the routing policy.
        :param str source_gateway: URI of the VPN gateway at local end of the tunnel.
        :param str source_gateway_ip: Local VPN gateway's IP address.
        :param str uri: URI of a VPN tunnel.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "network_uri", network_uri)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "remote_gateway", remote_gateway)
        pulumi.set(__self__, "remote_gateway_ip", remote_gateway_ip)
        pulumi.set(__self__, "routing_type", routing_type)
        pulumi.set(__self__, "source_gateway", source_gateway)
        pulumi.set(__self__, "source_gateway_ip", source_gateway_ip)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of a VPN tunnel.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="networkUri")
    def network_uri(self) -> str:
        """
        URI of a Compute Engine network where the VPN tunnel is configured.
        """
        return pulumi.get(self, "network_uri")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Name of a Google Cloud region where this VPN tunnel is configured.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="remoteGateway")
    def remote_gateway(self) -> str:
        """
        URI of a VPN gateway at remote end of the tunnel.
        """
        return pulumi.get(self, "remote_gateway")

    @property
    @pulumi.getter(name="remoteGatewayIp")
    def remote_gateway_ip(self) -> str:
        """
        Remote VPN gateway's IP address.
        """
        return pulumi.get(self, "remote_gateway_ip")

    @property
    @pulumi.getter(name="routingType")
    def routing_type(self) -> str:
        """
        Type of the routing policy.
        """
        return pulumi.get(self, "routing_type")

    @property
    @pulumi.getter(name="sourceGateway")
    def source_gateway(self) -> str:
        """
        URI of the VPN gateway at local end of the tunnel.
        """
        return pulumi.get(self, "source_gateway")

    @property
    @pulumi.getter(name="sourceGatewayIp")
    def source_gateway_ip(self) -> str:
        """
        Local VPN gateway's IP address.
        """
        return pulumi.get(self, "source_gateway_ip")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of a VPN tunnel.
        """
        return pulumi.get(self, "uri")


