# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetTrialResult',
    'AwaitableGetTrialResult',
    'get_trial',
    'get_trial_output',
]

@pulumi.output_type
class GetTrialResult:
    def __init__(__self__, client_id=None, end_time=None, final_measurement=None, infeasible_reason=None, measurements=None, name=None, parameters=None, start_time=None, state=None, trial_infeasible=None):
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if final_measurement and not isinstance(final_measurement, dict):
            raise TypeError("Expected argument 'final_measurement' to be a dict")
        pulumi.set(__self__, "final_measurement", final_measurement)
        if infeasible_reason and not isinstance(infeasible_reason, str):
            raise TypeError("Expected argument 'infeasible_reason' to be a str")
        pulumi.set(__self__, "infeasible_reason", infeasible_reason)
        if measurements and not isinstance(measurements, list):
            raise TypeError("Expected argument 'measurements' to be a list")
        pulumi.set(__self__, "measurements", measurements)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parameters and not isinstance(parameters, list):
            raise TypeError("Expected argument 'parameters' to be a list")
        pulumi.set(__self__, "parameters", parameters)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if trial_infeasible and not isinstance(trial_infeasible, bool):
            raise TypeError("Expected argument 'trial_infeasible' to be a bool")
        pulumi.set(__self__, "trial_infeasible", trial_infeasible)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The identifier of the client that originally requested this trial.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Time at which the trial's status changed to COMPLETED.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="finalMeasurement")
    def final_measurement(self) -> 'outputs.GoogleCloudMlV1__MeasurementResponse':
        """
        The final measurement containing the objective value.
        """
        return pulumi.get(self, "final_measurement")

    @property
    @pulumi.getter(name="infeasibleReason")
    def infeasible_reason(self) -> str:
        """
        A human readable string describing why the trial is infeasible. This should only be set if trial_infeasible is true.
        """
        return pulumi.get(self, "infeasible_reason")

    @property
    @pulumi.getter
    def measurements(self) -> Sequence['outputs.GoogleCloudMlV1__MeasurementResponse']:
        """
        A list of measurements that are strictly lexicographically ordered by their induced tuples (steps, elapsed_time). These are used for early stopping computations.
        """
        return pulumi.get(self, "measurements")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the trial assigned by the service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GoogleCloudMlV1_Trial_ParameterResponse']:
        """
        The parameters of the trial.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Time at which the trial was started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The detailed state of a trial.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="trialInfeasible")
    def trial_infeasible(self) -> bool:
        """
        If true, the parameters in this trial are not attempted again.
        """
        return pulumi.get(self, "trial_infeasible")


class AwaitableGetTrialResult(GetTrialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrialResult(
            client_id=self.client_id,
            end_time=self.end_time,
            final_measurement=self.final_measurement,
            infeasible_reason=self.infeasible_reason,
            measurements=self.measurements,
            name=self.name,
            parameters=self.parameters,
            start_time=self.start_time,
            state=self.state,
            trial_infeasible=self.trial_infeasible)


def get_trial(location: Optional[str] = None,
              project: Optional[str] = None,
              study_id: Optional[str] = None,
              trial_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrialResult:
    """
    Gets a trial.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['studyId'] = study_id
    __args__['trialId'] = trial_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:ml/v1:getTrial', __args__, opts=opts, typ=GetTrialResult).value

    return AwaitableGetTrialResult(
        client_id=__ret__.client_id,
        end_time=__ret__.end_time,
        final_measurement=__ret__.final_measurement,
        infeasible_reason=__ret__.infeasible_reason,
        measurements=__ret__.measurements,
        name=__ret__.name,
        parameters=__ret__.parameters,
        start_time=__ret__.start_time,
        state=__ret__.state,
        trial_infeasible=__ret__.trial_infeasible)


@_utilities.lift_output_func(get_trial)
def get_trial_output(location: Optional[pulumi.Input[str]] = None,
                     project: Optional[pulumi.Input[Optional[str]]] = None,
                     study_id: Optional[pulumi.Input[str]] = None,
                     trial_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTrialResult]:
    """
    Gets a trial.
    """
    ...
