# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetGameServerClusterResult',
    'AwaitableGetGameServerClusterResult',
    'get_game_server_cluster',
    'get_game_server_cluster_output',
]

@pulumi.output_type
class GetGameServerClusterResult:
    def __init__(__self__, cluster_state=None, connection_info=None, create_time=None, description=None, etag=None, labels=None, name=None, update_time=None):
        if cluster_state and not isinstance(cluster_state, dict):
            raise TypeError("Expected argument 'cluster_state' to be a dict")
        pulumi.set(__self__, "cluster_state", cluster_state)
        if connection_info and not isinstance(connection_info, dict):
            raise TypeError("Expected argument 'connection_info' to be a dict")
        pulumi.set(__self__, "connection_info", connection_info)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="clusterState")
    def cluster_state(self) -> 'outputs.KubernetesClusterStateResponse':
        """
        The state of the Kubernetes cluster, this will be available if 'view' is set to `FULL` in the relevant List/Get/Preview request.
        """
        return pulumi.get(self, "cluster_state")

    @property
    @pulumi.getter(name="connectionInfo")
    def connection_info(self) -> 'outputs.GameServerClusterConnectionInfoResponse':
        """
        The game server cluster connection information. This information is used to manage game server clusters.
        """
        return pulumi.get(self, "connection_info")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Human readable description of the cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        ETag of the resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        The labels associated with this game server cluster. Each label is a key-value pair.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the game server cluster, in the following form: `projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}`. For example, `projects/my-project/locations/{location}/realms/zanzibar/gameServerClusters/my-onprem-cluster`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetGameServerClusterResult(GetGameServerClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGameServerClusterResult(
            cluster_state=self.cluster_state,
            connection_info=self.connection_info,
            create_time=self.create_time,
            description=self.description,
            etag=self.etag,
            labels=self.labels,
            name=self.name,
            update_time=self.update_time)


def get_game_server_cluster(game_server_cluster_id: Optional[str] = None,
                            location: Optional[str] = None,
                            project: Optional[str] = None,
                            realm_id: Optional[str] = None,
                            view: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGameServerClusterResult:
    """
    Gets details of a single game server cluster.
    """
    __args__ = dict()
    __args__['gameServerClusterId'] = game_server_cluster_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['realmId'] = realm_id
    __args__['view'] = view
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:gameservices/v1:getGameServerCluster', __args__, opts=opts, typ=GetGameServerClusterResult).value

    return AwaitableGetGameServerClusterResult(
        cluster_state=__ret__.cluster_state,
        connection_info=__ret__.connection_info,
        create_time=__ret__.create_time,
        description=__ret__.description,
        etag=__ret__.etag,
        labels=__ret__.labels,
        name=__ret__.name,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_game_server_cluster)
def get_game_server_cluster_output(game_server_cluster_id: Optional[pulumi.Input[str]] = None,
                                   location: Optional[pulumi.Input[str]] = None,
                                   project: Optional[pulumi.Input[Optional[str]]] = None,
                                   realm_id: Optional[pulumi.Input[str]] = None,
                                   view: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGameServerClusterResult]:
    """
    Gets details of a single game server cluster.
    """
    ...
